/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.spring;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.spring.ConfigurationPropertySource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration
public class TestConfigurationPropertySource {
    private static final String TEST_PROPERTY = "test.property";
    private static final String TEST_SYSTEM_PROPERTY = "test.system.property";
    private static final String TEST_VALUE = "testVALUE";
    @Value(value="${test.property}")
    private String value;
    @Value(value="${test.system.property}")
    private String systemPropertyValue;

    private static ConfigurationPropertySource createConfigPropertySource() {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.addProperty(TEST_PROPERTY, (Object)TEST_VALUE);
        propertiesConfiguration.addProperty(TEST_SYSTEM_PROPERTY, (Object)"${sys:test.system.property}");
        return new ConfigurationPropertySource("test configuration", (Configuration)propertiesConfiguration);
    }

    @BeforeAll
    public static void setUp() {
        System.setProperty(TEST_SYSTEM_PROPERTY, TEST_VALUE);
    }

    @AfterAll
    public static void tearDown() {
        System.clearProperty(TEST_SYSTEM_PROPERTY);
    }

    @Test
    public void testValueInjection() {
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.value);
    }

    @Test
    public void testSystemPropertyValueInjection() {
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.systemPropertyValue);
    }

    @org.springframework.context.annotation.Configuration
    static class Config {
        Config() {
        }

        @Bean
        public PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment env) {
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            MutablePropertySources sources = new MutablePropertySources();
            sources.addLast((PropertySource)TestConfigurationPropertySource.createConfigPropertySource());
            configurer.setPropertySources((PropertySources)sources);
            configurer.setEnvironment((Environment)env);
            return configurer;
        }
    }
}

