/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.NonCloneableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCompositeConfiguration {
    private static final String TEST_PROPERTY = "test.source.property";
    protected PropertiesConfiguration conf1;
    protected PropertiesConfiguration conf2;
    protected XMLConfiguration xmlConf;
    protected CompositeConfiguration cc;
    private final String testProperties = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private final String testProperties2 = ConfigurationAssert.getTestFile("test2.properties").getAbsolutePath();
    private final String testPropertiesXML = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();

    private void checkSetListDelimiterHandler() {
        this.cc.addProperty("test.list", (Object)"a/b/c");
        this.cc.addProperty("test.property", (Object)"a,b,c");
        Assertions.assertEquals((int)3, (int)this.cc.getList("test.list").size());
        Assertions.assertEquals((Object)"a,b,c", (Object)this.cc.getString("test.property"));
        AbstractConfiguration config = (AbstractConfiguration)this.cc.getInMemoryConfiguration();
        DefaultListDelimiterHandler listHandler = (DefaultListDelimiterHandler)config.getListDelimiterHandler();
        Assertions.assertEquals((char)'/', (char)listHandler.getDelimiter());
    }

    private SynchronizerTestImpl installSynchronizer() {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.cc.setSynchronizer((Synchronizer)sync);
        return sync;
    }

    private void prepareInterpolationTest() {
        PropertiesConfiguration p = new PropertiesConfiguration();
        p.addProperty("foo", (Object)"initial");
        p.addProperty("bar", (Object)"${foo}");
        p.addProperty("prefix.foo", (Object)"override");
        this.cc.addConfiguration(p.subset("prefix"));
        this.cc.addConfiguration((Configuration)p);
        Assertions.assertEquals((Object)"override", (Object)this.cc.getString("bar"));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.cc = new CompositeConfiguration();
        LegacyListDelimiterHandler listHandler = new LegacyListDelimiterHandler(',');
        this.conf1 = new PropertiesConfiguration();
        this.conf1.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler1 = new FileHandler((FileBased)this.conf1);
        handler1.setFileName(this.testProperties);
        handler1.load();
        this.conf2 = new PropertiesConfiguration();
        this.conf2.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler2 = new FileHandler((FileBased)this.conf2);
        handler2.setFileName(this.testProperties2);
        handler2.load();
        this.xmlConf = new XMLConfiguration();
        FileHandler handler3 = new FileHandler((FileBased)this.xmlConf);
        handler3.load(new File(this.testPropertiesXML));
        this.cc.setThrowExceptionOnMissing(true);
    }

    private void setUpSourceTest() {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
    }

    @Test
    public void testAddConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        this.cc.addConfiguration((Configuration)this.xmlConf);
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testAddFirstRemoveConfigurations() throws Exception {
        this.cc.addConfigurationFirst((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfigurationFirst((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfigurationFirst((Configuration)this.conf2);
        Assertions.assertEquals((int)3, (int)this.cc.getNumberOfConfigurations());
        this.cc.removeConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.clear();
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testAddingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Object[] values = this.cc.getStringArray("test.short");
        Assertions.assertArrayEquals((Object[])new String[]{"1"}, (Object[])values);
        this.cc.addProperty("test.short", (Object)"88");
        values = this.cc.getStringArray("test.short");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "88"}, (Object[])values);
    }

    @Test
    public void testAddRemoveConfigurations() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf2);
        Assertions.assertEquals((int)3, (int)this.cc.getNumberOfConfigurations());
        this.cc.removeConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.clear();
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testCantRemoveMemoryConfig() throws Exception {
        this.cc.clear();
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
        Configuration internal = this.cc.getConfiguration(0);
        this.cc.removeConfiguration(internal);
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testCheckingInMemoryConfiguration() throws Exception {
        String TEST_KEY = "testKey";
        PropertiesConfiguration defaults = new PropertiesConfiguration();
        defaults.setProperty("testKey", (Object)"testValue");
        CompositeConfiguration testConfiguration = new CompositeConfiguration((Configuration)defaults);
        Assertions.assertTrue((boolean)testConfiguration.containsKey("testKey"));
        Assertions.assertFalse((boolean)testConfiguration.isEmpty());
        boolean foundTestKey = false;
        Iterator i = testConfiguration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.equals("testKey")) continue;
            foundTestKey = true;
        }
        Assertions.assertTrue((boolean)foundTestKey);
        testConfiguration.clearProperty("testKey");
        Assertions.assertFalse((boolean)testConfiguration.containsKey("testKey"));
    }

    @Test
    public void testClearingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.clearProperty("test.short");
        Assertions.assertFalse((boolean)this.cc.containsKey("test.short"));
    }

    @Test
    public void testClone() {
        CompositeConfiguration cc2 = (CompositeConfiguration)this.cc.clone();
        Assertions.assertEquals((int)this.cc.getNumberOfConfigurations(), (int)cc2.getNumberOfConfigurations());
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        for (int i = 0; i < this.cc.getNumberOfConfigurations(); ++i) {
            Assertions.assertEquals(this.cc.getConfiguration(i).getClass(), cc2.getConfiguration(i).getClass(), (String)("Wrong configuration class at " + i));
            Assertions.assertNotSame((Object)this.cc.getConfiguration(i), (Object)cc2.getConfiguration(i));
            Assertions.assertTrue((boolean)comp.compare(this.cc.getConfiguration(i), cc2.getConfiguration(i)), (String)("Configurations at " + i + " not equal"));
        }
        Assertions.assertTrue((boolean)comp.compare((Configuration)this.cc, (Configuration)cc2));
    }

    @Test
    public void testCloneEventListener() {
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)new EventListenerTestImpl(null));
        CompositeConfiguration cc2 = (CompositeConfiguration)this.cc.clone();
        Assertions.assertTrue((boolean)cc2.getEventListeners(ConfigurationEvent.ANY).isEmpty());
    }

    @Test
    public void testCloneInterpolation() {
        CompositeConfiguration cc2 = (CompositeConfiguration)this.cc.clone();
        Assertions.assertNotSame((Object)this.cc.getInterpolator(), (Object)cc2.getInterpolator());
    }

    @Test
    public void testCloneNotSupported() {
        this.cc.addConfiguration((Configuration)new NonCloneableConfiguration());
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ((CompositeConfiguration)this.cc).clone());
    }

    @Test
    public void testDefaultValueWhenKeyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals((Object)"default", (Object)this.cc.getString("bogus", "default"));
        Assertions.assertEquals((double)1.4, (double)this.cc.getDouble("bogus", 1.4), (double)0.0);
        Assertions.assertEquals((double)1.4, (double)this.cc.getDouble("bogus", 1.4), (double)0.0);
    }

    @Test
    public void testEventAddProperty() {
        EventListenerTestImpl listener = new EventListenerTestImpl(this.cc);
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        this.cc.addProperty("test", (Object)"value");
        listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test", "value", true);
        listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test", "value", false);
        listener.done();
    }

    @Test
    public void testEventClearProperty() {
        this.cc.addConfiguration((Configuration)this.conf1);
        String key = "configuration.loaded";
        Assertions.assertTrue((boolean)this.cc.getBoolean("configuration.loaded"));
        EventListenerTestImpl listener = new EventListenerTestImpl(this.cc);
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        this.cc.clearProperty("configuration.loaded");
        Assertions.assertFalse((boolean)this.cc.containsKey("configuration.loaded"));
        listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, "configuration.loaded", null, true);
        listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, "configuration.loaded", null, false);
        listener.done();
    }

    @Test
    public void testEventSetProperty() {
        EventListenerTestImpl listener = new EventListenerTestImpl(this.cc);
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        this.cc.setProperty("test", (Object)"value");
        listener.checkEvent(ConfigurationEvent.SET_PROPERTY, "test", "value", true);
        listener.checkEvent(ConfigurationEvent.SET_PROPERTY, "test", "value", false);
        listener.done();
    }

    @Test
    public void testGetConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        Assertions.assertEquals((Object)this.conf1, (Object)this.cc.getConfiguration(0));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetInMemoryConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        this.cc.getInMemoryConfiguration();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetKeys2PreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList<String> orderedList = new ArrayList<String>();
        Iterator keys = this.conf1.getKeys("test");
        while (keys.hasNext()) {
            orderedList.add((String)keys.next());
        }
        ArrayList<String> iteratedList = new ArrayList<String>();
        Iterator keys2 = this.cc.getKeys("test");
        while (keys2.hasNext()) {
            iteratedList.add((String)keys2.next());
        }
        Assertions.assertEquals(orderedList, iteratedList);
    }

    @Test
    public void testGetKeysPreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList<String> orderedList = new ArrayList<String>();
        Iterator keys = this.conf1.getKeys();
        while (keys.hasNext()) {
            orderedList.add((String)keys.next());
        }
        ArrayList<String> iteratedList = new ArrayList<String>();
        Iterator keys2 = this.cc.getKeys();
        while (keys2.hasNext()) {
            iteratedList.add((String)keys2.next());
        }
        Assertions.assertEquals(orderedList, iteratedList);
    }

    @Test
    public void testGetList() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("array", (Object)"value1");
        conf1.addProperty("array", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("array", (Object)"value3");
        conf2.addProperty("array", (Object)"value4");
        this.cc.addConfiguration((Configuration)conf1);
        this.cc.addConfiguration((Configuration)conf2);
        List list = this.cc.getList("array");
        Assertions.assertEquals(Arrays.asList("value1", "value2"), (Object)list);
        this.cc.addProperty("array", (Object)"value5");
        list = this.cc.getList("array");
        Assertions.assertEquals(Arrays.asList("value1", "value2", "value5"), (Object)list);
    }

    @Test
    public void testGetListWithInterpolation() {
        this.prepareInterpolationTest();
        List lst = this.cc.getList("bar");
        Assertions.assertEquals(Arrays.asList("override"), (Object)lst);
    }

    @Test
    public void testGetNumberOfConfigurationsSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        Assertions.assertEquals((int)3, (int)this.cc.getNumberOfConfigurations());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assertions.assertEquals((Object)"test.properties", (Object)this.cc.getString("propertyInOrder"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.conf2);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((Object)"test2.properties", (Object)this.cc.getString("propertyInOrder"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfigurationFirst((Configuration)this.conf2);
        Assertions.assertEquals((Object)"test2.properties", (Object)this.cc.getString("propertyInOrder"));
        this.cc.clear();
    }

    @Test
    public void testGetPropertyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        NoSuchElementException nsee = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> this.cc.getString("bogus.property"));
        Assertions.assertTrue((boolean)nsee.getMessage().contains("bogus.property"));
        Assertions.assertFalse((boolean)this.cc.getBoolean("test.missing.boolean", false));
        Assertions.assertTrue((boolean)this.cc.getBoolean("test.missing.boolean.true", true));
    }

    @Test
    public void testGetPropertyWIncludes() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        List l = this.cc.getList("packages");
        Assertions.assertTrue((boolean)l.contains("packagea"));
    }

    @Test
    public void testGetSourceInMemory() {
        this.setUpSourceTest();
        this.cc.addProperty(TEST_PROPERTY, (Object)Boolean.TRUE);
        Assertions.assertSame((Object)this.cc.getInMemoryConfiguration(), (Object)this.cc.getSource(TEST_PROPERTY));
    }

    @Test
    public void testGetSourceMultiple() {
        this.setUpSourceTest();
        this.conf1.addProperty(TEST_PROPERTY, (Object)Boolean.TRUE);
        this.cc.addProperty(TEST_PROPERTY, (Object)"a value");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cc.getSource(TEST_PROPERTY));
    }

    @Test
    public void testGetSourceNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cc.getSource(null));
    }

    @Test
    public void testGetSourceSingle() {
        this.setUpSourceTest();
        this.conf1.addProperty(TEST_PROPERTY, (Object)Boolean.TRUE);
        Assertions.assertSame((Object)this.conf1, (Object)this.cc.getSource(TEST_PROPERTY));
    }

    @Test
    public void testGetSourceUnknown() {
        this.setUpSourceTest();
        Assertions.assertNull((Object)this.cc.getSource(TEST_PROPERTY));
    }

    @Test
    public void testGetStringArrayWithInterpolation() {
        this.prepareInterpolationTest();
        Object[] values = this.cc.getStringArray("bar");
        Assertions.assertArrayEquals((Object[])new String[]{"override"}, (Object[])values);
    }

    @Test
    public void testGetStringWithDefaults() {
        BaseConfiguration defaults = new BaseConfiguration();
        defaults.addProperty("default", (Object)"default string");
        CompositeConfiguration c = new CompositeConfiguration((Configuration)defaults);
        c.setThrowExceptionOnMissing(this.cc.isThrowExceptionOnMissing());
        c.addProperty("string", (Object)"test string");
        Assertions.assertEquals((Object)"test string", (Object)c.getString("string"));
        Assertions.assertThrows(NoSuchElementException.class, () -> c.getString("XXX"));
        Assertions.assertEquals((Object)"test string", (Object)c.getString("string", "some default value"));
        Assertions.assertEquals((Object)"default string", (Object)c.getString("default"));
        Assertions.assertEquals((Object)"default string", (Object)c.getString("default", "some default value"));
        Assertions.assertEquals((Object)"some default value", (Object)c.getString("XXX", "some default value"));
    }

    @Test
    public void testGettingConfiguration() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals(PropertiesConfiguration.class, this.cc.getConfiguration(0).getClass());
        Assertions.assertEquals(XMLConfiguration.class, this.cc.getConfiguration(1).getClass());
    }

    @Test
    public void testGettingSubset() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Configuration subset = this.cc.subset("test");
        Assertions.assertNotNull((Object)subset);
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((Object)"1", (Object)subset.getString("short"));
        this.cc.setProperty("test.short", (Object)"43");
        subset = this.cc.subset("test");
        Assertions.assertEquals((Object)"43", (Object)subset.getString("short"));
    }

    @Test
    public void testInstanciateWithCollection() {
        ArrayList<Object> configs = new ArrayList<Object>();
        configs.add(this.xmlConf);
        configs.add(this.conf1);
        configs.add(this.conf2);
        CompositeConfiguration config = new CompositeConfiguration(configs);
        Assertions.assertEquals((int)4, (int)config.getNumberOfConfigurations());
        Assertions.assertTrue((boolean)config.getInMemoryConfiguration().isEmpty());
    }

    @Test
    public void testInterpolationArrayReference() {
        PropertiesConfiguration props = new PropertiesConfiguration();
        Object[] values = new String[]{"a", "property", "with", "multiple", "values"};
        props.addProperty("keyMultiValues", (Object)values);
        props.addProperty("keyReference", (Object)"${keyMultiValues}");
        this.cc.addConfiguration((Configuration)props);
        Assertions.assertArrayEquals((Object[])values, (Object[])this.cc.getStringArray("keyReference"));
    }

    @Test
    public void testInterpolationInMultipleConfigs() {
        PropertiesConfiguration c1 = new PropertiesConfiguration();
        c1.addProperty("property.one", (Object)"one");
        c1.addProperty("property.two", (Object)"two");
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c2.addProperty("property.one.ref", (Object)"${property.one}");
        this.cc.addConfiguration((Configuration)c1);
        this.cc.addConfiguration((Configuration)c2);
        Assertions.assertEquals((Object)"one", (Object)this.cc.getString("property.one.ref"));
    }

    @Test
    public void testList() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        List packages = this.cc.getList("packages");
        Assertions.assertEquals((int)3, (int)packages.size());
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("1");
        defaultList.add("2");
        packages = this.cc.getList("packages.which.dont.exist", defaultList);
        Assertions.assertEquals((int)2, (int)packages.size());
    }

    @Test
    public void testListInterpolation() {
        PropertiesConfiguration c1 = new PropertiesConfiguration();
        c1.addProperty("c1.value", (Object)"test1");
        c1.addProperty("c1.value", (Object)"${c2.value}");
        this.cc.addConfiguration((Configuration)c1);
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c2.addProperty("c2.value", (Object)"test2");
        this.cc.addConfiguration((Configuration)c2);
        List lst = this.cc.getList("c1.value");
        Assertions.assertEquals(Arrays.asList("test1", "test2"), (Object)lst);
    }

    @Test
    public void testMultipleTypesOfConfigs() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals((int)1, (int)this.cc.getInt("test.short"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)8, (int)this.cc.getInt("test.short"));
    }

    @Test
    public void testPropertyExistsInOnlyOneConfig() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals((Object)"value", (Object)this.cc.getString("element"));
    }

    @Test
    public void testRemoveConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        this.cc.removeConfiguration((Configuration)this.conf1);
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testReplaceInMemoryConfig() {
        this.conf1.setProperty(TEST_PROPERTY, (Object)"conf1");
        this.conf2.setProperty(TEST_PROPERTY, (Object)"conf2");
        this.cc.addConfiguration((Configuration)this.conf1, true);
        this.cc.addProperty("newProperty1", (Object)"newValue1");
        this.cc.addConfiguration((Configuration)this.conf2, true);
        this.cc.addProperty("newProperty2", (Object)"newValue2");
        Assertions.assertEquals((Object)"conf1", (Object)this.cc.getString(TEST_PROPERTY));
        Assertions.assertEquals((Object)"newValue1", (Object)this.conf1.getString("newProperty1"));
        Assertions.assertEquals((Object)"newValue2", (Object)this.conf2.getString("newProperty2"));
    }

    @Test
    public void testSetListDelimiter() {
        this.cc.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('/'));
        this.checkSetListDelimiterHandler();
    }

    @Test
    public void testSetListDelimiterAfterClear() {
        this.cc.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('/'));
        this.cc.clear();
        this.checkSetListDelimiterHandler();
    }

    @Test
    public void testSetListDelimiterInMemoryConfigNonBaseConfig() {
        Configuration inMemoryConfig = (Configuration)Mockito.mock(Configuration.class);
        this.cc = new CompositeConfiguration(inMemoryConfig);
        Assertions.assertDoesNotThrow(() -> this.cc.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';')));
    }

    @Test
    public void testSettingMissingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.setProperty("my.new.property", (Object)"supernew");
        Assertions.assertEquals((Object)"supernew", (Object)this.cc.getString("my.new.property"));
    }

    @Test
    public void testStringArray() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        String[] packages = this.cc.getStringArray("packages");
        Assertions.assertEquals((int)3, (int)packages.length);
        packages = this.cc.getStringArray("packages.which.dont.exist");
        Assertions.assertEquals((int)0, (int)packages.length);
    }

    @Test
    public void testStringArrayInterpolation() {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addProperty("base", (Object)"foo");
        config.addProperty("list", (Object)"${base}.bar1");
        config.addProperty("list", (Object)"${base}.bar2");
        config.addProperty("list", (Object)"${base}.bar3");
        Object[] array = config.getStringArray("list");
        Assertions.assertArrayEquals((Object[])new String[]{"foo.bar1", "foo.bar2", "foo.bar3"}, (Object[])array);
    }

    @Test
    public void testSubsetCanResolve() throws Exception {
        this.cc = new CompositeConfiguration();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("subset.tempfile", (Object)"${java.io.tmpdir}/file.tmp");
        this.cc.addConfiguration((Configuration)config);
        this.cc.addConfiguration(ConfigurationConverter.getConfiguration((Properties)System.getProperties()));
        Configuration subset = this.cc.subset("subset");
        Assertions.assertEquals((Object)(FileUtils.getTempDirectoryPath() + "/file.tmp"), (Object)subset.getString("tempfile"));
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assertions.assertTrue((boolean)this.cc.isThrowExceptionOnMissing());
    }

    @Test
    public void testUseChildConfigAsInMemoryConfig() {
        this.conf1.setProperty(TEST_PROPERTY, (Object)"conf1");
        this.conf2.setProperty(TEST_PROPERTY, (Object)"conf2");
        this.cc.addConfiguration((Configuration)this.conf1, true);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        Assertions.assertEquals((Object)"conf1", (Object)this.cc.getString(TEST_PROPERTY));
        this.cc.addProperty("newProperty", (Object)"newValue");
        Assertions.assertEquals((Object)"newValue", (Object)this.conf1.getString("newProperty"));
    }
}

