/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.harmony.pack200.Archive;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PackingOptions;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ArchiveTest
extends AbstractTempDirTest {
    static Stream<Arguments> loadMultipleJars() throws URISyntaxException, IOException {
        return Files.list(Paths.get(Archive.class.getResource("/pack200/jars").toURI())).filter(child -> {
            String fileName = child.getFileName().toString();
            return fileName.endsWith(".jar") && !fileName.endsWith("Unpacked.jar");
        }).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private void compareFiles(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            Assertions.assertNotNull((Object)entry2, (String)("Missing Entry: " + name));
            if (name.equals("META-INF/MANIFEST.MF")) continue;
            InputStream ours = jarFile.getInputStream(entry);
            InputStream expected = jarFile2.getInputStream(entry2);
            try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                 BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                String line1 = reader1.readLine();
                String line2 = reader2.readLine();
                while (line1 != null || line2 != null) {
                    Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked files differ for " + name));
                    line1 = reader1.readLine();
                    line2 = reader2.readLine();
                }
            }
        }
    }

    private void compareJarEntries(JarFile jarFile, JarFile jarFile2) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            Assertions.assertNotNull((Object)entry2, (String)("Missing Entry: " + name));
        }
    }

    @Test
    public void testAlternativeConstructor() throws IOException, URISyntaxException, Pack200Exception {
        File file = this.createTempFile("sql", ".pack.gz");
        try (JarInputStream inStream = new JarInputStream(new FileInputStream(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI())));
             FileOutputStream out = new FileOutputStream(file);){
            new Archive(inStream, (OutputStream)out, null).pack();
        }
    }

    @Test
    public void testAnnotations() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("annotations", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/annotationsUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("annotationsout", ".jar");
        try (FileInputStream in2 = new FileInputStream(file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/annotationsUnpacked.jar").toURI()));){
            this.compareFiles(jarFile, jarFile2);
        }
    }

    @Test
    public void testAnnotations2() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("annotations", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/annotations.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("annotationsout", ".jar");
        try (FileInputStream in2 = new FileInputStream(file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/annotationsRI.jar").toURI()));){
            this.compareFiles(jarFile, jarFile2);
        }
    }

    @Test
    public void testHelloWorld() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("helloworld", ".pack.gz");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            new Archive(in, (OutputStream)out, null).pack();
        }
        File file2 = this.createTempFile("helloworld", ".jar");
        try (FileInputStream in2 = new FileInputStream(file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file2);){
            JarEntry entry = jarFile.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
            Assertions.assertNotNull((Object)entry);
            try (InputStream ours = jarFile.getInputStream(entry);){
                JarFile jarFile2 = new JarFile(new File(Segment.class.getResource("/pack200/hw.jar").toURI()));
                JarEntry entry2 = jarFile2.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
                Assertions.assertNotNull((Object)entry2);
                InputStream expected = jarFile2.getInputStream(entry2);
                try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                     BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                    String line1 = reader1.readLine();
                    String line2 = reader2.readLine();
                    int i = 1;
                    while (line1 != null || line2 != null) {
                        Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked class files differ, i = " + i));
                        line1 = reader1.readLine();
                        line2 = reader2.readLine();
                        ++i;
                    }
                }
            }
        }
    }

    @Test
    public void testJNDI() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("jndi", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/jndi.jar").toURI()));){
            FileOutputStream out = new FileOutputStream(file);
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
            out.close();
        }
        File file2 = this.createTempFile("jndiout", ".jar");
        try (FileInputStream in2 = new FileInputStream(file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/jndiUnpacked.jar").toURI()));){
            this.compareFiles(jarFile, jarFile2);
        }
    }

    @Test
    public void testLargeClass() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("largeClass", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/largeClassUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("largeClassOut", ".jar");
        try (FileInputStream in2 = new FileInputStream(file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            archive.unpack();
        }
        File compareFile = new File(Archive.class.getResource("/pack200/largeClassUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareFiles(jarFile, jarFile2);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"loadMultipleJars"})
    public void testMultipleJars(Path path) throws IOException, Pack200Exception {
        File file = this.createTempFile("temp", ".pack.gz");
        File inputFile = path.toFile();
        try (JarFile in = new JarFile(inputFile);
             FileOutputStream out = new FileOutputStream(file);){
            new Archive(in, (OutputStream)out, null).pack();
        }
    }

    @Test
    public void testSQL() throws IOException, Pack200Exception, URISyntaxException {
        File file = this.createTempFile("sql", ".pack");
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            new Archive(in, (OutputStream)out, options).pack();
        }
        File file2 = this.createTempFile("sqlout", ".jar");
        try (FileInputStream in2 = new FileInputStream(file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            archive.unpack();
        }
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareFiles(jarFile, jarFile2);
        }
    }

    @Test
    public void testWithAnnotations2() throws Exception {
        File file = this.createTempFile("annotations", ".jar");
        try (InputStream input = Archive.class.getResourceAsStream("/pack200/annotationsRI.pack.gz");
             JarOutputStream jout = new JarOutputStream(new FileOutputStream(file));){
            org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive(input, jout);
            archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file);
             JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/annotationsRI.jar").toURI()));){
            this.compareFiles(jarFile, jarFile2);
        }
    }
}

