/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.CharsetNames;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CompressorStreamFactoryRoundtripTest {
    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"bzip2"}), Arguments.of((Object[])new Object[]{"deflate"}), Arguments.of((Object[])new Object[]{"gz"}), Arguments.of((Object[])new Object[]{"xz"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCompressorStreamFactoryRoundtrip(String compressorName) throws Exception {
        CompressorStreamFactory factory = new CompressorStreamFactory();
        ByteArrayOutputStream compressedOs = new ByteArrayOutputStream();
        String fixture = "The quick brown fox jumps over the lazy dog";
        try (CompressorOutputStream compressorOutputStream = factory.createCompressorOutputStream(compressorName, (OutputStream)compressedOs);){
            compressorOutputStream.write("The quick brown fox jumps over the lazy dog".getBytes(CharsetNames.UTF_8));
            compressorOutputStream.flush();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(compressedOs.toByteArray());
        try (CompressorInputStream compressorInputStream = factory.createCompressorInputStream(compressorName, (InputStream)is, false);
             ByteArrayOutputStream decompressedOs = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)compressorInputStream, (OutputStream)decompressedOs);
            compressorInputStream.close();
            decompressedOs.flush();
            decompressedOs.close();
            Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)decompressedOs.toString(CharsetNames.UTF_8));
        }
    }
}

