/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.utils.CharsetNames;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CpioArchiveInputStreamTest
extends AbstractTest {
    private long consumeEntries(CpioArchiveInputStream in) throws IOException {
        CpioArchiveEntry entry;
        long count = 0L;
        while ((entry = in.getNextEntry()) != null) {
            ++count;
            Assertions.assertNotNull((Object)entry);
        }
        return count;
    }

    @Test
    public void testCpioUnarchive() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("./test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>./test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        StringBuilder result = new StringBuilder();
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(CpioArchiveInputStreamTest.newInputStream("bla.cpio"));){
            CpioArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                int tmp;
                result.append(entry.getName());
                while ((tmp = in.read()) != -1) {
                    result.append((char)tmp);
                }
            }
        }
        Assertions.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testCpioUnarchiveCreatedByRedlineRpm() throws Exception {
        long count = 0L;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(CpioArchiveInputStreamTest.newInputStream("redline.cpio"));){
            count = this.consumeEntries(in);
        }
        Assertions.assertEquals((long)count, (long)1L);
    }

    @Test
    public void testCpioUnarchiveMultibyteCharName() throws Exception {
        long count = 0L;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(CpioArchiveInputStreamTest.newInputStream("COMPRESS-459.cpio"), CharsetNames.UTF_8);){
            count = this.consumeEntries(in);
        }
        Assertions.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testInvalidLongValueInMetadata() throws Exception {
        try (InputStream in = CpioArchiveInputStreamTest.newInputStream("org/apache/commons/compress/cpio/bad_long_value.cpio");
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> ((CpioArchiveInputStream)archive).getNextEntry());
        }
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = CpioArchiveInputStreamTest.newInputStream("bla.cpio");
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = CpioArchiveInputStreamTest.newInputStream("bla.cpio");
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }
}

