/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections4.sequence.CommandVisitor;
import org.apache.commons.collections4.sequence.SequencesComparator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SequencesComparatorTest {
    private List<String> before;
    private List<String> after;
    private int[] length;

    @Test
    public void testLength() {
        for (int i = 0; i < this.before.size(); ++i) {
            SequencesComparator comparator = new SequencesComparator(this.sequence(this.before.get(i)), this.sequence(this.after.get(i)));
            Assert.assertEquals((long)this.length[i], (long)comparator.getScript().getModifications());
        }
    }

    @Test
    public void testExecution() {
        ExecutionVisitor<Character> ev = new ExecutionVisitor<Character>();
        for (int i = 0; i < this.before.size(); ++i) {
            ev.setList(this.sequence(this.before.get(i)));
            new SequencesComparator(this.sequence(this.before.get(i)), this.sequence(this.after.get(i))).getScript().visit(ev);
            Assert.assertEquals((Object)this.after.get(i), (Object)ev.getString());
        }
    }

    @Test
    public void testMinimal() {
        String[] shadokAlph = new String[]{new String("GA"), new String("BU"), new String("ZO"), new String("MEU")};
        ArrayList<String> sentenceBefore = new ArrayList<String>();
        ArrayList<String> sentenceAfter = new ArrayList<String>();
        sentenceBefore.add(shadokAlph[0]);
        sentenceBefore.add(shadokAlph[2]);
        sentenceBefore.add(shadokAlph[3]);
        sentenceBefore.add(shadokAlph[1]);
        sentenceBefore.add(shadokAlph[0]);
        sentenceBefore.add(shadokAlph[0]);
        sentenceBefore.add(shadokAlph[2]);
        sentenceBefore.add(shadokAlph[1]);
        sentenceBefore.add(shadokAlph[3]);
        sentenceBefore.add(shadokAlph[0]);
        sentenceBefore.add(shadokAlph[2]);
        sentenceBefore.add(shadokAlph[1]);
        sentenceBefore.add(shadokAlph[3]);
        sentenceBefore.add(shadokAlph[2]);
        sentenceBefore.add(shadokAlph[2]);
        sentenceBefore.add(shadokAlph[0]);
        sentenceBefore.add(shadokAlph[1]);
        sentenceBefore.add(shadokAlph[3]);
        sentenceBefore.add(shadokAlph[0]);
        sentenceBefore.add(shadokAlph[3]);
        Random random = new Random(4564634237452342L);
        for (int nbCom = 0; nbCom <= 40; nbCom += 5) {
            sentenceAfter.clear();
            sentenceAfter.addAll(sentenceBefore);
            for (int i = 0; i < nbCom; ++i) {
                if (random.nextInt(2) == 0) {
                    sentenceAfter.add(random.nextInt(sentenceAfter.size() + 1), shadokAlph[random.nextInt(4)]);
                    continue;
                }
                sentenceAfter.remove(random.nextInt(sentenceAfter.size()));
            }
            SequencesComparator comparator = new SequencesComparator(sentenceBefore, sentenceAfter);
            Assert.assertTrue((comparator.getScript().getModifications() <= nbCom ? 1 : 0) != 0);
        }
    }

    @Test
    public void testShadok() {
        int lgMax = 5;
        String[] shadokAlph = new String[]{new String("GA"), new String("BU"), new String("ZO"), new String("MEU")};
        ArrayList shadokSentences = new ArrayList();
        for (int lg = 0; lg < 5; ++lg) {
            ArrayList newTab = new ArrayList();
            newTab.add(new ArrayList());
            for (String element : shadokAlph) {
                for (List sentence : shadokSentences) {
                    ArrayList<String> newSentence = new ArrayList<String>(sentence);
                    newSentence.add(element);
                    newTab.add(newSentence);
                }
            }
            shadokSentences = newTab;
        }
        ExecutionVisitor ev = new ExecutionVisitor();
        for (int i = 0; i < shadokSentences.size(); ++i) {
            for (List shadokSentence : shadokSentences) {
                ev.setList((List)shadokSentences.get(i));
                new SequencesComparator((List)shadokSentences.get(i), shadokSentence).getScript().visit(ev);
                StringBuilder concat = new StringBuilder();
                for (String s : shadokSentence) {
                    concat.append(s);
                }
                Assert.assertEquals((Object)concat.toString(), (Object)ev.getString());
            }
        }
    }

    private List<Character> sequence(String string) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < string.length(); ++i) {
            list.add(new Character(string.charAt(i)));
        }
        return list;
    }

    @Before
    public void setUp() {
        this.before = Arrays.asList("bottle", "nematode knowledge", "", "aa", "prefixed string", "ABCABBA", "glop glop", "coq", "spider-man");
        this.after = Arrays.asList("noodle", "empty bottle", "", "C", "prefix", "CBABAC", "pas glop pas glop", "ane", "klingon");
        this.length = new int[]{6, 16, 0, 3, 9, 5, 8, 6, 13};
    }

    @After
    public void tearDown() {
        this.before = null;
        this.after = null;
        this.length = null;
    }

    private class ExecutionVisitor<T>
    implements CommandVisitor<T> {
        private List<T> v;
        private int index;

        private ExecutionVisitor() {
        }

        public void setList(List<T> array) {
            this.v = new ArrayList<T>(array);
            this.index = 0;
        }

        public void visitInsertCommand(T object) {
            this.v.add(this.index++, object);
        }

        public void visitKeepCommand(T object) {
            ++this.index;
        }

        public void visitDeleteCommand(T object) {
            this.v.remove(this.index);
        }

        public String getString() {
            StringBuilder buffer = new StringBuilder();
            for (T c : this.v) {
                buffer.append(c);
            }
            return buffer.toString();
        }
    }
}

