/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.TransformedMap;

public class TransformedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public TransformedMapTest(String testName) {
        super(testName);
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return TransformedMap.transformingMap(new HashMap(), (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.nopTransformer());
    }

    public void testTransformedMap() {
        int i;
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedMap map = TransformedMap.transformingMap(new HashMap(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, null);
        TransformedMapTest.assertEquals((int)0, (int)map.size());
        for (i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            TransformedMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedMapTest.assertEquals((boolean)true, (boolean)map.containsKey(Integer.valueOf((String)els[i])));
            TransformedMapTest.assertEquals((boolean)false, (boolean)map.containsKey(els[i]));
            TransformedMapTest.assertEquals((boolean)true, (boolean)map.containsValue(els[i]));
            TransformedMapTest.assertEquals((Object)els[i], map.get(Integer.valueOf((String)els[i])));
        }
        TransformedMapTest.assertEquals(null, map.remove(els[0]));
        TransformedMapTest.assertEquals((Object)els[0], map.remove(Integer.valueOf((String)els[0])));
        map = TransformedMap.transformingMap(new HashMap(), null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedMapTest.assertEquals((int)0, (int)map.size());
        for (i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            TransformedMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedMapTest.assertEquals((boolean)true, (boolean)map.containsValue(Integer.valueOf((String)els[i])));
            TransformedMapTest.assertEquals((boolean)false, (boolean)map.containsValue(els[i]));
            TransformedMapTest.assertEquals((boolean)true, (boolean)map.containsKey(els[i]));
            TransformedMapTest.assertEquals((Object)Integer.valueOf((String)els[i]), map.get(els[i]));
        }
        TransformedMapTest.assertEquals((Object)Integer.valueOf((String)els[0]), map.remove(els[0]));
        Set entrySet = map.entrySet();
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        array[0].setValue("66");
        TransformedMapTest.assertEquals((Object)66, array[0].getValue());
        TransformedMapTest.assertEquals((Object)66, map.get(array[0].getKey()));
        Map.Entry entry = entrySet.iterator().next();
        entry.setValue("88");
        TransformedMapTest.assertEquals((Object)88, entry.getValue());
        TransformedMapTest.assertEquals((Object)88, map.get(entry.getKey()));
    }

    public void testFactory_Decorate() {
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedMap trans = TransformedMap.transformingMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedMapTest.assertEquals((int)3, (int)trans.size());
        TransformedMapTest.assertEquals((Object)"1", trans.get("A"));
        TransformedMapTest.assertEquals((Object)"2", trans.get("B"));
        TransformedMapTest.assertEquals((Object)"3", trans.get("C"));
        trans.put("D", "4");
        TransformedMapTest.assertEquals((Object)4, trans.get("D"));
    }

    public void testFactory_decorateTransform() {
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedMap trans = TransformedMap.transformedMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedMapTest.assertEquals((int)3, (int)trans.size());
        TransformedMapTest.assertEquals((Object)1, trans.get("A"));
        TransformedMapTest.assertEquals((Object)2, trans.get("B"));
        TransformedMapTest.assertEquals((Object)3, trans.get("C"));
        trans.put("D", "4");
        TransformedMapTest.assertEquals((Object)4, trans.get("D"));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

