/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.collections4.keyvalue.MultiKey;

public class MultiKeyTest
extends TestCase {
    Integer ONE = 1;
    Integer TWO = 2;
    Integer THREE = 3;
    Integer FOUR = 4;
    Integer FIVE = 5;

    public void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConstructors() throws Exception {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO}, mk.getKeys()));
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO, this.THREE}, mk.getKeys()));
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO, this.THREE, this.FOUR}, mk.getKeys()));
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR, (Object)this.FIVE);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO, this.THREE, this.FOUR, this.FIVE}, mk.getKeys()));
        mk = new MultiKey((Object[])new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO}, false);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
    }

    public void testConstructorsByArray() throws Exception {
        Object[] keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys[3] = this.FIVE;
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys = new Integer[]{};
        mk = new MultiKey(keys);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[0], mk.getKeys()));
        keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        mk = new MultiKey(keys, true);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys[3] = this.FIVE;
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        mk = new MultiKey(keys, false);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys[3] = this.FIVE;
        MultiKeyTest.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.FIVE}, mk.getKeys()));
    }

    public void testConstructorsByArrayNull() throws Exception {
        Object[] keys = null;
        try {
            new MultiKey(keys);
            MultiKeyTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new MultiKey(keys, true);
            MultiKeyTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new MultiKey(keys, false);
            MultiKeyTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSize() {
        MultiKeyTest.assertEquals((int)2, (int)new MultiKey((Object)this.ONE, (Object)this.TWO).size());
        MultiKeyTest.assertEquals((int)2, (int)new MultiKey(null, null).size());
        MultiKeyTest.assertEquals((int)3, (int)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE).size());
        MultiKeyTest.assertEquals((int)3, (int)new MultiKey(null, null, null).size());
        MultiKeyTest.assertEquals((int)4, (int)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR).size());
        MultiKeyTest.assertEquals((int)4, (int)new MultiKey(null, null, null, null).size());
        MultiKeyTest.assertEquals((int)5, (int)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR, (Object)this.FIVE).size());
        MultiKeyTest.assertEquals((int)5, (int)new MultiKey(null, null, null, null, null).size());
        MultiKeyTest.assertEquals((int)0, (int)new MultiKey(new Object[0]).size());
        MultiKeyTest.assertEquals((int)1, (int)new MultiKey((Object[])new Integer[]{this.ONE}).size());
        MultiKeyTest.assertEquals((int)2, (int)new MultiKey((Object[])new Integer[]{this.ONE, this.TWO}).size());
        MultiKeyTest.assertEquals((int)7, (int)new MultiKey((Object[])new Integer[]{this.ONE, this.TWO, this.ONE, this.TWO, this.ONE, this.TWO, this.ONE}).size());
    }

    public void testGetIndexed() {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKeyTest.assertSame((Object)this.ONE, (Object)mk.getKey(0));
        MultiKeyTest.assertSame((Object)this.TWO, (Object)mk.getKey(1));
        try {
            mk.getKey(-1);
            MultiKeyTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            mk.getKey(2);
            MultiKeyTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetKeysSimpleConstructor() {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        Object[] array = mk.getKeys();
        MultiKeyTest.assertSame((Object)this.ONE, (Object)array[0]);
        MultiKeyTest.assertSame((Object)this.TWO, (Object)array[1]);
        MultiKeyTest.assertEquals((int)2, (int)array.length);
    }

    public void testGetKeysArrayConstructorCloned() {
        Object[] keys = new Integer[]{this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys, true);
        Object[] array = mk.getKeys();
        MultiKeyTest.assertTrue((array != keys ? 1 : 0) != 0);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(array, keys));
        MultiKeyTest.assertSame((Object)this.ONE, (Object)array[0]);
        MultiKeyTest.assertSame((Object)this.TWO, (Object)array[1]);
        MultiKeyTest.assertEquals((int)2, (int)array.length);
    }

    public void testGetKeysArrayConstructorNonCloned() {
        Object[] keys = new Integer[]{this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys, false);
        Object[] array = mk.getKeys();
        MultiKeyTest.assertTrue((array != keys ? 1 : 0) != 0);
        MultiKeyTest.assertTrue((boolean)Arrays.equals(array, keys));
        MultiKeyTest.assertSame((Object)this.ONE, (Object)array[0]);
        MultiKeyTest.assertSame((Object)this.TWO, (Object)array[1]);
        MultiKeyTest.assertEquals((int)2, (int)array.length);
    }

    public void testHashCode() {
        MultiKey mk1 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk3 = new MultiKey((Object)this.ONE, (Object)"TWO");
        MultiKeyTest.assertTrue((mk1.hashCode() == mk1.hashCode() ? 1 : 0) != 0);
        MultiKeyTest.assertTrue((mk1.hashCode() == mk2.hashCode() ? 1 : 0) != 0);
        MultiKeyTest.assertTrue((mk1.hashCode() != mk3.hashCode() ? 1 : 0) != 0);
        int total = 0 ^ this.ONE.hashCode() ^ this.TWO.hashCode();
        MultiKeyTest.assertEquals((int)total, (int)mk1.hashCode());
    }

    public void testEquals() {
        MultiKey mk1 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk3 = new MultiKey((Object)this.ONE, (Object)"TWO");
        MultiKeyTest.assertEquals((Object)mk1, (Object)mk1);
        MultiKeyTest.assertEquals((Object)mk1, (Object)mk2);
        MultiKeyTest.assertFalse((boolean)mk1.equals((Object)mk3));
        MultiKeyTest.assertFalse((boolean)mk1.equals((Object)""));
        MultiKeyTest.assertFalse((boolean)mk1.equals(null));
    }

    public void testEqualsAfterSerialization() throws IOException, ClassNotFoundException {
        SystemHashCodeSimulatingKey sysKey = new SystemHashCodeSimulatingKey("test");
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)sysKey);
        HashMap<MultiKey, Integer> map = new HashMap<MultiKey, Integer>();
        map.put(mk, this.TWO);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(sysKey);
        out.writeObject(map);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        sysKey = (SystemHashCodeSimulatingKey)in.readObject();
        Map map2 = (Map)in.readObject();
        in.close();
        MultiKeyTest.assertEquals((int)2, (int)sysKey.hashCode());
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)sysKey);
        MultiKeyTest.assertEquals((Object)this.TWO, map2.get(mk2));
    }

    public void testEqualsAfterSerializationOfDerivedClass() throws IOException, ClassNotFoundException {
        DerivedMultiKey<String> mk = new DerivedMultiKey<String>("A", "B");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(mk);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        DerivedMultiKey mk2 = (DerivedMultiKey)((Object)in.readObject());
        in.close();
        MultiKeyTest.assertEquals((int)mk.hashCode(), (int)mk2.hashCode());
    }

    static class DerivedMultiKey<T>
    extends MultiKey<T> {
        private static final long serialVersionUID = 1928896152249821416L;

        public DerivedMultiKey(T key1, T key2) {
            super(key1, key2);
        }

        public T getFirst() {
            return (T)this.getKey(0);
        }

        public T getSecond() {
            return (T)this.getKey(1);
        }
    }

    static class SystemHashCodeSimulatingKey
    implements Serializable {
        private static final long serialVersionUID = -1736147315703444603L;
        private final String name;
        private int hashCode = 1;

        public SystemHashCodeSimulatingKey(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            return obj instanceof SystemHashCodeSimulatingKey && this.name.equals(((SystemHashCodeSimulatingKey)obj).name);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private Object readResolve() {
            this.hashCode = 2;
            return this;
        }
    }
}

