/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public abstract class AbstractMapEntryTest<K, V>
extends TestCase {
    protected final String key = "name";
    protected final String value = "duke";

    public Map.Entry<K, V> makeMapEntry() {
        return this.makeMapEntry(null, null);
    }

    public abstract Map.Entry<K, V> makeMapEntry(K var1, V var2);

    public Map.Entry<K, V> makeKnownMapEntry() {
        return this.makeKnownMapEntry(null, null);
    }

    public Map.Entry<K, V> makeKnownMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        Map.Entry entry = map.entrySet().iterator().next();
        return entry;
    }

    public void testAccessorsAndMutators() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        AbstractMapEntryTest.assertTrue((entry.getKey() == "name" ? 1 : 0) != 0);
        entry.setValue("duke");
        AbstractMapEntryTest.assertTrue((entry.getValue() == "duke" ? 1 : 0) != 0);
        entry = this.makeMapEntry(null, null);
        AbstractMapEntryTest.assertTrue((entry.getKey() == null ? 1 : 0) != 0);
        entry.setValue(null);
        AbstractMapEntryTest.assertTrue((entry.getValue() == null ? 1 : 0) != 0);
    }

    public void testSelfReferenceHandling() {
        Map.Entry<K, Map.Entry<K, V>> entry = this.makeMapEntry();
        try {
            entry.setValue(entry);
            AbstractMapEntryTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            AbstractMapEntryTest.assertTrue((entry.getKey() == null && entry.getValue() == null ? 1 : 0) != 0);
        }
    }

    public abstract void testConstructors();

    public void testEqualsAndHashCode() {
        Map.Entry<String, String> e1 = this.makeMapEntry("name", "duke");
        Map.Entry<String, String> e2 = this.makeKnownMapEntry("name", "duke");
        AbstractMapEntryTest.assertTrue((boolean)e1.equals(e1));
        AbstractMapEntryTest.assertTrue((boolean)e2.equals(e1));
        AbstractMapEntryTest.assertTrue((boolean)e1.equals(e2));
        AbstractMapEntryTest.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
        e1 = this.makeMapEntry();
        e2 = this.makeKnownMapEntry();
        AbstractMapEntryTest.assertTrue((boolean)e1.equals(e1));
        AbstractMapEntryTest.assertTrue((boolean)e2.equals(e1));
        AbstractMapEntryTest.assertTrue((boolean)e1.equals(e2));
        AbstractMapEntryTest.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        AbstractMapEntryTest.assertTrue((boolean)entry.toString().equals(entry.getKey() + "=" + entry.getValue()));
        entry = this.makeMapEntry();
        AbstractMapEntryTest.assertTrue((boolean)entry.toString().equals(entry.getKey() + "=" + entry.getValue()));
    }
}

