/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.NotNullPredicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.apache.commons.collections4.iterators.FilterIterator;

public class FilterIteratorTest<E>
extends AbstractIteratorTest<E> {
    private String[] array;
    private List<E> list;
    private FilterIterator<E> iterator;

    public FilterIteratorTest(String name) {
        super(name);
    }

    public void setUp() {
        this.array = new String[]{"a", "b", "c"};
        this.initIterator();
    }

    public void tearDown() throws Exception {
        this.iterator = null;
    }

    @Override
    public FilterIterator<E> makeEmptyIterator() {
        return this.makeBlockAllFilter((Iterator<E>)new ArrayIterator((Object)this.array));
    }

    @Override
    public FilterIterator<E> makeObject() {
        this.list = new ArrayList<Object>(Arrays.asList((Object[])this.array));
        return this.makePassThroughFilter(this.list.iterator());
    }

    public void testRepeatedHasNext() {
        for (int i = 0; i <= this.array.length; ++i) {
            FilterIteratorTest.assertTrue((boolean)this.iterator.hasNext());
        }
    }

    public void testRepeatedNext() {
        for (String element : this.array) {
            this.iterator.next();
        }
        this.verifyNoMoreElements();
    }

    public void testReturnValues() {
        this.verifyElementsInPredicate(new String[0]);
        this.verifyElementsInPredicate(new String[]{"a"});
        this.verifyElementsInPredicate(new String[]{"b"});
        this.verifyElementsInPredicate(new String[]{"c"});
        this.verifyElementsInPredicate(new String[]{"a", "b"});
        this.verifyElementsInPredicate(new String[]{"a", "c"});
        this.verifyElementsInPredicate(new String[]{"b", "c"});
        this.verifyElementsInPredicate(new String[]{"a", "b", "c"});
    }

    public void testSetIterator() {
        Iterator<Object> iter1 = Collections.singleton(new Object()).iterator();
        Iterator iter2 = Collections.emptyList().iterator();
        FilterIterator filterIterator = new FilterIterator(iter1);
        filterIterator.setPredicate(TruePredicate.truePredicate());
        FilterIteratorTest.assertEquals((boolean)true, (boolean)filterIterator.hasNext());
        filterIterator.setIterator(iter2);
        FilterIteratorTest.assertEquals((boolean)false, (boolean)filterIterator.hasNext());
    }

    public void testSetPredicate() {
        Iterator<Object> iter = Collections.singleton(null).iterator();
        FilterIterator filterIterator = new FilterIterator(iter);
        filterIterator.setPredicate(TruePredicate.truePredicate());
        FilterIteratorTest.assertEquals((boolean)true, (boolean)filterIterator.hasNext());
        filterIterator.setPredicate(NotNullPredicate.notNullPredicate());
        FilterIteratorTest.assertEquals((boolean)false, (boolean)filterIterator.hasNext());
    }

    private void verifyNoMoreElements() {
        FilterIteratorTest.assertTrue((!this.iterator.hasNext() ? 1 : 0) != 0);
        try {
            this.iterator.next();
            FilterIteratorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void verifyElementsInPredicate(final String[] elements) {
        Predicate pred = new Predicate<E>(){

            public boolean evaluate(E x) {
                for (String element : elements) {
                    if (!element.equals(x)) continue;
                    return true;
                }
                return false;
            }
        };
        this.initIterator();
        this.iterator.setPredicate(pred);
        for (int i = 0; i < elements.length; ++i) {
            String s = (String)this.iterator.next();
            FilterIteratorTest.assertEquals((String)elements[i], (String)s);
            FilterIteratorTest.assertTrue((boolean)(i == elements.length - 1 ? !this.iterator.hasNext() : this.iterator.hasNext()));
        }
        this.verifyNoMoreElements();
        this.initIterator();
        this.iterator.setPredicate(pred);
        if (this.iterator.hasNext()) {
            Object last = this.iterator.next();
            this.iterator.remove();
            FilterIteratorTest.assertTrue((String)"Base of FilterIterator still contains removed element.", (!this.list.contains(last) ? 1 : 0) != 0);
        }
    }

    private void initIterator() {
        this.iterator = this.makeObject();
    }

    protected FilterIterator<E> makePassThroughFilter(Iterator<E> i) {
        Predicate pred = new Predicate<E>(){

            public boolean evaluate(E x) {
                return true;
            }
        };
        return new FilterIterator(i, pred);
    }

    protected FilterIterator<E> makeBlockAllFilter(Iterator<E> i) {
        Predicate pred = new Predicate<E>(){

            public boolean evaluate(E x) {
                return false;
            }
        };
        return new FilterIterator(i, pred);
    }
}

