/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractAnyAllOnePredicateTest;
import org.apache.commons.collections4.functors.AllPredicate;
import org.junit.Assert;
import org.junit.Test;

public class AllPredicateTest
extends AbstractAnyAllOnePredicateTest<Integer> {
    public AllPredicateTest() {
        super(42);
    }

    @Override
    protected final Predicate<Integer> getPredicateInstance(Predicate<? super Integer> ... predicates) {
        return AllPredicate.allPredicate(predicates);
    }

    @Override
    protected final Predicate<Integer> getPredicateInstance(Collection<Predicate<Integer>> predicates) {
        return AllPredicate.allPredicate(predicates);
    }

    @Test
    public void emptyArrayToGetInstance() {
        Assert.assertTrue((String)"empty array not true", (boolean)this.getPredicateInstance((Predicate<? super Integer>[])new Predicate[0]).evaluate(null));
    }

    @Test
    public void emptyCollectionToGetInstance() {
        Predicate<Integer> allPredicate = this.getPredicateInstance((Collection<Predicate<Integer>>)Collections.<Predicate<Integer>>emptyList());
        Assert.assertTrue((String)"empty collection not true", (boolean)allPredicate.evaluate(this.getTestValue()));
    }

    @Test
    public void oneTruePredicate() {
        Predicate predicate = this.createMockPredicate(true);
        Assert.assertTrue((String)"single true predicate evaluated to false", (boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{predicate}).evaluate(this.getTestValue()));
    }

    @Test
    public void oneFalsePredicate() {
        Predicate predicate = this.createMockPredicate(false);
        Assert.assertFalse((String)"single false predicate evaluated to true", (boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{predicate}).evaluate(this.getTestValue()));
    }

    @Test
    public void allTrue() {
        Assert.assertTrue((String)"multiple true predicates evaluated to false", (boolean)this.getPredicateInstance(true, true).evaluate(this.getTestValue()));
        Assert.assertTrue((String)"multiple true predicates evaluated to false", (boolean)this.getPredicateInstance(true, true, true).evaluate(this.getTestValue()));
    }

    @Test
    public void trueAndFalseCombined() {
        Assert.assertFalse((String)"false predicate evaluated to true", (boolean)this.getPredicateInstance(false, null).evaluate(this.getTestValue()));
        Assert.assertFalse((String)"false predicate evaluated to true", (boolean)this.getPredicateInstance(false, null, null).evaluate(this.getTestValue()));
        Assert.assertFalse((String)"false predicate evaluated to true", (boolean)this.getPredicateInstance(true, false, null).evaluate(this.getTestValue()));
        Assert.assertFalse((String)"false predicate evaluated to true", (boolean)this.getPredicateInstance(true, true, false).evaluate(this.getTestValue()));
        Assert.assertFalse((String)"false predicate evaluated to true", (boolean)this.getPredicateInstance(true, true, false, null).evaluate(this.getTestValue()));
    }
}

