/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Arrays;
import junit.framework.Test;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.UnmodifiableBag;

public class UnmodifiableBagTest<E>
extends AbstractBagTest<E> {
    public UnmodifiableBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableBagTest.class);
    }

    @Override
    public Bag<E> makeObject() {
        return UnmodifiableBag.unmodifiableBag((Bag)new HashBag());
    }

    @Override
    public Bag<E> makeFullCollection() {
        HashBag bag = new HashBag();
        bag.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableBag.unmodifiableBag((Bag)bag);
    }

    @Override
    public Bag<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableBagTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableBagTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Bag<E> queue = this.makeFullCollection();
        UnmodifiableBagTest.assertSame(queue, (Object)UnmodifiableBag.unmodifiableBag(queue));
        try {
            UnmodifiableBag.unmodifiableBag(null);
            UnmodifiableBagTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

