/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IterableUtilsTest {
    private Iterable<Integer> iterableA = null;
    private Iterable<Long> iterableB = null;
    private Iterable<Integer> emptyIterable = null;
    private static Predicate<Number> EQUALS_TWO = new Predicate<Number>(){

        public boolean evaluate(Number input) {
            return input.intValue() == 2;
        }
    };
    private static Predicate<Number> EVEN = new Predicate<Number>(){

        public boolean evaluate(Number input) {
            return input.intValue() % 2 == 0;
        }
    };

    @Before
    public void setUp() {
        ArrayList<Integer> collectionA = new ArrayList<Integer>();
        collectionA.add(1);
        collectionA.add(2);
        collectionA.add(2);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        this.iterableA = collectionA;
        LinkedList<Long> collectionB = new LinkedList<Long>();
        collectionB.add(5L);
        collectionB.add(4L);
        collectionB.add(4L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        this.iterableB = collectionB;
        this.emptyIterable = Collections.emptyList();
    }

    @Test
    public void forEach() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        IterableUtils.forEach(col, (Closure)testClosure);
        Assert.assertTrue((listA.isEmpty() && listB.isEmpty() ? 1 : 0) != 0);
        try {
            IterableUtils.forEach(col, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        IterableUtils.forEach(null, (Closure)testClosure);
        col.add(null);
        IterableUtils.forEach(col, (Closure)testClosure);
    }

    @Test(expected=FunctorException.class)
    public void forEachFailure() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<String> col = new ArrayList<String>();
        col.add("x");
        IterableUtils.forEach(col, (Closure)testClosure);
    }

    @Test
    public void forEachButLast() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        List last = (List)IterableUtils.forEachButLast(col, (Closure)testClosure);
        Assert.assertTrue((listA.isEmpty() && !listB.isEmpty() ? 1 : 0) != 0);
        Assert.assertSame(listB, (Object)last);
        try {
            IterableUtils.forEachButLast(col, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        IterableUtils.forEachButLast(null, (Closure)testClosure);
        col.add(null);
        col.add(null);
        last = (List)IterableUtils.forEachButLast(col, (Closure)testClosure);
        Assert.assertNull((Object)last);
    }

    @Test
    public void containsWithEquator() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("AC");
        base.add("BB");
        base.add("CA");
        Equator<String> secondLetterEquator = new Equator<String>(){

            public boolean equate(String o1, String o2) {
                return o1.charAt(1) == o2.charAt(1);
            }

            public int hash(String o) {
                return o.charAt(1);
            }
        };
        Assert.assertFalse((boolean)base.contains("CC"));
        Assert.assertTrue((boolean)IterableUtils.contains(base, (Object)"AC", (Equator)secondLetterEquator));
        Assert.assertTrue((boolean)IterableUtils.contains(base, (Object)"CC", (Equator)secondLetterEquator));
        Assert.assertFalse((boolean)IterableUtils.contains(base, (Object)"CX", (Equator)secondLetterEquator));
        Assert.assertFalse((boolean)IterableUtils.contains(null, null, (Equator)secondLetterEquator));
        try {
            IterableUtils.contains(base, (Object)"AC", null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void frequency() {
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(null, (Object)1));
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(this.iterableA, (Object)1));
        Assert.assertEquals((long)2L, (long)IterableUtils.frequency(this.iterableA, (Object)2));
        Assert.assertEquals((long)3L, (long)IterableUtils.frequency(this.iterableA, (Object)3));
        Assert.assertEquals((long)4L, (long)IterableUtils.frequency(this.iterableA, (Object)4));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(this.iterableA, (Object)5));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(this.iterableB, (Object)1L));
        Assert.assertEquals((long)4L, (long)IterableUtils.frequency(this.iterableB, (Object)2L));
        Assert.assertEquals((long)3L, (long)IterableUtils.frequency(this.iterableB, (Object)3L));
        Assert.assertEquals((long)2L, (long)IterableUtils.frequency(this.iterableB, (Object)4L));
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(this.iterableB, (Object)5L));
        List<Number> iterableIntAsNumber = Arrays.asList(1, 2, 3, 4, 5);
        List<Number> iterableLongAsNumber = Arrays.asList(1L, 2L, 3L, 4L, 5L);
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(iterableIntAsNumber, (Object)2L));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(iterableLongAsNumber, (Object)2));
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("C");
        set.add("E");
        set.add("E");
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(set, (Object)"A"));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(set, (Object)"B"));
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(set, (Object)"C"));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(set, (Object)"D"));
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(set, (Object)"E"));
        HashBag bag = new HashBag();
        bag.add((Object)"A", 3);
        bag.add((Object)"C");
        bag.add((Object)"E");
        bag.add((Object)"E");
        Assert.assertEquals((long)3L, (long)IterableUtils.frequency((Iterable)bag, (Object)"A"));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency((Iterable)bag, (Object)"B"));
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency((Iterable)bag, (Object)"C"));
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency((Iterable)bag, (Object)"D"));
        Assert.assertEquals((long)2L, (long)IterableUtils.frequency((Iterable)bag, (Object)"E"));
    }

    @Test
    public void frequencyOfNull() {
        ArrayList<String> list = new ArrayList<String>();
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(list, null));
        list.add("A");
        Assert.assertEquals((long)0L, (long)IterableUtils.frequency(list, null));
        list.add(null);
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(list, null));
        list.add("B");
        Assert.assertEquals((long)1L, (long)IterableUtils.frequency(list, null));
        list.add(null);
        Assert.assertEquals((long)2L, (long)IterableUtils.frequency(list, null));
        list.add("B");
        Assert.assertEquals((long)2L, (long)IterableUtils.frequency(list, null));
        list.add(null);
        Assert.assertEquals((long)3L, (long)IterableUtils.frequency(list, null));
    }

    @Test
    public void find() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        Integer test = (Integer)IterableUtils.find(this.iterableA, (Predicate)testPredicate);
        Assert.assertTrue((boolean)test.equals(4));
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        test = (Integer)IterableUtils.find(this.iterableA, (Predicate)testPredicate);
        Assert.assertTrue((test == null ? 1 : 0) != 0);
        Assert.assertNull((Object)IterableUtils.find(null, (Predicate)testPredicate));
        try {
            Assert.assertNull((Object)IterableUtils.find(this.iterableA, null));
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void indexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        int index = IterableUtils.indexOf(this.iterableA, (Predicate)testPredicate);
        Assert.assertEquals((long)6L, (long)index);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        index = IterableUtils.indexOf(this.iterableA, (Predicate)testPredicate);
        Assert.assertEquals((long)-1L, (long)index);
        Assert.assertEquals((long)-1L, (long)IterableUtils.indexOf(null, (Predicate)testPredicate));
        try {
            Assert.assertNull((Object)IterableUtils.indexOf(this.iterableA, null));
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void countMatches() {
        Assert.assertEquals((long)4L, (long)IterableUtils.countMatches(this.iterableB, EQUALS_TWO));
        Assert.assertEquals((long)0L, (long)IterableUtils.countMatches(null, EQUALS_TWO));
        try {
            Assert.assertEquals((long)0L, (long)IterableUtils.countMatches(this.iterableA, null));
            Assert.fail((String)"predicate must not be null");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            Assert.assertEquals((long)0L, (long)IterableUtils.countMatches(null, null));
            Assert.fail((String)"predicate must not be null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void matchesAny() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            Assert.assertFalse((boolean)IterableUtils.matchesAny(null, null));
            Assert.fail((String)"predicate must not be null");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)IterableUtils.matchesAny(list, null));
            Assert.fail((String)"predicate must not be null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)IterableUtils.matchesAny(null, EQUALS_TWO));
        Assert.assertFalse((boolean)IterableUtils.matchesAny(list, EQUALS_TWO));
        list.add(1);
        list.add(3);
        list.add(4);
        Assert.assertFalse((boolean)IterableUtils.matchesAny(list, EQUALS_TWO));
        list.add(2);
        Assert.assertEquals((Object)true, (Object)IterableUtils.matchesAny(list, EQUALS_TWO));
    }

    @Test
    public void matchesAll() {
        try {
            Assert.assertFalse((boolean)IterableUtils.matchesAll(null, null));
            Assert.fail((String)"predicate must not be null");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)IterableUtils.matchesAll(this.iterableA, null));
            Assert.fail((String)"predicate must not be null");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        Predicate<Integer> lessThanFive = new Predicate<Integer>(){

            public boolean evaluate(Integer object) {
                return object < 5;
            }
        };
        Assert.assertTrue((boolean)IterableUtils.matchesAll(this.iterableA, (Predicate)lessThanFive));
        Predicate<Integer> lessThanFour = new Predicate<Integer>(){

            public boolean evaluate(Integer object) {
                return object < 4;
            }
        };
        Assert.assertFalse((boolean)IterableUtils.matchesAll(this.iterableA, (Predicate)lessThanFour));
        Assert.assertTrue((boolean)IterableUtils.matchesAll(null, (Predicate)lessThanFour));
        Assert.assertTrue((boolean)IterableUtils.matchesAll(this.emptyIterable, (Predicate)lessThanFour));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getFromIterable() throws Exception {
        HashBag bag = new HashBag();
        bag.add((Object)"element", 1);
        Assert.assertEquals((Object)"element", (Object)IterableUtils.get((Iterable)bag, (int)0));
        IterableUtils.get((Iterable)bag, (int)1);
    }

    @Test
    public void partition() {
        ArrayList<Integer> input = new ArrayList<Integer>();
        input.add(1);
        input.add(2);
        input.add(3);
        input.add(4);
        List partitions = IterableUtils.partition(input, EQUALS_TWO);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Collection partition = (Collection)partitions.get(0);
        Assert.assertEquals((long)1L, (long)partition.size());
        Assert.assertEquals((long)2L, (long)((Integer)CollectionUtils.extractSingleton((Collection)partition)).intValue());
        Object[] expected = new Integer[]{1, 3, 4};
        partition = (Collection)partitions.get(1);
        Assert.assertArrayEquals((Object[])expected, (Object[])partition.toArray());
        partitions = IterableUtils.partition((Iterable)null, EQUALS_TWO);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)((List)partitions.get(0)).isEmpty());
        Assert.assertTrue((boolean)((List)partitions.get(1)).isEmpty());
        partitions = IterableUtils.partition(input, (Predicate[])new Predicate[0]);
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertEquals(input, partitions.get(0));
        try {
            IterableUtils.partition(input, (Predicate)null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void partitionMultiplePredicates() {
        ArrayList<Integer> input = new ArrayList<Integer>();
        input.add(1);
        input.add(2);
        input.add(3);
        input.add(4);
        List partitions = IterableUtils.partition(input, (Predicate[])new Predicate[]{EQUALS_TWO, EVEN});
        Collection partition = (Collection)partitions.get(0);
        Assert.assertEquals((long)1L, (long)partition.size());
        Assert.assertEquals((long)2L, (long)((Integer)partition.iterator().next()).intValue());
        partition = (Collection)partitions.get(1);
        Assert.assertEquals((long)1L, (long)partition.size());
        Assert.assertEquals((long)4L, (long)((Integer)partition.iterator().next()).intValue());
        Object[] expected = new Integer[]{1, 3};
        partition = (Collection)partitions.get(2);
        Assert.assertArrayEquals((Object[])expected, (Object[])partition.toArray());
        try {
            IterableUtils.partition(input, (Predicate[])new Predicate[]{EQUALS_TWO, null});
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        String result = IterableUtils.toString(this.iterableA);
        Assert.assertEquals((Object)"[1, 2, 2, 3, 3, 3, 4, 4, 4, 4]", (Object)result);
        result = IterableUtils.toString(new ArrayList());
        Assert.assertEquals((Object)"[]", (Object)result);
        result = IterableUtils.toString(null);
        Assert.assertEquals((Object)"[]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)new Transformer<Integer, String>(){

            public String transform(Integer input) {
                return new Integer(input * 2).toString();
            }
        });
        Assert.assertEquals((Object)"[2, 4, 4, 6, 6, 6, 8, 8, 8, 8]", (Object)result);
        result = IterableUtils.toString(new ArrayList(), (Transformer)new Transformer<Integer, String>(){

            public String transform(Integer input) {
                Assert.fail((String)"not supposed to reach here");
                return "";
            }
        });
        Assert.assertEquals((Object)"[]", (Object)result);
        result = IterableUtils.toString(null, (Transformer)new Transformer<Integer, String>(){

            public String transform(Integer input) {
                Assert.fail((String)"not supposed to reach here");
                return "";
            }
        });
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void testToStringDelimiter() {
        Transformer<Integer, String> transformer = new Transformer<Integer, String>(){

            public String transform(Integer input) {
                return new Integer(input * 2).toString();
            }
        };
        String result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)"", (String)"", (String)"");
        Assert.assertEquals((Object)"2446668888", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",", (String)"", (String)"");
        Assert.assertEquals((Object)"2,4,4,6,6,6,8,8,8,8", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)"", (String)"[", (String)"]");
        Assert.assertEquals((Object)"[2446668888]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",", (String)"[", (String)"]");
        Assert.assertEquals((Object)"[2,4,4,6,6,6,8,8,8,8]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",", (String)"[[", (String)"]]");
        Assert.assertEquals((Object)"[[2,4,4,6,6,6,8,8,8,8]]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",,", (String)"[", (String)"]");
        Assert.assertEquals((Object)"[2,,4,,4,,6,,6,,6,,8,,8,,8,,8]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",,", (String)"((", (String)"))");
        Assert.assertEquals((Object)"((2,,4,,4,,6,,6,,6,,8,,8,,8,,8))", (Object)result);
        result = IterableUtils.toString(new ArrayList(), (Transformer)transformer, (String)"", (String)"(", (String)")");
        Assert.assertEquals((Object)"()", (Object)result);
        result = IterableUtils.toString(new ArrayList(), (Transformer)transformer, (String)"", (String)"", (String)"");
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testToStringWithNullArguments() {
        String result = IterableUtils.toString(null, (Transformer)new Transformer<Integer, String>(){

            public String transform(Integer input) {
                Assert.fail((String)"not supposed to reach here");
                return "";
            }
        }, (String)"", (String)"(", (String)")");
        Assert.assertEquals((Object)"()", (Object)result);
        try {
            IterableUtils.toString(new ArrayList(), null, (String)"", (String)"(", (String)")");
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IterableUtils.toString(new ArrayList(), (Transformer)new Transformer<Integer, String>(){

                public String transform(Integer input) {
                    Assert.fail((String)"not supposed to reach here");
                    return "";
                }
            }, null, (String)"(", (String)")");
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IterableUtils.toString(new ArrayList(), (Transformer)new Transformer<Integer, String>(){

                public String transform(Integer input) {
                    Assert.fail((String)"not supposed to reach here");
                    return "";
                }
            }, (String)"", null, (String)")");
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IterableUtils.toString(new ArrayList(), (Transformer)new Transformer<Integer, String>(){

                public String transform(Integer input) {
                    Assert.fail((String)"not supposed to reach here");
                    return "";
                }
            }, (String)"", (String)"(", null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

