/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Comparator;
import org.apache.commons.collections4.ComparatorUtils;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorUtilsTest {
    @Test
    public void booleanComparator() {
        Comparator comp = ComparatorUtils.booleanComparator((boolean)true);
        Assert.assertTrue((comp.compare(Boolean.TRUE, Boolean.FALSE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(Boolean.TRUE, Boolean.TRUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(Boolean.FALSE, Boolean.TRUE) > 0 ? 1 : 0) != 0);
        comp = ComparatorUtils.booleanComparator((boolean)false);
        Assert.assertTrue((comp.compare(Boolean.TRUE, Boolean.FALSE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(Boolean.TRUE, Boolean.TRUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(Boolean.FALSE, Boolean.TRUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void chainedComparator() {
        Comparator comp = ComparatorUtils.chainedComparator((Comparator[])new Comparator[]{ComparatorUtils.naturalComparator(), ComparatorUtils.naturalComparator()});
        Assert.assertTrue((comp.compare(1, 2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(1, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(2, 1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void max() {
        Comparator reversed = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Assert.assertEquals((Object)10, (Object)ComparatorUtils.max((Object)1, (Object)10, null));
        Assert.assertEquals((Object)10, (Object)ComparatorUtils.max((Object)10, (Object)-10, null));
        Assert.assertEquals((Object)1, (Object)ComparatorUtils.max((Object)1, (Object)10, (Comparator)reversed));
        Assert.assertEquals((Object)-10, (Object)ComparatorUtils.max((Object)10, (Object)-10, (Comparator)reversed));
        try {
            ComparatorUtils.max((Object)1, null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            ComparatorUtils.max(null, (Object)10, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void min() {
        Comparator reversed = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Assert.assertEquals((Object)1, (Object)ComparatorUtils.min((Object)1, (Object)10, null));
        Assert.assertEquals((Object)-10, (Object)ComparatorUtils.min((Object)10, (Object)-10, null));
        Assert.assertEquals((Object)10, (Object)ComparatorUtils.min((Object)1, (Object)10, (Comparator)reversed));
        Assert.assertEquals((Object)10, (Object)ComparatorUtils.min((Object)10, (Object)-10, (Comparator)reversed));
        try {
            ComparatorUtils.min((Object)1, null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            ComparatorUtils.min(null, (Object)10, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void nullLowComparator() {
        Comparator comp = ComparatorUtils.nullLowComparator(null);
        Assert.assertTrue((comp.compare(null, 10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(10, null) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void nullHighComparator() {
        Comparator comp = ComparatorUtils.nullHighComparator(null);
        Assert.assertTrue((comp.compare(null, 10) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(10, null) < 0 ? 1 : 0) != 0);
    }
}

