/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.list.AbstractListTest;

public abstract class AbstractLinkedListTest<T>
extends AbstractListTest<T> {
    public AbstractLinkedListTest(String testName) {
        super(testName);
    }

    @Override
    public abstract LinkedList<T> makeObject();

    @Override
    public LinkedList<T> getCollection() {
        return (LinkedList)super.getCollection();
    }

    protected LinkedList<T> getConfirmedLinkedList() {
        return (LinkedList)this.getConfirmed();
    }

    public void testLinkedListAddFirst() {
        if (!this.isAddSupported()) {
            return;
        }
        String o = "hello";
        this.resetEmpty();
        ((LinkedList)this.getCollection()).addFirst(o);
        this.getConfirmedLinkedList().addFirst(o);
        this.verify();
        this.resetFull();
        ((LinkedList)this.getCollection()).addFirst(o);
        this.getConfirmedLinkedList().addFirst(o);
        this.verify();
    }

    public void testLinkedListAddLast() {
        if (!this.isAddSupported()) {
            return;
        }
        String o = "hello";
        this.resetEmpty();
        ((LinkedList)this.getCollection()).addLast(o);
        this.getConfirmedLinkedList().addLast(o);
        this.verify();
        this.resetFull();
        ((LinkedList)this.getCollection()).addLast(o);
        this.getConfirmedLinkedList().addLast(o);
        this.verify();
    }

    public void testLinkedListGetFirst() {
        this.resetEmpty();
        try {
            ((LinkedList)this.getCollection()).getFirst();
            AbstractLinkedListTest.fail((String)"getFirst() should throw a NoSuchElementException for an empty list.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        Object first = ((LinkedList)this.getCollection()).getFirst();
        T confirmedFirst = this.getConfirmedLinkedList().getFirst();
        AbstractLinkedListTest.assertEquals((String)"Result returned by getFirst() was wrong.", confirmedFirst, first);
        this.verify();
    }

    public void testLinkedListGetLast() {
        this.resetEmpty();
        try {
            ((LinkedList)this.getCollection()).getLast();
            AbstractLinkedListTest.fail((String)"getLast() should throw a NoSuchElementException for an empty list.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        Object last = ((LinkedList)this.getCollection()).getLast();
        T confirmedLast = this.getConfirmedLinkedList().getLast();
        AbstractLinkedListTest.assertEquals((String)"Result returned by getLast() was wrong.", confirmedLast, last);
        this.verify();
    }

    public void testLinkedListRemoveFirst() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            ((LinkedList)this.getCollection()).removeFirst();
            AbstractLinkedListTest.fail((String)"removeFirst() should throw a NoSuchElementException for an empty list.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        Object first = ((LinkedList)this.getCollection()).removeFirst();
        T confirmedFirst = this.getConfirmedLinkedList().removeFirst();
        AbstractLinkedListTest.assertEquals((String)"Result returned by removeFirst() was wrong.", confirmedFirst, first);
        this.verify();
    }

    public void testLinkedListRemoveLast() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            ((LinkedList)this.getCollection()).removeLast();
            AbstractLinkedListTest.fail((String)"removeLast() should throw a NoSuchElementException for an empty list.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        Object last = ((LinkedList)this.getCollection()).removeLast();
        T confirmedLast = this.getConfirmedLinkedList().removeLast();
        AbstractLinkedListTest.assertEquals((String)"Result returned by removeLast() was wrong.", confirmedLast, last);
        this.verify();
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        LinkedList list = new LinkedList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }
}

