/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hive.common.util.TimestampParser;
import org.junit.Assert;
import org.junit.Test;

public class TestTimestampParser {
    @Test
    public void testDefault() {
        TimestampParser tsp = new TimestampParser();
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59.0"), (Object)tsp.parseTimestamp("1945-12-31 23:59:59.0"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59.1234"), (Object)tsp.parseTimestamp("1945-12-31 23:59:59.1234"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1970-01-01 00:00:00"), (Object)tsp.parseTimestamp("1970-01-01 00:00:00"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31T23:59:59"), (Object)tsp.parseTimestamp("1945-12-31 23:59:59"));
    }

    @Test
    public void testDefaultInvalid() {
        TimestampParser tsp = new TimestampParser();
        Assert.assertNull((Object)tsp.parseTimestamp("12345"));
        Assert.assertNull((Object)tsp.parseTimestamp("1945-12-45 23:59:59"));
        Assert.assertNull((Object)tsp.parseTimestamp("1945-15-20 23:59:59"));
        Assert.assertNull((Object)tsp.parseTimestamp("0000-00-00 00:00:00"));
        Assert.assertNull((Object)tsp.parseTimestamp(""));
        Assert.assertNull((Object)tsp.parseTimestamp("null"));
    }

    @Test
    public void testPattern1() {
        String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSS"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59.0"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59.0"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2001-01-01 00:00:00.100"), (Object)tsp.parseTimestamp("2001-01-01T00:00:00.100"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2001-01-01 00:00:00.001"), (Object)tsp.parseTimestamp("2001-01-01T00:00:00.001"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31T23:59:59.123"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59.123"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31T23:59:59.123"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59.1234"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1970-01-01 00:00:00"), (Object)tsp.parseTimestamp("1970-01-01T00:00:00"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59.1234"), (Object)tsp.parseTimestamp("1945-12-31 23:59:59.1234"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59.12345"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59.12345"));
    }

    @Test
    public void testPatternInvalid1() {
        String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSS"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertNull((Object)tsp.parseTimestamp("1945-12-31-23:59:59"));
    }

    @Test
    public void testPatternInvalid2() {
        String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSS"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertNull((Object)tsp.parseTimestamp("12345"));
    }

    @Test
    public void testMillisParser() {
        String[] patterns = new String[]{"millis", "yyyy-MM-dd'T'HH:mm:ss"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertEquals((Object)Timestamp.ofEpochMilli((long)0L), (Object)tsp.parseTimestamp("0"));
        Assert.assertEquals((Object)Timestamp.ofEpochMilli((long)-1000000L), (Object)tsp.parseTimestamp("-1000000"));
        Assert.assertEquals((Object)Timestamp.ofEpochMilli((long)1420509274123L), (Object)tsp.parseTimestamp("1420509274123"));
        Assert.assertEquals((Object)Timestamp.ofEpochMilli((long)1420509274123L), (Object)tsp.parseTimestamp("1420509274123.456789"));
    }

    @Test
    public void testMillisParserInvalid1() {
        String[] patterns = new String[]{"millis", "yyyy-MM-dd'T'HH:mm:ss"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertNull((Object)tsp.parseTimestamp("1420509274123-"));
    }

    @Test
    public void testMillisParserInvalid2() {
        String[] patterns = new String[]{"millis", "yyyy-MM-dd'T'HH:mm:ss"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertNull((Object)tsp.parseTimestamp("1945-12-31-23:59:59"));
    }

    @Test
    public void testPatternShort() {
        String[] patterns = new String[]{"MM:dd:ss", "HH:mm"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1970-01-01 05:06:00"), (Object)tsp.parseTimestamp("05:06"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1970-05-06 00:00:07"), (Object)tsp.parseTimestamp("05:06:07"));
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59"));
    }

    @Test
    public void testPatternTimeZone() {
        String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ssX"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59Z"));
    }

    @Test
    public void testPatternISO8601() {
        String[] patterns = new String[]{"iso8601"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"1945-12-31 23:59:59"), (Object)tsp.parseTimestamp("1945-12-31T23:59:59Z"));
    }

    @Test
    public void testPatternRFC1123() {
        String[] patterns = new String[]{"rfc1123"};
        TimestampParser tsp = new TimestampParser(patterns);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2008-06-03 11:05:30"), (Object)tsp.parseTimestamp("Tue, 3 Jun 2008 11:05:30 GMT"));
    }
}

