/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFixedSizedObjectPool {
    public static final Logger LOG = LoggerFactory.getLogger(TestFixedSizedObjectPool.class);

    @Test
    public void testFullEmpty() {
        Object obj;
        int i;
        int SIZE = 8;
        HashSet<Object> offered = new HashSet<Object>();
        FixedSizedObjectPool pool = new FixedSizedObjectPool(8, (Pool.PoolObjectHelper)new DummyHelper(), true);
        Object newObj = pool.take();
        for (i = 0; i < 8; ++i) {
            obj = new Object();
            offered.add(obj);
            Assert.assertTrue((boolean)pool.tryOffer(obj));
        }
        Assert.assertFalse((boolean)pool.tryOffer(newObj));
        for (i = 0; i < 8; ++i) {
            obj = pool.take();
            Assert.assertTrue((boolean)offered.remove(obj));
        }
        Assert.assertTrue((boolean)offered.isEmpty());
        Object newObj2 = pool.take();
        Assert.assertNotSame((Object)newObj, (Object)newObj2);
    }

    @Test
    public void testMTT1() {
        this.testMTTImpl(1, 3, 3);
    }

    @Test
    public void testMTT8() {
        this.testMTTImpl(8, 3, 3);
    }

    @Test
    public void testMTT4096() {
        this.testMTTImpl(4096, 3, 3);
    }

    @Test
    public void testMTT4096_1() {
        this.testMTTImpl(4096, 1, 1);
    }

    @Test
    public void testMTT20000() {
        this.testMTTImpl(20000, 3, 3);
    }

    @Test
    public void testMTT4096_10() {
        this.testMTTImpl(4096, 10, 10);
    }

    public void testMTTImpl(int size, int takerCount, int giverCount) {
        int i;
        int TASK_COUNT = takerCount + giverCount;
        int GIVECOUNT = 15000;
        int TAKECOUNT = 15000;
        ExecutorService executor = Executors.newFixedThreadPool(TASK_COUNT);
        CountDownLatch cdlIn = new CountDownLatch(TASK_COUNT);
        CountDownLatch cdlOut = new CountDownLatch(1);
        FixedSizedObjectPool pool = new FixedSizedObjectPool(size, (Pool.PoolObjectHelper)new OneObjHelper(), true);
        HashSet<Object> allGiven = new HashSet<Object>();
        for (int i2 = 0; i2 < size >> 1; ++i2) {
            Object o = new Object();
            allGiven.add(o);
            Assert.assertTrue((boolean)pool.tryOffer(o));
        }
        FutureTask[] tasks = new FutureTask[TASK_COUNT];
        TakeRunnable[] takers = new TakeRunnable[takerCount];
        OfferRunnable[] givers = new OfferRunnable[giverCount];
        int ti = 0;
        int i3 = 0;
        while (i3 < takerCount) {
            takers[i3] = new TakeRunnable((FixedSizedObjectPool<Object>)pool, cdlIn, cdlOut, 15000);
            tasks[ti] = new FutureTask<Object>(takers[i3], null);
            executor.execute(tasks[ti]);
            ++i3;
            ++ti;
        }
        int i2 = 0;
        while (i2 < giverCount) {
            givers[i2] = new OfferRunnable((FixedSizedObjectPool<Object>)pool, cdlIn, cdlOut, 15000);
            tasks[ti] = new FutureTask<Object>(givers[i2], null);
            executor.execute(tasks[ti]);
            ++i2;
            ++ti;
        }
        long time = 0L;
        try {
            cdlIn.await();
            time = System.nanoTime();
            cdlOut.countDown();
            for (int i4 = 0; i4 < TASK_COUNT; ++i4) {
                tasks[i4].get();
            }
            time = System.nanoTime() - time;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        int given = allGiven.size();
        int takenOld = 0;
        for (OfferRunnable offerRunnable : givers) {
            for (Object o : offerRunnable.objects) {
                Assert.assertTrue((boolean)allGiven.add(o));
                ++given;
            }
        }
        for (PoolRunnable poolRunnable : takers) {
            for (Object o : ((TakeRunnable)poolRunnable).objects) {
                Assert.assertTrue((boolean)allGiven.remove(o));
                ++takenOld;
            }
        }
        LOG.info("MTT test - size " + size + ", takers/givers " + takerCount + "/" + giverCount + "; offered " + (given - (size >> 1)) + " (attempted " + 15000 * giverCount + "); reused " + takenOld + ", allocated " + (15000 * takerCount - takenOld) + " (took " + time / 1000000L + "ms including thread sync)");
        while (pool.take() != OneObjHelper.THE_OBJECT) {
        }
        for (i = 0; i < size; ++i) {
            Assert.assertTrue((boolean)pool.tryOffer(new Object()));
        }
        Assert.assertFalse((boolean)pool.tryOffer(new Object()));
        for (i = 0; i < size; ++i) {
            Assert.assertTrue((OneObjHelper.THE_OBJECT != pool.take() ? 1 : 0) != 0);
        }
        Assert.assertTrue((OneObjHelper.THE_OBJECT == pool.take() ? 1 : 0) != 0);
    }

    @Test
    public void testClearImp() {
        int size = 10;
        FixedSizedObjectPool fixedSizedObjectPool = new FixedSizedObjectPool(size, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<Object>(){

            public Object create() {
                return null;
            }

            public void resetBeforeOffer(Object o) {
            }
        });
        for (int i = 0; i < size; ++i) {
            fixedSizedObjectPool.offer(new Object());
        }
        Assert.assertEquals((long)size, (long)fixedSizedObjectPool.size());
        Assert.assertNotNull((Object)fixedSizedObjectPool.take());
        fixedSizedObjectPool.clear();
        Assert.assertNull((Object)fixedSizedObjectPool.take());
    }

    private static void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class DummyHelper
    implements Pool.PoolObjectHelper<Object> {
        private DummyHelper() {
        }

        public Object create() {
            return new Object();
        }

        public void resetBeforeOffer(Object t) {
        }
    }

    private static class OneObjHelper
    implements Pool.PoolObjectHelper<Object> {
        public static final Object THE_OBJECT = new Object();

        private OneObjHelper() {
        }

        public Object create() {
            return THE_OBJECT;
        }

        public void resetBeforeOffer(Object t) {
        }
    }

    private static final class TakeRunnable
    extends PoolRunnable {
        TakeRunnable(FixedSizedObjectPool<Object> pool, CountDownLatch cdlIn, CountDownLatch cdlOut, int count) {
            super(pool, cdlIn, cdlOut, count);
        }

        @Override
        protected void doOneOp() {
            Object o = this.pool.take();
            if (o != OneObjHelper.THE_OBJECT) {
                this.objects.add(o);
            }
        }
    }

    private static final class OfferRunnable
    extends PoolRunnable {
        OfferRunnable(FixedSizedObjectPool<Object> pool, CountDownLatch cdlIn, CountDownLatch cdlOut, int count) {
            super(pool, cdlIn, cdlOut, count);
        }

        @Override
        protected void doOneOp() {
            Object o = new Object();
            if (this.pool.tryOffer(o)) {
                this.objects.add(o);
            }
        }
    }

    private static abstract class PoolRunnable
    implements Runnable {
        protected final FixedSizedObjectPool<Object> pool;
        private final CountDownLatch cdlIn;
        private final CountDownLatch cdlOut;
        public final List<Object> objects = new ArrayList<Object>();
        private final int count;

        PoolRunnable(FixedSizedObjectPool<Object> pool, CountDownLatch cdlIn, CountDownLatch cdlOut, int count) {
            this.pool = pool;
            this.cdlIn = cdlIn;
            this.cdlOut = cdlOut;
            this.count = count;
        }

        @Override
        public void run() {
            TestFixedSizedObjectPool.syncThreadStart(this.cdlIn, this.cdlOut);
            for (int i = 0; i < this.count; ++i) {
                this.doOneOp();
            }
        }

        protected abstract void doOneOp();
    }
}

