/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hive.common.util.DateParser;
import org.junit.Assert;
import org.junit.Test;

public class TestDateParser {
    private Date date = new Date();

    void checkValidCase(String strValue, Date expected) {
        Date dateValue = DateParser.parseDate((String)strValue);
        Assert.assertEquals((Object)expected, (Object)dateValue);
        Assert.assertTrue((boolean)DateParser.parseDate((String)strValue, (Date)this.date));
        Assert.assertEquals((Object)expected, (Object)this.date);
    }

    void checkInvalidCase(String strValue) {
        Date dateValue = DateParser.parseDate((String)strValue);
        Assert.assertNull((Object)dateValue);
        Assert.assertFalse((boolean)DateParser.parseDate((String)strValue, (Date)this.date));
    }

    @Test
    public void testValidCases() throws Exception {
        this.checkValidCase("1945-12-31", Date.of((int)1945, (int)12, (int)31));
        this.checkValidCase("1946-01-01", Date.of((int)1946, (int)1, (int)1));
        this.checkValidCase("2001-11-12", Date.of((int)2001, (int)11, (int)12));
        this.checkValidCase("0004-05-06", Date.of((int)4, (int)5, (int)6));
        this.checkValidCase("1678-09-10", Date.of((int)1678, (int)9, (int)10));
        this.checkValidCase("9999-10-11", Date.of((int)9999, (int)10, (int)11));
        this.checkValidCase("2001-11-12 01:02:03", Date.of((int)2001, (int)11, (int)12));
        this.checkValidCase(" 1946-01-01", Date.of((int)1946, (int)1, (int)1));
        this.checkValidCase(" 2001-11-12 01:02:03", Date.of((int)2001, (int)11, (int)12));
    }

    @Test
    public void testParseDateFromTimestampWithCommonTimeDelimiter() {
        for (String d : new String[]{"T", " ", "-", ".", "_"}) {
            String ts = "2023-08-03" + d + "01:02:03";
            Assert.assertEquals((String)("Parsing " + ts), (Object)Date.of((int)2023, (int)8, (int)3), (Object)DateParser.parseDate((String)ts));
        }
    }

    @Test
    public void testInvalidCases() throws Exception {
        this.checkInvalidCase("2001");
        this.checkInvalidCase("2001-01");
        this.checkInvalidCase("abc");
        this.checkInvalidCase(" 2001 ");
        this.checkInvalidCase("a2001-01-01");
        this.checkInvalidCase("0000-00-00");
        this.checkInvalidCase("2001-13-12");
        this.checkInvalidCase("2001-11-31");
        this.checkInvalidCase("19999-10-11");
        this.checkInvalidCase("08-08-2023");
        this.checkInvalidCase("2023-08-0800");
    }
}

