/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.junit.Assert;
import org.junit.Test;

public class PerfLoggerTest {
    private static void snooze(int ms) {
        try {
            Thread.currentThread();
            Thread.sleep(ms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testBasic() {
        PerfLogger pl = PerfLogger.getPerfLogger(null, (boolean)true);
        pl.perfLogBegin("test", "compile");
        PerfLoggerTest.snooze(100);
        pl.perfLogEnd("test", "compile");
        long duration = pl.getDuration("compile");
        Assert.assertTrue((duration >= 100L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMT() throws InterruptedException {
        PerfLogger pl = PerfLogger.getPerfLogger(null, (boolean)true);
        ExecutorService executorService = Executors.newFixedThreadPool(64);
        AtomicInteger count = new AtomicInteger(0);
        executorService.execute(() -> {
            try {
                count.incrementAndGet();
                PerfLoggerTest.snooze(100);
                for (int i = 0; i < 64; ++i) {
                    PerfLoggerTest.snooze(50);
                    Map et = pl.getEndTimes();
                    Assert.assertNotNull((Object)et);
                }
            }
            finally {
                count.decrementAndGet();
                AtomicInteger atomicInteger = count;
                synchronized (atomicInteger) {
                    count.notifyAll();
                }
            }
        });
        for (int t = 0; t < 31; ++t) {
            executorService.execute(() -> {
                try {
                    int cnt = count.incrementAndGet();
                    for (int i = 0; i < 64; ++i) {
                        pl.perfLogBegin("test", "compile_ " + cnt + "_" + i);
                        PerfLoggerTest.snooze(50);
                        pl.perfLogEnd("test", "compile_ " + cnt + "_" + i);
                    }
                }
                catch (Exception xany) {
                    String string = xany.getMessage();
                }
                finally {
                    count.decrementAndGet();
                    AtomicInteger atomicInteger = count;
                    synchronized (atomicInteger) {
                        count.notifyAll();
                    }
                }
            });
        }
        while (count.get() != 0) {
            AtomicInteger atomicInteger = count;
            synchronized (atomicInteger) {
                count.wait();
            }
        }
        executorService.shutdown();
    }
}

