/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import junit.framework.TestCase;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.SystemVariables;
import org.junit.Assert;
import org.junit.Test;

public class TestSystemVariables {
    public static final String SYSTEM = "system";

    private String makeVarName(String prefix, String value) {
        return "${%s:%s}".formatted(prefix, value);
    }

    @Test
    public void test_RelativeJavaIoTmpDir_CoercedTo_AbsolutePath() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "./relativePath");
        Path relativePath = new Path(localFileSystem.getWorkingDirectory(), "./relativePath");
        TestCase.assertEquals((String)relativePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
        System.setProperty("java.io.tmpdir", "this/is/a/relative/path");
        Path thisIsARelativePath = new Path(localFileSystem.getWorkingDirectory(), "this/is/a/relative/path");
        TestCase.assertEquals((String)thisIsARelativePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_AbsoluteJavaIoTmpDir_NotChanged() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "file:/this/is/an/absolute/path");
        Path absolutePath = new Path("file:/this/is/an/absolute/path");
        TestCase.assertEquals((String)absolutePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_RelativePathWithNoCoercion_NotChanged() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io._NOT_tmpdir");
        System.setProperty("java.io._NOT_tmpdir", "this/is/an/relative/path");
        Path relativePath = new Path("this/is/an/relative/path");
        TestCase.assertEquals((String)relativePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_EmptyJavaIoTmpDir_NotChanged() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "");
        TestCase.assertEquals((String)"", (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_SubstituteLongSelfReference() {
        String randomPart = RandomStringUtils.random((int)100000);
        String reference = "${hiveconf:myTestVariable}";
        StringBuilder longStringWithReferences = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            longStringWithReferences.append(randomPart).append(reference);
        }
        SystemVariables uut = new SystemVariables();
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_QUERY_MAX_LENGTH.varname, "100Kb");
        conf.set("myTestVariable", longStringWithReferences.toString());
        try {
            uut.substitute((Configuration)conf, longStringWithReferences.toString(), 40);
        }
        catch (Exception e) {
            if (!e.getMessage().startsWith("Query length longer than hive.query.max.length")) {
                Assert.fail((String)("unexpected error message: " + e.getMessage()));
            }
            return;
        }
        Assert.fail((String)"should have thrown exception during substitution");
    }
}

