/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.io.File;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveLogging {
    private void configLog(String hiveLog4jTest, String hiveExecLog4jTest) throws Exception {
        String expectedLog4jTestPath = HiveTestUtils.getFileFromClasspath((String)hiveLog4jTest);
        String expectedLog4jExecPath = HiveTestUtils.getFileFromClasspath((String)hiveExecLog4jTest);
        System.setProperty(HiveConf.ConfVars.HIVE_LOG4J_FILE.varname, expectedLog4jTestPath);
        System.setProperty(HiveConf.ConfVars.HIVE_EXEC_LOG4J_FILE.varname, expectedLog4jExecPath);
        LogUtils.initHiveLog4j();
        HiveConf conf = new HiveConf();
        Assert.assertEquals((Object)expectedLog4jTestPath, (Object)conf.getVar(HiveConf.ConfVars.HIVE_LOG4J_FILE));
        Assert.assertEquals((Object)expectedLog4jExecPath, (Object)conf.getVar(HiveConf.ConfVars.HIVE_EXEC_LOG4J_FILE));
    }

    public void cleanLog(File logFile) {
        File logFileDir;
        if (logFile.exists()) {
            logFile.delete();
        }
        if ((logFileDir = logFile.getParentFile()).exists()) {
            logFileDir.delete();
        }
    }

    private void RunTest(File logFile, String hiveLog4jProperty, String hiveExecLog4jProperty) throws Exception {
        this.cleanLog(logFile);
        Assert.assertFalse((String)(logFile + " should not exist"), (boolean)logFile.exists());
        this.configLog(hiveLog4jProperty, hiveExecLog4jProperty);
        Assert.assertTrue((String)(logFile + " should exist"), (boolean)logFile.exists());
    }

    @Test
    public void testHiveLogging() throws Exception {
        File customLogPath = new File(new File(System.getProperty("test.tmp.dir")), System.getProperty("user.name") + "-TestHiveLogging/");
        String customLogName = "hiveLog4j2Test.log";
        File customLogFile = new File(customLogPath, customLogName);
        this.RunTest(customLogFile, "hive-log4j2-test.properties", "hive-exec-log4j2-test.properties");
    }
}

