/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveConfVarsValidate {
    private final HiveConf.ConfVars property;
    private final String value;
    private final String expectedMessage;

    public TestHiveConfVarsValidate(HiveConf.ConfVars property, String value, String expectedMessage) {
        this.property = property;
        this.value = value;
        this.expectedMessage = expectedMessage;
    }

    @Parameterized.Parameters(name="{0} {1}")
    public static Collection<Object[]> generateParameters() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{HiveConf.ConfVars.HIVE_EXPLAIN_NODE_VISIT_LIMIT, String.valueOf(Integer.MIN_VALUE), "Invalid value  -2147483648, which should be in between 1 and 2147483647"});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_EXPLAIN_NODE_VISIT_LIMIT, "-10", "Invalid value  -10, which should be in between 1 and 2147483647"});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_EXPLAIN_NODE_VISIT_LIMIT, "0", "Invalid value  0, which should be in between 1 and 2147483647"});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_EXPLAIN_NODE_VISIT_LIMIT, "1", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_EXPLAIN_NODE_VISIT_LIMIT, "14", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_EXPLAIN_NODE_VISIT_LIMIT, String.valueOf(Integer.MAX_VALUE), null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, "DATETIME", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, "SIMPLE", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, "simple", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, "dateTime", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, "OTHER", "Invalid value.. expects one of [datetime, simple]"});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "SMART", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "STRICT", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "LENIENT", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "smart", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "strict", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "lenient", null});
        list.add(new Object[]{HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, "OTHER", "Invalid value.. expects one of [smart, strict, lenient]"});
        return list;
    }

    @Test
    public void testValidate() {
        Assert.assertEquals((Object)this.expectedMessage, (Object)this.property.validate(this.value));
    }
}

