/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHiveConfRestrictList {
    private HiveConf conf = null;

    @Before
    public void setUp() throws Exception {
        System.setProperty(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.varname, HiveConf.ConfVars.HIVE_TEST_MODE_PREFIX.varname);
        this.conf = new HiveConf();
    }

    @Test
    public void testRestriction() throws Exception {
        this.verifyRestriction(HiveConf.ConfVars.HIVE_TEST_MODE_PREFIX.varname, "foo");
        this.conf.verifyAndSet(HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION.varname, "false");
    }

    @Test
    public void testMultipleRestrictions() throws Exception {
        this.verifyRestriction(HiveConf.ConfVars.HIVE_TEST_MODE_PREFIX.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.HIVE_IN_TEST.varname, "true");
    }

    @Test
    public void testRestrictList() throws Exception {
        this.verifyRestriction(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.varname, "foo");
    }

    @Test
    public void testAppendRestriction() throws Exception {
        String appendListStr = HiveConf.ConfVars.SCRATCH_DIR.varname + "," + HiveConf.ConfVars.LOCAL_SCRATCH_DIR.varname + "," + HiveConf.ConfVars.METASTORE_URIS.varname;
        this.conf.addToRestrictList(appendListStr);
        String newRestrictList = this.conf.getVar(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST);
        Assert.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.SCRATCH_DIR.varname));
        Assert.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.LOCAL_SCRATCH_DIR.varname));
        Assert.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.METASTORE_URIS.varname));
        Assert.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.HIVE_TEST_MODE_PREFIX.varname));
        this.verifyRestriction(HiveConf.ConfVars.HIVE_TEST_MODE_PREFIX.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.LOCAL_SCRATCH_DIR.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.METASTORE_URIS.varname, "foo");
    }

    private void verifyRestriction(String varName, String newVal) {
        try {
            this.conf.verifyAndSet(varName, newVal);
            Assert.fail((String)("Setting config property " + varName + " should fail"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

