/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveConf {
    @Test
    public void testHiveSitePath() throws Exception {
        String expectedPath = HiveTestUtils.getFileFromClasspath((String)"hive-site.xml");
        String hiveSiteLocation = HiveConf.getHiveSiteLocation().getPath();
        Assert.assertEquals((Object)expectedPath, (Object)hiveSiteLocation);
    }

    private void checkHadoopConf(String name, String expectedHadoopVal) throws Exception {
        Assert.assertEquals((Object)expectedHadoopVal, (Object)new JobConf(HiveConf.class).get(name));
    }

    private void checkConfVar(HiveConf.ConfVars var, String expectedConfVarVal) throws Exception {
        Assert.assertEquals((Object)expectedConfVarVal, (Object)var.getDefaultValue());
    }

    private void checkHiveConf(String name, String expectedHiveVal) throws Exception {
        Assert.assertEquals((Object)expectedHiveVal, (Object)new HiveConf().get(name));
    }

    @Test
    public void testConfProperties() throws Exception {
        this.checkHadoopConf(HiveConf.ConfVars.HADOOP_NUM_REDUCERS.varname, "1");
        this.checkConfVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS, "-1");
        this.checkHiveConf(HiveConf.ConfVars.HADOOP_NUM_REDUCERS.varname, "-1");
        this.checkHadoopConf(HiveConf.ConfVars.HIVE_SKEWJOIN_KEY.varname, null);
        this.checkConfVar(HiveConf.ConfVars.HIVE_SKEWJOIN_KEY, "100000");
        this.checkHiveConf(HiveConf.ConfVars.HIVE_SKEWJOIN_KEY.varname, "100000");
        this.checkHadoopConf(HiveConf.ConfVars.HIVE_TEST_MODE_DUMMY_STAT_AGGR.varname, null);
        this.checkConfVar(HiveConf.ConfVars.HIVE_TEST_MODE_DUMMY_STAT_AGGR, "");
        this.checkHiveConf(HiveConf.ConfVars.HIVE_TEST_MODE_DUMMY_STAT_AGGR.varname, "value2");
        this.checkConfVar(HiveConf.ConfVars.HIVE_MASKING_ALGO, "sha256");
        this.checkHiveConf(HiveConf.ConfVars.HIVE_MASKING_ALGO.varname, "sha256");
        this.checkHadoopConf("test.property1", null);
        this.checkHiveConf("test.property1", "value1");
        this.checkHiveConf("test.var.hiveconf.property", HiveConf.ConfVars.DEFAULT_PARTITION_NAME.getDefaultValue());
    }

    @Test
    public void testColumnNameMapping() throws Exception {
        for (int i = 0; i < 20; ++i) {
            Assert.assertTrue((i == HiveConf.getPositionFromInternalName((String)HiveConf.getColumnInternalName((int)i)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUnitFor() throws Exception {
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)HiveConf.unitFor((String)"L", (TimeUnit)TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)HiveConf.unitFor((String)"", (TimeUnit)TimeUnit.MICROSECONDS)));
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)HiveConf.unitFor((String)"d", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)HiveConf.unitFor((String)"days", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)HiveConf.unitFor((String)"h", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)HiveConf.unitFor((String)"hours", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)HiveConf.unitFor((String)"m", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)HiveConf.unitFor((String)"minutes", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)HiveConf.unitFor((String)"s", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)HiveConf.unitFor((String)"seconds", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)HiveConf.unitFor((String)"ms", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)HiveConf.unitFor((String)"msecs", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)HiveConf.unitFor((String)"us", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)HiveConf.unitFor((String)"usecs", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.NANOSECONDS), (Object)((Object)HiveConf.unitFor((String)"ns", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.NANOSECONDS), (Object)((Object)HiveConf.unitFor((String)"nsecs", null)));
    }

    @Test
    public void testToSizeBytes() throws Exception {
        Assert.assertEquals((long)1L, (long)HiveConf.toSizeBytes((String)"1b"));
        Assert.assertEquals((long)1L, (long)HiveConf.toSizeBytes((String)"1bytes"));
        Assert.assertEquals((long)1024L, (long)HiveConf.toSizeBytes((String)"1kb"));
        Assert.assertEquals((long)0x100000L, (long)HiveConf.toSizeBytes((String)"1mb"));
        Assert.assertEquals((long)0x40000000L, (long)HiveConf.toSizeBytes((String)"1gb"));
        Assert.assertEquals((long)0x10000000000L, (long)HiveConf.toSizeBytes((String)"1tb"));
        Assert.assertEquals((long)0x4000000000000L, (long)HiveConf.toSizeBytes((String)"1pb"));
    }

    @Test
    public void testHiddenConfig() throws Exception {
        HiveConf conf = new HiveConf();
        try {
            String name = HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST.varname;
            conf.verifyAndSet(name, "");
            conf.verifyAndSet(name + "postfix", "");
            Assert.fail((String)("Setting config property " + name + " should fail"));
        }
        catch (IllegalArgumentException name) {
            // empty catch block
        }
        ArrayList hiddenList = Lists.newArrayList((Object[])new String[]{HiveConf.ConfVars.METASTORE_PWD.varname, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PASSWORD.varname, "fs.s3.awsSecretAccessKey", "fs.s3n.awsSecretAccessKey", "dfs.adls.oauth2.credential", "fs.adl.oauth2.credential", "fs.azure.account.oauth2.client.secret"});
        for (String hiddenConfig : hiddenList) {
            Assert.assertTrue((String)("config " + hiddenConfig + " should be hidden"), (boolean)conf.isHiddenConfig(hiddenConfig));
            Configuration conf2 = new Configuration((Configuration)conf);
            conf2.set(hiddenConfig, "password");
            conf.stripHiddenConfigurations(conf2);
            Assert.assertTrue((boolean)conf.isHiddenConfig(hiddenConfig + "postfix"));
            Assert.assertEquals((Object)"", (Object)conf2.get(hiddenConfig));
        }
    }

    @Test
    public void testLockedConfig() throws Exception {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
        String defaultVal = conf.get(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname);
        conf.addToLockedSet(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname);
        conf.verifyAndSet(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, "tez");
        String modifiedVal = conf.get(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname);
        Assert.assertEquals((Object)defaultVal, (Object)modifiedVal);
    }

    @Test
    public void testEncodingDecoding() throws UnsupportedEncodingException {
        HiveConf conf = new HiveConf();
        String query = "select blah, '\u0001' from random_table";
        conf.setQueryString(query);
        Assert.assertEquals((Object)URLEncoder.encode(query, "UTF-8"), (Object)conf.get(HiveConf.ConfVars.HIVE_QUERY_STRING.varname));
        Assert.assertEquals((Object)query, (Object)conf.getQueryString());
    }

    @Test
    public void testAdditionalConfigFiles() throws Exception {
        URL url = ClassLoader.getSystemResource("hive-site.xml");
        File fileHiveSite = new File(url.getPath());
        String parFolder = fileHiveSite.getParent();
        String bakHiveSiteFileName = parFolder + "/hive-site-bak.xml";
        File fileBakHiveSite = new File(bakHiveSiteFileName);
        FileUtils.copyFile((File)fileHiveSite, (File)fileBakHiveSite);
        String content = FileUtils.readFileToString((File)fileHiveSite);
        content = content.substring(0, content.lastIndexOf("</configuration>"));
        String testHiveSiteString = content + "<property>\n <name>HIVE_SERVER2_PLAIN_LDAP_DOMAIN</name>\n <value>a.com</value>\n</property>\n\n <property>\n   <name>hive.additional.config.files</name>\n   <value>ldap-site.xml,other.xml</value>\n   <description>additional config dir for Hive to load</description>\n </property>\n\n</configuration>";
        FileUtils.writeStringToFile((File)fileHiveSite, (String)testHiveSiteString);
        String testLdapString = "<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration>\n  <property>\n  <name>hive.server2.authentication.ldap.Domain</name>\n  <value>b.com</value>\n</property>\n\n</configuration>";
        String newFileName = parFolder + "/ldap-site.xml";
        File f2 = new File(newFileName);
        FileUtils.writeStringToFile((File)f2, (String)testLdapString);
        HiveConf conf = new HiveConf();
        String val = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN);
        Assert.assertEquals((Object)"b.com", (Object)val);
        FileUtils.copyFile((File)fileBakHiveSite, (File)fileHiveSite);
        f2.delete();
        fileBakHiveSite.delete();
    }
}

