/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import com.google.common.base.Joiner;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConfForTest
extends HiveConf {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveConfForTest.class.getName());
    private String testDataDir;
    private Map<String, String> overlay = new HashMap<String, String>();

    public HiveConfForTest(Class<?> cls) {
        super(cls);
        this.init(cls);
    }

    public HiveConfForTest(Configuration configuration, Class<?> cls) {
        super(configuration, cls);
        this.init(cls);
    }

    private void init(Class<?> cls) {
        this.initDataDir(cls);
        LOG.info("Using test data dir (class: {}): {}", (Object)cls.getName(), (Object)this.testDataDir);
        Path installDir = Paths.get(System.getProperty("test.tmp.dir"), "user_install_dir");
        this.setValue(HiveConf.ConfVars.HIVE_USER_INSTALL_DIR.varname, installDir.toString());
        this.setValue(HiveConf.ConfVars.HIVE_CLI_TEZ_INITIALIZE_SESSION.varname, "false");
        this.setValue("tez.local.mode", "true");
        this.setValue("tez.local.mode.without.network", "true");
        this.setValue("hive.in.tez.test", "true");
        this.setValue("tez.local.cache.root.folder", System.getProperty("build.dir"));
        this.setValue("tez.dag.recovery.enabled", "false");
        this.setValue(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED.varname, "false");
    }

    public void setValue(String name, String value) {
        this.overlay.put(name, value);
        super.set(name, value);
    }

    private void initDataDir(Class<?> cls) {
        this.testDataDir = new File(String.format("%s/%s-%d", System.getProperty("build.dir"), cls.getCanonicalName(), System.currentTimeMillis())).getPath();
    }

    public String getTestDataDir() {
        return this.testDataDir;
    }

    public String getOverlayOptionsAsQueryString() {
        return Joiner.on((String)";").withKeyValueSeparator("=").join(this.overlay);
    }
}

