/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.util.Random;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveBaseChar {
    static Random rnd = new Random();

    public static int getRandomSupplementaryChar() {
        int lowSurrogate = 56320 + rnd.nextInt(1024);
        int highSurrogate = 55296;
        return Character.toCodePoint((char)highSurrogate, (char)lowSurrogate);
    }

    public static int getRandomCodePoint() {
        int codePoint = rnd.nextDouble() < 0.5 ? 32 + rnd.nextInt(90) : TestHiveBaseChar.getRandomSupplementaryChar();
        if (!Character.isValidCodePoint(codePoint)) {
            System.out.println(Integer.toHexString(codePoint) + " is not a valid code point");
        }
        return codePoint;
    }

    public static int getRandomCodePoint(int excludeChar) {
        int codePoint;
        while ((codePoint = TestHiveBaseChar.getRandomCodePoint()) == excludeChar) {
        }
        return codePoint;
    }

    public static String createRandomSupplementaryCharString(int len) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < len; ++idx) {
            sb.appendCodePoint(TestHiveBaseChar.getRandomCodePoint(32));
        }
        return sb.toString();
    }

    @Test
    public void testStringLength() throws Exception {
        int strLen = 20;
        int[] lengths = new int[]{15, 20, 25};
        for (int idx1 = 0; idx1 < lengths.length; ++idx1) {
            int curLen = lengths[idx1];
            String testString = TestHiveBaseChar.createRandomSupplementaryCharString(curLen);
            Assert.assertEquals((long)curLen, (long)testString.codePointCount(0, testString.length()));
            String enforcedString = HiveBaseChar.enforceMaxLength((String)testString, (int)strLen);
            if (curLen <= strLen) {
                Assert.assertEquals((Object)testString, (Object)enforcedString);
                continue;
            }
            Assert.assertEquals((long)strLen, (long)enforcedString.codePointCount(0, enforcedString.length()));
        }
        Assert.assertNull((Object)HiveBaseChar.enforceMaxLength(null, (int)0));
    }

    @Test
    public void testGetPaddedValue() {
        int strLen = 20;
        int[] lengths = new int[]{15, 20, 25};
        for (int idx1 = 0; idx1 < lengths.length; ++idx1) {
            int curLen = lengths[idx1];
            String testString = TestHiveBaseChar.createRandomSupplementaryCharString(curLen);
            Assert.assertEquals((long)curLen, (long)testString.codePointCount(0, testString.length()));
            String paddedString = HiveBaseChar.getPaddedValue((String)testString, (int)strLen);
            Assert.assertEquals((long)strLen, (long)paddedString.codePointCount(0, paddedString.length()));
        }
        Assert.assertEquals((Object)"abc       ", (Object)HiveBaseChar.getPaddedValue((String)"abc", (int)10));
        Assert.assertEquals((Object)"abc       ", (Object)HiveBaseChar.getPaddedValue((String)"abc ", (int)10));
        Assert.assertNull((Object)HiveBaseChar.getPaddedValue(null, (int)0));
    }
}

