/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import org.apache.hadoop.hive.common.jsonexplain.DagJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.Op;
import org.apache.hadoop.hive.common.jsonexplain.Vertex;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVertex {
    private TezJsonParser tezJsonParser;

    @Before
    public void setUp() throws Exception {
        this.tezJsonParser = new TezJsonParser();
    }

    @Test
    public void testExtractOpTree() throws Exception {
        JSONObject object = new JSONObject("{\"Join:\":[{},{}]}");
        Vertex uut = new Vertex("name", object, null, (DagJsonParser)this.tezJsonParser);
        uut.extractOpTree();
        Assert.assertEquals((long)2L, (long)uut.mergeJoinDummyVertices.size());
    }

    @Test
    public void testExtractOpNonJsonChildrenShouldThrow() throws Exception {
        String jsonString = "{\"opName\":{\"children\":\"not-json\"}}";
        JSONObject operator = new JSONObject(jsonString);
        Vertex uut = new Vertex("name", null, null, (DagJsonParser)this.tezJsonParser);
        try {
            uut.extractOp(operator, null);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Unsupported operator name's children operator is neither a jsonobject nor a jsonarray", (Object)e.getMessage());
        }
    }

    @Test
    public void testExtractOpNoChildrenOperatorId() throws Exception {
        String jsonString = "{\"opName\":{\"OperatorId:\":\"operator-id\"}}";
        JSONObject operator = new JSONObject(jsonString);
        Vertex uut = new Vertex("name", null, null, (DagJsonParser)this.tezJsonParser);
        Op result = uut.extractOp(operator, null);
        Assert.assertEquals((Object)"opName", (Object)result.name);
        Assert.assertEquals((Object)"operator-id", (Object)result.operatorId);
        Assert.assertEquals((long)0L, (long)result.children.size());
        Assert.assertEquals((long)0L, (long)result.attrs.size());
    }

    @Test
    public void testExtractOpOneChild() throws Exception {
        String jsonString = "{\"opName\":{\"children\":{\"childName\":{\"OperatorId:\":\"child-operator-id\"}}}}";
        JSONObject operator = new JSONObject(jsonString);
        Vertex uut = new Vertex("name", null, null, (DagJsonParser)this.tezJsonParser);
        Op result = uut.extractOp(operator, null);
        Assert.assertEquals((Object)"opName", (Object)result.name);
        Assert.assertEquals((long)1L, (long)result.children.size());
        Assert.assertEquals((Object)"childName", (Object)((Op)result.children.get((int)0)).name);
        Assert.assertEquals((Object)"child-operator-id", (Object)((Op)result.children.get((int)0)).operatorId);
    }

    @Test
    public void testExtractOpMultipleChildren() throws Exception {
        String jsonString = "{\"opName\":{\"children\":[{\"childName1\":{\"OperatorId:\":\"child-operator-id1\"}},{\"childName2\":{\"OperatorId:\":\"child-operator-id2\"}}]}}";
        JSONObject operator = new JSONObject(jsonString);
        Vertex uut = new Vertex("name", null, null, (DagJsonParser)this.tezJsonParser);
        Op result = uut.extractOp(operator, null);
        Assert.assertEquals((Object)"opName", (Object)result.name);
        Assert.assertEquals((long)2L, (long)result.children.size());
        Assert.assertEquals((Object)"childName1", (Object)((Op)result.children.get((int)0)).name);
        Assert.assertEquals((Object)"child-operator-id1", (Object)((Op)result.children.get((int)0)).operatorId);
        Assert.assertEquals((Object)"childName2", (Object)((Op)result.children.get((int)1)).name);
        Assert.assertEquals((Object)"child-operator-id2", (Object)((Op)result.children.get((int)1)).operatorId);
    }
}

