/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.format.datetime;

import com.google.common.base.Optional;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveSqlDateTimeFormatter {
    private HiveSqlDateTimeFormatter formatter;

    @Test
    public void testSetPattern() {
        this.verifyPatternParsing(" ---yyyy-'-:-  -,.;/MM-dd--", Arrays.asList(null, ChronoField.YEAR, null, ChronoField.MONTH_OF_YEAR, null, ChronoField.DAY_OF_MONTH, null));
        this.verifyPatternParsing("ymmdddhh24::mi:ss A.M. pm", 25, "ymmdddhh24::mi:ss A.M. pm", Arrays.asList(ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_YEAR, ChronoField.HOUR_OF_DAY, null, ChronoField.MINUTE_OF_HOUR, null, ChronoField.SECOND_OF_MINUTE, null, ChronoField.AMPM_OF_DAY, null, ChronoField.AMPM_OF_DAY));
    }

    @Test
    public void testSetPatternWithBadPatterns() {
        this.verifyBadPattern("", true);
        this.verifyBadPattern("eyyyy-ddd", true);
        this.verifyBadPattern("1yyyy-mm-dd", true);
        this.verifyBadPattern("yyyy Y", true);
        this.verifyBadPattern("yyyy R", true);
        this.verifyBadPattern("yyyy", true);
        this.verifyBadPattern("yyyy-mm", true);
        this.verifyBadPattern("yyyy-dd", true);
        this.verifyBadPattern("mm-dd", true);
        this.verifyBadPattern("ddd", true);
        this.verifyBadPattern("yyyy-MM-DDD", true);
        this.verifyBadPattern("yyyy-mm-DD DDD", true);
        this.verifyBadPattern("yyyy-mm-dd HH24 HH12", true);
        this.verifyBadPattern("yyyy-mm-dd HH24 AM", true);
        this.verifyBadPattern("yyyy-mm-dd HH24 SSSSS", true);
        this.verifyBadPattern("yyyy-mm-dd HH12 SSSSS", true);
        this.verifyBadPattern("yyyy-mm-dd SSSSS AM", true);
        this.verifyBadPattern("yyyy-mm-dd MI SSSSS", true);
        this.verifyBadPattern("yyyy-mm-dd SS SSSSS", true);
        this.verifyBadPattern("yyyy mm-MON dd", true);
        this.verifyBadPattern("yyyy mm-MONTH dd", true);
        this.verifyBadPattern("yyyy MON, month dd", true);
        this.verifyBadPattern("iyyy-mm-dd", true);
        this.verifyBadPattern("iyyy-id", true);
        this.verifyBadPattern("iyyy-iw", true);
        this.verifyBadPattern("iw-id", true);
        this.verifyBadPattern("tzm", false);
        this.verifyBadPattern("tzh", false);
        this.verifyBadPattern("yyyy-mm-dd q", true);
        this.verifyBadPattern("yyyy-mm-dd d", true);
        this.verifyBadPattern("yyyy-mm-dd dy", true);
        this.verifyBadPattern("yyyy-mm-dd day", true);
        this.verifyBadPattern("yyyy-mm-dd w", true);
        this.verifyBadPattern("yyyy-mm-dd ww", true);
    }

    @Test
    public void testFormatTimestamp() {
        this.checkFormatTs("rr rrrr ddd", "2018-01-03 00:00:00", "18 2018 003");
        this.checkFormatTs("yyyy-mm-ddtsssss.ff4z", "2018-02-03 00:00:10.777777777", "2018-02-03T00010.7777Z");
        this.checkFormatTs("hh24:mi:ss.ff1", "2018-02-03 01:02:03.999999999", "01:02:03.9");
        this.checkFormatTs("y yyy hh:mi:ss.ffz", "2018-02-03 01:02:03.0070070", "8 018 01:02:03.007007Z");
        this.checkFormatTs("am a.m. pm p.m. AM A.M. PM P.M.", "2018-02-03 01:02:03.0070070", "am a.m. am a.m. AM A.M. AM A.M.");
        this.checkFormatTs("HH12 P.M.", "2019-01-01 00:15:10", "12 A.M.");
        this.checkFormatTs("HH12 AM", "2019-01-01 12:15:10", "12 PM");
        this.checkFormatTs("YYYY-MM-DD HH12PM", "2017-05-05 00:00:00", "2017-05-05 12AM");
        this.checkFormatTs("YYYY-MONTH-DD", "2019-01-01 00:00:00", "2019-JANUARY  -01");
        this.checkFormatTs("YYYY-MOnth-DD", "2019-01-01 00:00:00", "2019-JANUARY  -01");
        this.checkFormatTs("YYYY-Month-DD", "2019-01-01 00:00:00", "2019-January  -01");
        this.checkFormatTs("YYYY-MoNTH-DD", "2019-01-01 00:00:00", "2019-January  -01");
        this.checkFormatTs("YYYY-month-DD", "2019-01-01 00:00:00", "2019-january  -01");
        this.checkFormatTs("YYYY-mONTH-DD", "2019-01-01 00:00:00", "2019-january  -01");
        this.checkFormatTs("YYYY-MON-DD", "2019-01-01 00:00:00", "2019-JAN-01");
        this.checkFormatTs("YYYY-MOn-DD", "2019-01-01 00:00:00", "2019-JAN-01");
        this.checkFormatTs("YYYY-Mon-DD", "2019-01-01 00:00:00", "2019-Jan-01");
        this.checkFormatTs("YYYY-MoN-DD", "2019-01-01 00:00:00", "2019-Jan-01");
        this.checkFormatTs("YYYY-mon-DD", "2019-01-01 00:00:00", "2019-jan-01");
        this.checkFormatTs("YYYY-mON-DD", "2019-01-01 00:00:00", "2019-jan-01");
        this.checkFormatTs("D: DAY", "2019-01-01 00:00:00", "3: TUESDAY  ");
        this.checkFormatTs("D: DAy", "2019-01-01 00:00:00", "3: TUESDAY  ");
        this.checkFormatTs("D: Day", "2019-01-02 00:00:00", "4: Wednesday");
        this.checkFormatTs("D: DaY", "2019-01-02 00:00:00", "4: Wednesday");
        this.checkFormatTs("D: day", "2019-01-03 00:00:00", "5: thursday ");
        this.checkFormatTs("D: dAY", "2019-01-03 00:00:00", "5: thursday ");
        this.checkFormatTs("D: DY", "2019-01-04 00:00:00", "6: FRI");
        this.checkFormatTs("D: Dy", "2019-01-05 00:00:00", "7: Sat");
        this.checkFormatTs("D: dy", "2019-01-06 00:00:00", "1: sun");
        this.checkFormatTs("D: DAY", "2019-01-07 00:00:00", "2: MONDAY   ");
        this.checkFormatTs("YYYY-mm-dd: Q WW W", "2019-01-01 00:00:00", "2019-01-01: 1 01 1");
        this.checkFormatTs("YYYY-mm-dd: Q WW W", "2019-01-07 00:00:00", "2019-01-07: 1 01 1");
        this.checkFormatTs("YYYY-mm-dd: Q WW W", "2019-01-08 00:00:00", "2019-01-08: 1 02 2");
        this.checkFormatTs("YYYY-mm-dd: Q WW W", "2019-03-31 00:00:00", "2019-03-31: 1 13 5");
        this.checkFormatTs("YYYY-mm-dd: Q WW W", "2019-04-01 00:00:00", "2019-04-01: 2 13 1");
        this.checkFormatTs("YYYY-mm-dd: Q WW W", "2019-12-31 00:00:00", "2019-12-31: 4 53 5");
    }

    @Test
    public void testFormatTimestampIso8601() {
        this.checkFormatTs("YYYY-MM-DD : IYYY-IW-ID", "2018-12-31 00:00:00", "2018-12-31 : 2019-01-01");
        this.checkFormatTs("YYYY-MM-DD : IYYY-IW-ID", "2019-01-06 00:00:00", "2019-01-06 : 2019-01-07");
        this.checkFormatTs("YYYY-MM-DD : IYYY-IW-ID", "2019-01-07 00:00:00", "2019-01-07 : 2019-02-01");
        this.checkFormatTs("YYYY-MM-DD : IYYY-IW-ID", "2019-12-29 00:00:00", "2019-12-29 : 2019-52-07");
        this.checkFormatTs("YYYY-MM-DD : IYYY-IW-ID", "2019-12-30 00:00:00", "2019-12-30 : 2020-01-01");
        this.checkFormatTs("YYYY-MM-DD : IYY-IW-ID", "2019-12-30 00:00:00", "2019-12-30 : 020-01-01");
        this.checkFormatTs("YYYY-MM-DD : IY-IW-ID", "2019-12-30 00:00:00", "2019-12-30 : 20-01-01");
        this.checkFormatTs("YYYY-MM-DD : I-IW-ID", "2019-12-30 00:00:00", "2019-12-30 : 0-01-01");
        this.checkFormatTs("id: Day", "2018-12-31 00:00:00", "01: Monday   ");
        this.checkFormatTs("id: Day", "2019-01-01 00:00:00", "02: Tuesday  ");
        this.checkFormatTs("id: Day", "2019-01-02 00:00:00", "03: Wednesday");
        this.checkFormatTs("id: Day", "2019-01-03 00:00:00", "04: Thursday ");
        this.checkFormatTs("id: Day", "2019-01-04 00:00:00", "05: Friday   ");
        this.checkFormatTs("id: Day", "2019-01-05 00:00:00", "06: Saturday ");
        this.checkFormatTs("id: Day", "2019-01-06 00:00:00", "07: Sunday   ");
    }

    private void checkFormatTs(String pattern, String input, String expectedOutput) {
        this.formatter = new HiveSqlDateTimeFormatter(pattern, false, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Assert.assertEquals((String)("Format timestamp to string failed with pattern: " + pattern), (Object)expectedOutput, (Object)this.formatter.format(Timestamp.valueOf((String)input)));
    }

    @Test
    public void testFormatDate() {
        this.checkFormatDate("rr rrrr ddd", "2018-01-03", "18 2018 003");
        this.checkFormatDate("yyyy-mm-ddtsssss.ff4z", "2018-02-03", "2018-02-03T00000.0000Z");
        this.checkFormatDate("hh24:mi:ss.ff1", "2018-02-03", "00:00:00.0");
        this.checkFormatDate("y yyy T hh:mi:ss.ff am z", "2018-02-03", "8 018 T 12:00:00.0 am Z");
        this.checkFormatDate("am a.m. pm p.m. AM A.M. PM P.M.", "2018-02-03", "am a.m. am a.m. AM A.M. AM A.M.");
        this.checkFormatDate("DDD", "2019-12-31", "365");
        this.checkFormatDate("DDD", "2020-12-31", "366");
    }

    private void checkFormatDate(String pattern, String input, String expectedOutput) {
        this.formatter = new HiveSqlDateTimeFormatter(pattern, false, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Assert.assertEquals((String)("Format date to string failed with pattern: " + pattern), (Object)expectedOutput, (Object)this.formatter.format(Date.valueOf((String)input)));
    }

    @Test
    public void testParseTimestamp() {
        this.checkParseTimestamp("y-mm-dd", "0-02-03", "1970-02-03 00:00:00");
        this.checkParseTimestamp("yy-mm-dd", "00-02-03", "1900-02-03 00:00:00");
        this.checkParseTimestamp("yyy-mm-dd", "000-02-03", "1000-02-03 00:00:00");
        this.checkParseTimestamp("yyyy-mm-dd", "000-02-03", "1000-02-03 00:00:00");
        this.checkParseTimestamp("rr-mm-dd", "0-02-03", "1970-02-03 00:00:00");
        this.checkParseTimestamp("rrrr-mm-dd", "000-02-03", "1000-02-03 00:00:00");
        this.checkParseTimestamp("rr-mm-dd", "00-02-03", "2000-02-03 00:00:00");
        this.checkParseTimestamp("rr-mm-dd", "49-02-03", "2049-02-03 00:00:00");
        this.checkParseTimestamp("rr-mm-dd", "50-02-03", "1950-02-03 00:00:00");
        this.checkParseTimestamp("rr-mm-dd", "99-02-03", "1999-02-03 00:00:00");
        this.checkParseTimestamp("rrrr-mm-dd", "00-02-03", "2000-02-03 00:00:00");
        this.checkParseTimestamp("rrrr-mm-dd", "49-02-03", "2049-02-03 00:00:00");
        this.checkParseTimestamp("rrrr-mm-dd", "50-02-03", "1950-02-03 00:00:00");
        this.checkParseTimestamp("rrrr-mm-dd", "99-02-03", "1999-02-03 00:00:00");
        this.checkParseTimestamp("yyyy-mm-ddThh24:mi:ss.ff8z", "2018-02-03T04:05:06.5665Z", "2018-02-03 04:05:06.5665");
        this.checkParseTimestamp("yyyy-mm-dd hh24:mi:ss.ff", "2018-02-03 04:05:06.555555555", "2018-02-03 04:05:06.555555555");
        this.checkParseTimestamp("yyyy-mm-dd hh12:mi:ss", "2099-2-03 04:05:06", "2099-02-03 04:05:06");
        this.checkParseTimestamp("yyyyddd", "2018284", "2018-10-11 00:00:00");
        this.checkParseTimestamp("yyyyddd", "20184", "2018-01-04 00:00:00");
        this.checkParseTimestamp("yyyy-mm-ddThh24:mi:ss.ffz", "2018-02-03t04:05:06.444Z", "2018-02-03 04:05:06.444");
        this.checkParseTimestamp("yyyy-mm-dd hh:mi:ss A.M.", "2018-02-03 04:05:06 P.M.", "2018-02-03 16:05:06");
        this.checkParseTimestamp("YYYY-MM-DD HH24:MI TZH:TZM", "2019-1-1 14:00--1:-30", "2019-01-01 14:00:00");
        this.checkParseTimestamp("YYYY-MM-DD HH24:MI TZH:TZM", "2019-1-1 14:00-1:30", "2019-01-01 14:00:00");
        this.checkParseTimestamp("yyyy-mm-dd TZM:TZH", "2019-01-01 1 -3", "2019-01-01 00:00:00");
        this.checkParseTimestamp("yyyy-mm-dd TZH:TZM", "2019-01-01 -0:30", "2019-01-01 00:00:00");
        this.checkParseTimestamp("TZM/YYY-MM-TZH/DD", "0/333-01-11/02", "1333-01-02 00:00:00");
        this.checkParseTimestamp("YYYY-MM-DD HH12:MI AM", "2019-01-01 11:00 p.m.", "2019-01-01 23:00:00");
        this.checkParseTimestamp("YYYY-MM-DD HH12:MI A.M..", "2019-01-01 11:00 pm.", "2019-01-01 23:00:00");
        this.checkParseTimestamp("MI DD-TZM-YYYY-MM TZHPM SS:HH12.FF9", "59 03-30-2017-05 01PM 01:08.123456789", "2017-05-03 20:59:01.123456789");
        this.checkParseTimestamp("YYYYDDMMHH12MISSFFAMTZHTZM", "20170501123159123456789AM-0130", "2017-01-05 00:31:59.123456789");
        this.checkParseTimestamp("YYYY-MM-DD AMHH12", "2017-05-06 P.M.12", "2017-05-06 12:00:00");
        this.checkParseTimestamp("YYYY-MM-DD HH12PM", "2017-05-05 12AM", "2017-05-05 00:00:00");
        this.checkParseTimestamp("YYYY-MM-DD HH12:MI:SS.FF9PM TZH:TZM", "2017-05-03 08:59:01.123456789PM 01:30", "2017-05-03 20:59:01.123456789");
        this.checkParseTimestamp("YYYYDDMMHH12MISSFFAMTZHTZM", "20170501120159123456789AM-0130", "2017-01-05 00:01:59.123456789");
        this.checkParseTimestamp("YYYY DDD", "2000 60", "2000-02-29 00:00:00");
        this.checkParseTimestamp("YYYY DDD", "2000 61", "2000-03-01 00:00:00");
        this.checkParseTimestamp("YYYY DDD", "2000 366", "2000-12-31 00:00:00");
        this.checkParseTimestamp("dd mm yyyy", "29 02 2000", "2000-02-29 00:00:00");
        this.checkParseTimestamp("YYYYMMDDHH12MIA.M.TZHTZM", "201812310800AM+0515", "2018-12-31 08:00:00");
        this.checkParseTimestamp("YYYYMMDDHH12MIA.M.TZHTZM", "201812310800AM0515", "2018-12-31 08:00:00");
        this.checkParseTimestamp("YYYYMMDDHH12MIA.M.TZHTZM", "201812310800AM-0515", "2018-12-31 08:00:00");
        this.checkParseTimestamp("yyyy-MONTH-dd", "2018-FEBRUARY-28", "2018-02-28 00:00:00");
        this.checkParseTimestamp("yyyy-Month-dd", "2018-february-28", "2018-02-28 00:00:00");
        this.checkParseTimestamp("yyyy-month-dd", "2018-FEBRUARY-28", "2018-02-28 00:00:00");
        this.checkParseTimestamp("yyyy-montH-dd", "2018-febRuary-28", "2018-02-28 00:00:00");
        this.checkParseTimestamp("yyyy-MON-dd", "2018-FEB-28", "2018-02-28 00:00:00");
        this.checkParseTimestamp("yyyy-moN-dd", "2018-FeB-28", "2018-02-28 00:00:00");
        this.checkParseTimestamp("yyyy-mon-dd", "2018-FEB-28", "2018-02-28 00:00:00");
        this.verifyBadParseString("yyyy-MON-dd", "2018-FEBRUARY-28");
        this.verifyBadParseString("yyyy-MON-dd", "2018-FEBR-28");
        this.verifyBadParseString("yyyy-MONTH-dd", "2018-FEB-28");
        this.checkParseDate("yyyy-ddMONTH", "2018-4March", "2018-03-04");
        this.checkParseDate("yyyy-MONTHdd", "2018-March4", "2018-03-04");
    }

    @Test
    public void testParseTimestampISO8601() {
        this.checkParseTimestamp("IYYY-IW-ID", "2019-01-01", "2018-12-31 00:00:00");
        this.checkParseTimestamp("IYYY-IW-ID", "2019-01-07", "2019-01-06 00:00:00");
        this.checkParseTimestamp("IYYY-IW-ID", "2019-02-01", "2019-01-07 00:00:00");
        this.checkParseTimestamp("IYYY-IW-ID", "2019-52-07", "2019-12-29 00:00:00");
        this.checkParseTimestamp("IYYY-IW-ID", "2020-01-01", "2019-12-30 00:00:00");
        this.checkParseTimestamp("IYYY-IW-ID", "020-01-04", "1020-01-06 00:00:00");
        this.checkParseTimestamp("IYY-IW-ID", "020-01-04", "1020-01-06 00:00:00");
        this.checkParseTimestamp("IYY-IW-ID", "20-01-04", "1920-01-01 00:00:00");
        this.checkParseTimestamp("IY-IW-ID", "20-01-04", "1920-01-01 00:00:00");
        this.checkParseTimestamp("IYYY-IW-DAY", "2019-01-monday", "2018-12-31 00:00:00");
        this.checkParseTimestamp("IYYY-IW-Day", "2019-01-Sunday", "2019-01-06 00:00:00");
        this.checkParseTimestamp("IYYY-IW-Dy", "2019-02-MON", "2019-01-07 00:00:00");
        this.checkParseTimestamp("IYYY-IW-DY", "2019-52-sun", "2019-12-29 00:00:00");
        this.checkParseTimestamp("IYYY-IW-dy", "2020-01-Mon", "2019-12-30 00:00:00");
        this.checkParseTimestampIso("IY-IW-ID", "0-01-04", "iw, yyyy", "01, 1970");
        this.checkParseTimestampIso("I-IW-ID", "0-01-04", "iw, yyyy", "01, 1970");
        this.checkParseTimestamp("IYYY-IW-ID hh24:mi:ss", "2019-01-01 01:02:03", "2018-12-31 01:02:03");
    }

    private void checkParseTimestamp(String pattern, String input, String expectedOutput) {
        this.formatter = new HiveSqlDateTimeFormatter(pattern, true, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Assert.assertEquals((String)("Parse string to timestamp failed. Pattern: " + pattern), (Object)Timestamp.valueOf((String)expectedOutput), (Object)this.formatter.parseTimestamp(input));
    }

    private void checkParseTimestampIso(String parsePattern, String input, String formatPattern, String expectedOutput) {
        this.formatter = new HiveSqlDateTimeFormatter(parsePattern, true, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Timestamp ts = this.formatter.parseTimestamp(input);
        this.formatter = new HiveSqlDateTimeFormatter(formatPattern, false, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Assert.assertEquals((Object)expectedOutput, (Object)this.formatter.format(ts));
    }

    @Test
    public void testParseDate() {
        this.checkParseDate("y-mm-dd", "0-02-03", "1970-02-03");
        this.checkParseDate("yy-mm-dd", "00-02-03", "1900-02-03");
        this.checkParseDate("yyy-mm-dd", "000-02-03", "1000-02-03");
        this.checkParseDate("yyyy-mm-dd", "000-02-03", "1000-02-03");
        this.checkParseDate("rr-mm-dd", "0-02-03", "1970-02-03");
        this.checkParseDate("rrrr-mm-dd", "000-02-03", "1000-02-03");
        this.checkParseDate("rr-mm-dd", "00-02-03", "2000-02-03");
        this.checkParseDate("rr-mm-dd", "49-02-03", "2049-02-03");
        this.checkParseDate("rr-mm-dd", "50-02-03", "1950-02-03");
        this.checkParseDate("rr-mm-dd", "99-02-03", "1999-02-03");
        this.checkParseDate("rrrr-mm-dd", "00-02-03", "2000-02-03");
        this.checkParseDate("rrrr-mm-dd", "49-02-03", "2049-02-03");
        this.checkParseDate("rrrr-mm-dd", "50-02-03", "1950-02-03");
        this.checkParseDate("rrrr-mm-dd", "99-02-03", "1999-02-03");
        this.checkParseDate("yyyy-mm-dd hh mi ss.ff7", "2018/01/01 2.2.2.55", "2018-01-01");
        this.checkParseDate("dd/MonthT/yyyy", "31/AugustT/2020", "2020-08-31");
        this.checkParseDate("dd/MonthT/yyyy", "31/MarchT/2020", "2020-03-31");
    }

    @Test
    public void testParseDateISO8601() {
        this.checkParseDate("IYYY-IW-ID", "2019-01-01", "2018-12-31");
        this.checkParseDate("IW-ID-IYYY", "01-02-2019", "2019-01-01");
        this.checkParseDate("ID-IW-IYYY", "02-01-2019", "2019-01-01");
        this.checkParseDate("IYYY-IW-ID", "2019-01-07", "2019-01-06");
        this.checkParseDate("IYYY-IW-ID", "2019-02-01", "2019-01-07");
        this.checkParseDate("IYYY-IW-ID", "2019-52-07", "2019-12-29");
        this.checkParseDate("IYYY-IW-ID", "2020-01-01", "2019-12-30");
    }

    private void checkParseDate(String pattern, String input, String expectedOutput) {
        this.formatter = new HiveSqlDateTimeFormatter(pattern, true, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Assert.assertEquals((String)("Parse string to date failed. Pattern: " + pattern), (Object)Date.valueOf((String)expectedOutput), (Object)this.formatter.parseDate(input));
    }

    @Test
    public void testParseTimestampError() {
        this.verifyBadParseString("yyyy-mm-dd  ", "2019-02-03");
        this.verifyBadParseString("yyyy-mm-dd", "2019-02-03...");
        this.verifyBadParseString("yyyy-mm-dd hh12:mi:ss", "2019-02-03 14:00:00");
        this.verifyBadParseString("yyyy-dddsssss", "2019-912345");
        this.verifyBadParseString("yyyy-mm-dd", "2019-13-23");
        this.verifyBadParseString("yyyy-mm-dd tzh:tzm", "2019-01-01 +16:00");
        this.verifyBadParseString("yyyy-mm-dd tzh:tzm", "2019-01-01 +14:60");
        this.verifyBadParseString("YYYY DDD", "2000 367");
        this.verifyBadParseString("yyyy-mm-dd hh12 p.m. ss", "2020-01-01 0 am 00");
        this.verifyBadParseString("yyyy-month-dd", "2019-merch-23");
        this.verifyBadParseString("yyyy-mon-dd", "2019-mer-23");
        this.verifyBadParseString("yyyy-MON-dd", "2018-FEBRUARY-28");
        this.verifyBadParseString("yyyy-MON-dd", "2018-FEBR-28");
        this.verifyBadParseString("yyyy-MONTH-dd", "2018-FEB-28");
        this.verifyBadParseString("iyyy-iw-id", "2019-00-01");
        this.verifyBadParseString("iyyy-iw-id", "2019-53-01");
        this.verifyBadParseString("iw-iyyy-id", "53-2019-01");
        this.verifyBadParseString("iw-iyyy-id", "54-2019-01");
        this.verifyBadParseString("iyyy-iw-id", "2019-52-00");
        this.verifyBadParseString("iyyy-iw-id", "2019-52-08");
    }

    private void verifyBadPattern(String string, boolean forParsing) {
        try {
            this.formatter = new HiveSqlDateTimeFormatter(string, forParsing, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
            Assert.fail((String)("Bad pattern " + string + " should have thrown IllegalArgumentException but didn't"));
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Expected IllegalArgumentException, got another exception.", (Object)e.getClass().getName(), (Object)IllegalArgumentException.class.getName());
        }
    }

    @Test
    public void testFm() {
        this.checkFormatTs("FMyyy-FMmm-dd FMHH12:MI:FMSS", "2019-01-01 01:01:01", "19-1-01 1:01:1");
        this.checkFormatTs("FMiyy-FMiw-id FMHH12:MI:FMSS", "2018-12-31 01:01:01", "19-1-01 1:01:1");
        this.checkFormatTs("FF5/FMFF5", "2019-01-01 01:01:01.0333", "03330/03330");
        this.checkFormatTs("FF/FMFF", "2019-01-01 01:01:01.0333", "0333/0333");
        this.checkFormatTs("YYYY-fmMonth-DD", "2019-01-01 00:00:00", "2019-January-01");
        this.checkFormatTs("D: fmDAY", "2019-01-01 00:00:00", "3: TUESDAY");
        this.checkFormatTs("D: fmDay", "2019-01-02 00:00:00", "4: Wednesday");
        this.verifyBadPattern("yyy-mm-dd FM,HH12", false);
        this.verifyBadPattern("yyy-mm-dd FM,HH12", true);
        this.verifyBadPattern("yyy-mm-dd HH12 tzh:fmtzm", true);
        this.verifyBadPattern("FMFMyyy-mm-dd", true);
        this.verifyBadPattern("FMFXDD-MM-YYYY ff2", true);
    }

    @Test
    public void testFx() {
        this.checkParseDate("FXDD-MM-YYYY", "01-01-1998", "1998-01-01");
        this.checkParseTimestamp("FXDD-MM-YYYY hh12:mi:ss.ff", "15-01-1998 11:12:13.0", "1998-01-15 11:12:13");
        this.checkParseTimestamp("FXDD-MM-YYYY hh12:mi:ss.ff6", "01-01-1998 00:00:00.4440", "1998-01-01 00:00:00.444");
        this.checkParseTimestamp("DD-MM-YYYYFX", "01-01-1998", "1998-01-01 00:00:00");
        this.verifyBadParseString("DD-MM-YYYYFX", "1-01-1998");
        this.verifyBadParseString("FXDD-MM-YYYY", "15/01/1998");
        this.verifyBadParseString("FXDD-MM-YYYY", "1-01-1998");
        this.verifyBadParseString("FXDD-MM-YYYY", "01-01-98");
        this.verifyBadParseString("FXDD-MM-YYYY", "   01-01-1998   ");
        this.verifyBadParseString("FXyyyy-mm-dd hh24:miss", "2018-01-01 17:005");
        this.verifyBadParseString("FXyyyy-mm-dd sssss", "2019-01-01 003");
        this.verifyBadParseString("FXiyyy-iw-id hh24:mi:ss", "019-01-02 17:00:05");
        this.checkParseTimestamp("\"the DATE is\" yyyy-mm-dd", "the date is 2018-01-01", "2018-01-01 00:00:00");
        this.checkParseTimestamp("FXDD-MM-YYYY hh12 am", "01-01-1998 12 PM", "1998-01-01 12:00:00");
        this.checkParseTimestamp("FXDD-MM-YYYY hh12 A.M.", "01-01-1998 12 p.m.", "1998-01-01 12:00:00");
        this.verifyBadParseString("FXDD-MM-YYYY hh12 am", "01-01-1998 12 p.m.");
        this.verifyBadParseString("FXDD-MM-YYYY hh12 a.m.", "01-01-1998 12 pm");
        this.checkParseTimestamp("FXDD-month-YYYY", "15-March-1998", "1998-03-15 00:00:00");
    }

    @Test
    public void testFmFx() {
        this.checkParseTimestamp("FXDD-FMMM-YYYY hh12 am", "01-1-1998 12 PM", "1998-01-01 12:00:00");
        this.checkParseTimestamp("FXFMDD-MM-YYYY hh12 am", "1-01-1998 12 PM", "1998-01-01 12:00:00");
        this.checkParseTimestamp("FXFMiyyy-iw-id hh24:mi:ss", "019-01-02 17:00:05", "1019-01-05 17:00:05");
        this.verifyBadParseString("FXFMiyyy-iw-id hh24:mi:ss", "019-01-02 17:0:05");
        this.checkParseTimestamp("FXFMDD-MM-YYYY FMff2", "1-01-1998 4", "1998-01-01 00:00:00.4");
        this.checkParseTimestamp("FXFMDD-MM-YYYY ff2", "1-01-1998 4", "1998-01-01 00:00:00.4");
    }

    @Test
    public void testText() {
        this.checkFormatTs("hh24:mi \" Is \" hh12 PM\".\"", "2008-01-01 17:00:00", "17:00  Is  05 PM.");
        this.checkFormatDate("\" `the _year_ is` \" yyyy\".\"", "2008-01-01", " `the _year_ is`  2008.");
        this.checkParseTimestamp("\"\"yyyy\"\"-mm-dd\"\"", "2019-01-01", "2019-01-01 00:00:00");
        this.checkParseDate("\"\"yyyy\"\"-mm-dd\"\"", "2019-01-01", "2019-01-01");
        this.checkParseTimestamp("\"Year \"YYYY \"month\" MM \"day\" DD.\"!\"", "YEaR 3000 mOnTh 3 DaY 1...!", "3000-03-01 00:00:00");
        this.checkParseDate("\"Year \"YYYY \"month\" MM \"day\" DD.\"!\"", "YEaR 3000 mOnTh 3 DaY 1...!", "3000-03-01");
        this.verifyBadParseString("\"Year! \"YYYY \"m\" MM \"d\" DD.\"!\"", "Year 3000 m 3 d 1,!");
        this.checkParseDate("yyyy\"m\"mm\"d\"dd", "19m1d1", "1919-01-01");
        this.checkParseDate("yyyy\"[\"mm\"]\"dd", "19[1]1", "1919-01-01");
        this.checkParseDate("dd/Month\"arch\"/yyyy", "31/Marcharch/2020", "2020-03-31");
        this.checkParseDate("dd/Month\"ember\"/yyyy", "31/Decemberember/2020", "2020-12-31");
        this.checkParseTimestamp("\"Y'ear \"YYYY ' \"month\" MM \"day\" DD.\"!\"", "Y'EaR 3000 ' mOnTh 3 DaY 1...!", "3000-03-01 00:00:00");
        this.checkParseDate("\"Y'ear \"YYYY ' \"month\" MM \"day\" DD.\"!\"", "Y'EaR 3000 ' mOnTh 3 DaY 1...!", "3000-03-01");
        this.checkFormatTs("\"the \\\"DATE\\\" is\" yyyy-mm-dd", "2018-01-01 00:00:00", "the \"DATE\" is 2018-01-01");
        this.checkFormatTs("\"\\\"\\\"\\\"\"", "2018-01-01 00:00:00", "\"\"\"");
        this.checkParseTimestamp("\"the \\\"DATE\\\" is\" yyyy-mm-dd", "the \"date\" is 2018-01-01", "2018-01-01 00:00:00");
        this.checkParseTimestamp("yyyy'\"\"mm-dd", "2019'01-01", "2019-01-01 00:00:00");
        this.checkParseTimestamp("yyyy'\"\"mm-dd", "2019'01-01", "2019-01-01 00:00:00");
        this.checkParseTimestamp("yyyy'\"\"mm-dd", "2019'01-01", "2019-01-01 00:00:00");
        this.checkParseTimestamp("yyyy'\"\"mm-dd", "2019'01-01", "2019-01-01 00:00:00");
        this.checkParseTimestamp("yyyy'\"\\\"\"mm-dd", "2019'\"01-01", "2019-01-01 00:00:00");
        this.checkParseTimestamp("yyyy'\"\\\"\"mm-dd", "2019'\"01-01", "2019-01-01 00:00:00");
    }

    private void verifyPatternParsing(String pattern, List<TemporalField> temporalFields) {
        this.verifyPatternParsing(pattern, pattern.length(), pattern.toLowerCase(), temporalFields);
    }

    private void verifyPatternParsing(String pattern, int expectedPatternLength, String expectedPattern, List<TemporalField> temporalFields) {
        this.formatter = new HiveSqlDateTimeFormatter(pattern, false, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        Assert.assertEquals((long)temporalFields.size(), (long)this.formatter.getTokens().size());
        StringBuilder sb = new StringBuilder();
        int actualPatternLength = 0;
        for (int i = 0; i < temporalFields.size(); ++i) {
            Assert.assertEquals((String)"Generated list of tokens not correct", (Object)temporalFields.get(i), (Object)((HiveSqlDateTimeFormatter.Token)this.formatter.getTokens().get((int)i)).temporalField);
            sb.append(((HiveSqlDateTimeFormatter.Token)this.formatter.getTokens().get((int)i)).string);
            actualPatternLength += ((HiveSqlDateTimeFormatter.Token)this.formatter.getTokens().get((int)i)).length;
        }
        Assert.assertEquals((String)"Token strings concatenated don't match original pattern string", (Object)expectedPattern, (Object)sb.toString());
        Assert.assertEquals((long)expectedPatternLength, (long)actualPatternLength);
    }

    private void verifyBadParseString(String pattern, String string) {
        this.formatter = new HiveSqlDateTimeFormatter(pattern, true, Optional.of((Object)LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)));
        try {
            Timestamp output = this.formatter.parseTimestamp(string);
            Assert.fail((String)("Parse string to timestamp should have failed.\nString: " + string + "\nPattern: " + pattern + ", output = " + output));
        }
        catch (Exception e) {
            Assert.assertEquals((String)("Expected IllegalArgumentException, got another exception:" + e), (Object)IllegalArgumentException.class.getName(), (Object)e.getClass().getName());
        }
    }
}

