/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import org.apache.hadoop.hive.common.NumberUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNumberUtils {
    @Test
    public void testMinLong() {
        long pair = NumberUtils.makeIntPair((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)NumberUtils.getFirstInt((long)pair));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)NumberUtils.getSecondInt((long)pair));
    }

    @Test
    public void testMaxLong() {
        long pair = NumberUtils.makeIntPair((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)NumberUtils.getFirstInt((long)pair));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)NumberUtils.getSecondInt((long)pair));
    }

    @Test
    public void testZeroLong() {
        long pair = NumberUtils.makeIntPair((int)0, (int)0);
        Assert.assertEquals((long)0L, (long)NumberUtils.getFirstInt((long)pair));
        Assert.assertEquals((long)0L, (long)NumberUtils.getSecondInt((long)pair));
    }

    @Test
    public void testNegativePositiveLong() {
        long pair = NumberUtils.makeIntPair((int)1, (int)-1);
        Assert.assertEquals((long)1L, (long)NumberUtils.getFirstInt((long)pair));
        Assert.assertEquals((long)-1L, (long)NumberUtils.getSecondInt((long)pair));
    }
}

