/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.DataCopyStatistics;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.MockFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileUtils {
    public static final Logger LOG = LoggerFactory.getLogger(TestFileUtils.class);

    @Test
    public void isPathWithinSubtree_samePrefix() {
        Path path = new Path("/somedir1");
        Path subtree = new Path("/somedir");
        Assert.assertFalse((boolean)FileUtils.isPathWithinSubtree((Path)path, (Path)subtree));
    }

    @Test
    public void isPathWithinSubtree_rootIsInside() {
        Path path = new Path("/foo");
        Path subtree = new Path("/foo");
        Assert.assertTrue((boolean)FileUtils.isPathWithinSubtree((Path)path, (Path)subtree));
    }

    @Test
    public void isPathWithinSubtree_descendantInside() {
        Path path = new Path("/foo/bar");
        Path subtree = new Path("/foo");
        Assert.assertTrue((boolean)FileUtils.isPathWithinSubtree((Path)path, (Path)subtree));
    }

    @Test
    public void isPathWithinSubtree_relativeWalk() {
        Path path = new Path("foo/../../bar");
        Path subtree = new Path("../bar");
        Assert.assertTrue((boolean)FileUtils.isPathWithinSubtree((Path)path, (Path)subtree));
    }

    @Test
    public void getParentRegardlessOfScheme_badCases() {
        Path path = new Path("proto://host1/foo/bar/baz");
        ArrayList<Path> candidates = new ArrayList<Path>();
        candidates.add(new Path("badproto://host1/foo"));
        candidates.add(new Path("proto://badhost1/foo"));
        candidates.add(new Path("proto://host1:71/foo/bar/baz"));
        candidates.add(new Path("proto://host1/badfoo"));
        candidates.add(new Path("/badfoo"));
        Path res = FileUtils.getParentRegardlessOfScheme((Path)path, candidates);
        Assert.assertNull((String)"none of these paths may match", (Object)res);
    }

    @Test
    public void getParentRegardlessOfScheme_priority() {
        Path path = new Path("proto://host1/foo/bar/baz");
        ArrayList<Path> candidates = new ArrayList<Path>();
        candidates.add(new Path("proto://host1/"));
        Path expectedPath = new Path("proto://host1/foo");
        candidates.add(expectedPath);
        Path res = FileUtils.getParentRegardlessOfScheme((Path)path, candidates);
        Assert.assertEquals((Object)expectedPath, (Object)res);
    }

    @Test
    public void getParentRegardlessOfScheme_root() {
        Path path = new Path("proto://host1/foo");
        ArrayList<Path> candidates = new ArrayList<Path>();
        Path expectedPath = new Path("proto://host1/foo");
        candidates.add(expectedPath);
        Path res = FileUtils.getParentRegardlessOfScheme((Path)path, candidates);
        Assert.assertEquals((Object)expectedPath, (Object)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetJarFilesByPath() {
        HiveConf conf = new HiveConf(this.getClass());
        File tmpDir = com.google.common.io.Files.createTempDir();
        String jarFileName1 = tmpDir.getAbsolutePath() + File.separator + "a.jar";
        String jarFileName2 = tmpDir.getAbsolutePath() + File.separator + "b.jar";
        File jarFile1 = new File(jarFileName1);
        try {
            org.apache.commons.io.FileUtils.touch((File)jarFile1);
            Set jars = FileUtils.getJarFilesByPath((String)tmpDir.getAbsolutePath(), (Configuration)conf);
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"file://" + jarFileName1}), (Object)jars);
            jars = FileUtils.getJarFilesByPath((String)"/folder/not/exist", (Configuration)conf);
            Assert.assertTrue((boolean)jars.isEmpty());
            File jarFile2 = new File(jarFileName2);
            org.apache.commons.io.FileUtils.touch((File)jarFile2);
            String newPath = "file://" + jarFileName1 + ",file://" + jarFileName2 + ",/file/not/exist";
            jars = FileUtils.getJarFilesByPath((String)newPath, (Configuration)conf);
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"file://" + jarFileName1, "file://" + jarFileName2}), (Object)jars);
        }
        catch (IOException e) {
            LOG.error("failed to copy file to reloading folder", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            org.apache.commons.io.FileUtils.deleteQuietly((File)tmpDir);
        }
    }

    @Test
    public void testRelativePathToAbsolutePath() throws IOException {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        Path actualPath = FileUtils.makeAbsolute((FileSystem)localFileSystem, (Path)new Path("relative/path"));
        Path expectedPath = new Path(localFileSystem.getWorkingDirectory(), "relative/path");
        Assert.assertEquals((Object)expectedPath.toString(), (Object)actualPath.toString());
        Path absolutePath = new Path("/absolute/path");
        Path unchangedPath = FileUtils.makeAbsolute((FileSystem)localFileSystem, (Path)new Path("/absolute/path"));
        Assert.assertEquals((Object)unchangedPath.toString(), (Object)absolutePath.toString());
    }

    @Test
    public void testIsPathWithinSubtree() throws IOException {
        Path splitPath = new Path("file:///user/hive/warehouse/src/data.txt");
        Path splitPathWithNoSchema = Path.getPathWithoutSchemeAndAuthority((Path)splitPath);
        HashSet<Path> parents = new HashSet<Path>();
        FileUtils.populateParentPaths(parents, (Path)splitPath);
        FileUtils.populateParentPaths(parents, (Path)splitPathWithNoSchema);
        Path key = new Path("/user/hive/warehouse/src");
        this.verifyIsPathWithInSubTree(splitPath, key, false);
        this.verifyIsPathWithInSubTree(splitPathWithNoSchema, key, true);
        this.verifyIfParentsContainPath(key, parents, true);
        key = new Path("/user/hive/warehouse/src_2");
        this.verifyIsPathWithInSubTree(splitPath, key, false);
        this.verifyIsPathWithInSubTree(splitPathWithNoSchema, key, false);
        this.verifyIfParentsContainPath(key, parents, false);
        key = new Path("/user/hive/warehouse/src/data.txt");
        this.verifyIsPathWithInSubTree(splitPath, key, false);
        this.verifyIsPathWithInSubTree(splitPathWithNoSchema, key, true);
        this.verifyIfParentsContainPath(key, parents, true);
        key = new Path("file:///user/hive/warehouse/src");
        this.verifyIsPathWithInSubTree(splitPath, key, true);
        this.verifyIsPathWithInSubTree(splitPathWithNoSchema, key, false);
        this.verifyIfParentsContainPath(key, parents, true);
        key = new Path("file:///user/hive/warehouse/src_2");
        this.verifyIsPathWithInSubTree(splitPath, key, false);
        this.verifyIsPathWithInSubTree(splitPathWithNoSchema, key, false);
        this.verifyIfParentsContainPath(key, parents, false);
        key = new Path("file:///user/hive/warehouse/src/data.txt");
        this.verifyIsPathWithInSubTree(splitPath, key, true);
        this.verifyIsPathWithInSubTree(splitPathWithNoSchema, key, false);
        this.verifyIfParentsContainPath(key, parents, true);
    }

    private void verifyIsPathWithInSubTree(Path splitPath, Path key, boolean expected) {
        boolean result = FileUtils.isPathWithinSubtree((Path)splitPath, (Path)key);
        Assert.assertEquals((String)("splitPath=" + splitPath + ", key=" + key), (Object)expected, (Object)result);
    }

    private void verifyIfParentsContainPath(Path key, Set<Path> parents, boolean expected) {
        boolean result = parents.contains(key);
        Assert.assertEquals((String)("key=" + key), (Object)expected, (Object)result);
    }

    @Test
    public void testCopyWithDistcp() throws IOException {
        Path copySrc = new Path("copySrc");
        Path copyDst = new Path("copyDst");
        HiveConf conf = new HiveConf(TestFileUtils.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)URI.create("hdfs:///"));
        ContentSummary mockContentSummary = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)mockContentSummary.getFileCount()).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)mockContentSummary.getLength()).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)mockFs.getContentSummary((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)mockContentSummary);
        HadoopShims shims = (HadoopShims)Mockito.mock(HadoopShims.class);
        Mockito.when((Object)shims.runDistCp(Collections.singletonList(copySrc), copyDst, (Configuration)conf)).thenReturn((Object)true);
        DataCopyStatistics copyStatistics = new DataCopyStatistics();
        Assert.assertTrue((boolean)FileUtils.copy((FileSystem)mockFs, (Path)copySrc, (FileSystem)mockFs, (Path)copyDst, (boolean)false, (boolean)false, (HiveConf)conf, (HadoopShims)shims, (DataCopyStatistics)copyStatistics));
        ((HadoopShims)Mockito.verify((Object)shims)).runDistCp(Collections.singletonList(copySrc), copyDst, (Configuration)conf);
    }

    @Test
    public void testCopyWithDistCpAs() throws IOException {
        Path copySrc = new Path("copySrc");
        Path copyDst = new Path("copyDst");
        HiveConf conf = new HiveConf(TestFileUtils.class);
        FileSystem fs = copySrc.getFileSystem((Configuration)conf);
        String doAsUser = conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)doAsUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
        HadoopShims shims = (HadoopShims)Mockito.mock(HadoopShims.class);
        Mockito.when((Object)shims.runDistCpAs(Collections.singletonList(copySrc), copyDst, (Configuration)conf, proxyUser)).thenReturn((Object)true);
        Mockito.when((Object)shims.runDistCp(Collections.singletonList(copySrc), copyDst, (Configuration)conf)).thenReturn((Object)false);
        Assert.assertTrue((boolean)FileUtils.distCp((FileSystem)fs, Collections.singletonList(copySrc), (Path)copyDst, (boolean)false, (UserGroupInformation)proxyUser, (HiveConf)conf, (HadoopShims)shims));
        ((HadoopShims)Mockito.verify((Object)shims)).runDistCpAs(Collections.singletonList(copySrc), copyDst, (Configuration)conf, proxyUser);
        Assert.assertFalse((boolean)FileUtils.distCp((FileSystem)fs, Collections.singletonList(copySrc), (Path)copyDst, (boolean)true, null, (HiveConf)conf, (HadoopShims)shims));
        ((HadoopShims)Mockito.verify((Object)shims)).runDistCp(Collections.singletonList(copySrc), copyDst, (Configuration)conf);
        try {
            FileUtils.distCp((FileSystem)fs, Collections.singletonList(copySrc), (Path)copyDst, (boolean)true, (UserGroupInformation)proxyUser, (HiveConf)conf, (HadoopShims)shims);
            Assert.assertTrue((boolean)"Should throw IOException as doAs is called with delete source set to true".equals(""));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().equalsIgnoreCase("Distcp is called with doAsUser and delete source set as true"));
        }
    }

    @Test
    public void testMakeRelative() {
        Path parentPath = new Path("/user/hive/database");
        Path childPath = new Path(parentPath, "table/dir/subdir");
        Path relativePath = FileUtils.makeRelative((Path)parentPath, (Path)childPath);
        Assert.assertEquals((Object)"table/dir/subdir", (Object)relativePath.toString());
        relativePath = FileUtils.makeRelative((Path)new Path("/"), (Path)childPath);
        Assert.assertEquals((Object)"user/hive/database/table/dir/subdir", (Object)relativePath.toString());
        childPath = new Path("/user/hive/database1/table/dir/subdir");
        relativePath = FileUtils.makeRelative((Path)parentPath, (Path)childPath);
        Assert.assertEquals((Object)childPath.toString(), (Object)relativePath.toString());
    }

    @Test
    public void testListStatusIterator() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)new HiveConf(), new MockFileSystem.MockFile("mock:/tmp/.staging", 500, new byte[0], new MockFileSystem.MockBlock[0]), new MockFileSystem.MockFile("mock:/tmp/_dummy", 500, new byte[0], new MockFileSystem.MockBlock[0]), new MockFileSystem.MockFile("mock:/tmp/dummy", 500, new byte[0], new MockFileSystem.MockBlock[0]));
        MockFileSystem.MockPath path = new MockFileSystem.MockPath(fs, "/tmp");
        RemoteIterator it = FileUtils.listStatusIterator((FileSystem)fs, (Path)path, (PathFilter)FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)this.assertExpectedFilePaths((RemoteIterator<? extends FileStatus>)it, Collections.singletonList("mock:/tmp/dummy")));
        RemoteIterator itr = FileUtils.listFiles((FileSystem)fs, (Path)path, (boolean)true, (PathFilter)FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)this.assertExpectedFilePaths((RemoteIterator<? extends FileStatus>)itr, Collections.singletonList("mock:/tmp/dummy")));
    }

    @Test
    public void testPathEscapeChars() {
        StringBuilder sb = new StringBuilder();
        FileUtils.charToEscape.stream().forEach(integer -> sb.append((char)integer));
        String path = sb.toString();
        Assert.assertEquals((Object)path, (Object)FileUtils.unescapePathName((String)FileUtils.escapePathName((String)path)));
    }

    @Test
    public void testOzoneSameBucket() {
        Assert.assertTrue((boolean)FileUtils.isSameOzoneBucket((Path)new Path("ofs://ozone1/vol1/bucket1/dir1"), (Path)new Path("ofs://ozone1/vol1/bucket1/dir2/file1")));
        Assert.assertTrue((boolean)FileUtils.isSameOzoneBucket((Path)new Path("ofs://ozone1/vol1/bucket1/"), (Path)new Path("ofs://ozone1/vol1/bucket1/dir2/file1")));
        Assert.assertFalse((boolean)FileUtils.isSameOzoneBucket((Path)new Path("ofs://ozone1/vol1/"), (Path)new Path("ofs://ozone1/vol1/bucket1/dir2/file1")));
        Assert.assertFalse((boolean)FileUtils.isSameOzoneBucket((Path)new Path("ofs://ozone1/vol1/bucket1/"), (Path)new Path("ofs://ozone1/vol2/bucket1/dir2/file1")));
        Assert.assertFalse((boolean)FileUtils.isSameOzoneBucket((Path)new Path("ofs://ozone1/vol1/bucket1/"), (Path)new Path("ofs://ozone1/vol1/bucket2/dir2/file1")));
    }

    private int assertExpectedFilePaths(RemoteIterator<? extends FileStatus> lfs, List<String> expectedPaths) throws Exception {
        int count = 0;
        while (lfs.hasNext()) {
            Assert.assertTrue((boolean)expectedPaths.contains(((FileStatus)lfs.next()).getPath().toString()));
            ++count;
        }
        return count;
    }

    @Test
    public void testResolveSymlinks() throws IOException {
        HiveConf conf = new HiveConf();
        java.nio.file.Path original = Files.createTempFile("", "", new FileAttribute[0]);
        java.nio.file.Path symlinkPath = Paths.get(original.toString() + ".symlink", new String[0]);
        java.nio.file.Path symlinkOfSymlinkPath = Paths.get(original.toString() + ".symlink.symlink", new String[0]);
        Files.createSymbolicLink(symlinkPath, original, new FileAttribute[0]);
        Files.createSymbolicLink(symlinkOfSymlinkPath, symlinkPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.isSymbolicLink(symlinkPath));
        Assert.assertTrue((boolean)Files.isSymbolicLink(symlinkOfSymlinkPath));
        Path originalPathResolved = FileUtils.resolveSymlinks((Path)new Path(symlinkPath.toUri()), (Configuration)conf);
        Assert.assertEquals((Object)original.toUri(), (Object)originalPathResolved.toUri());
        Path originalPathResolved2 = FileUtils.resolveSymlinks((Path)new Path(symlinkOfSymlinkPath.toUri()), (Configuration)conf);
        Assert.assertEquals((Object)original.toUri(), (Object)originalPathResolved2.toUri());
        Path originalPathWithoutScheme = Path.getPathWithoutSchemeAndAuthority((Path)new Path(original.toUri()));
        Path symlinkPathWithoutScheme = Path.getPathWithoutSchemeAndAuthority((Path)new Path(symlinkPath.toUri()));
        Assert.assertNull((Object)originalPathWithoutScheme.toUri().getScheme());
        Assert.assertNull((Object)symlinkPathWithoutScheme.toUri().getScheme());
        Path originalPathResolvedWithoutInputScheme = FileUtils.resolveSymlinks((Path)symlinkPathWithoutScheme, (Configuration)conf);
        Assert.assertNull((String)"Path without scheme should be resolved to another Path without scheme", (Object)originalPathResolvedWithoutInputScheme.toUri().getScheme());
        Assert.assertEquals((Object)originalPathResolvedWithoutInputScheme, (Object)originalPathWithoutScheme);
        Path originalPathResolvedFromOriginal = FileUtils.resolveSymlinks((Path)new Path(original.toUri()), (Configuration)conf);
        Assert.assertEquals((Object)original.toUri(), (Object)originalPathResolvedFromOriginal.toUri());
        Path nonexistentPath = new Path("./nonexistent-" + System.currentTimeMillis());
        Assert.assertEquals((Object)nonexistentPath.toUri(), (Object)FileUtils.resolveSymlinks((Path)nonexistentPath, (Configuration)conf).toUri());
        try {
            FileUtils.resolveSymlinks(null, (Configuration)conf);
            Assert.fail((String)"IllegalArgumentException should be thrown in case of null input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot resolve symlink for a null Path", (Object)e.getMessage());
        }
        Path hdfsPath = new Path("hdfs://localhost:0/user/hive/warehouse/src");
        Path resolvedHdfsPath = FileUtils.resolveSymlinks((Path)hdfsPath, (Configuration)conf);
        Assert.assertEquals((Object)hdfsPath.toUri(), (Object)resolvedHdfsPath.toUri());
    }
}

