/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;

public class Timestamp
implements Comparable<Timestamp> {
    private static final LocalDateTime EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private static final DateTimeFormatter PARSE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter PRINT_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();
    private LocalDateTime localDateTime;

    public Timestamp(LocalDateTime localDateTime) {
        this.localDateTime = localDateTime != null ? localDateTime : EPOCH;
    }

    public Timestamp() {
        this(EPOCH);
    }

    public Timestamp(Timestamp t) {
        this(t.localDateTime);
    }

    public void set(Timestamp t) {
        this.localDateTime = t != null ? t.localDateTime : EPOCH;
    }

    public String format(DateTimeFormatter formatter) {
        return this.localDateTime.format(formatter);
    }

    public String toString() {
        return this.localDateTime.format(PRINT_FORMATTER);
    }

    public int hashCode() {
        return this.localDateTime.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Timestamp) {
            return this.compareTo((Timestamp)other) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Timestamp o) {
        return this.localDateTime.compareTo(o.localDateTime);
    }

    public long toEpochSecond() {
        return this.localDateTime.toEpochSecond(ZoneOffset.UTC);
    }

    public void setTimeInSeconds(long epochSecond) {
        this.setTimeInSeconds(epochSecond, 0);
    }

    public void setTimeInSeconds(long epochSecond, int nanos) {
        this.localDateTime = LocalDateTime.ofEpochSecond(epochSecond, nanos, ZoneOffset.UTC);
    }

    public long toEpochMilli() {
        return this.localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public long toEpochMilli(ZoneId id) {
        return this.localDateTime.atZone(id).toInstant().toEpochMilli();
    }

    public void setTimeInMillis(long epochMilli) {
        this.localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC);
    }

    public void setTimeInMillis(long epochMilli, int nanos) {
        this.localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC).withNano(nanos);
    }

    public int getNanos() {
        return this.localDateTime.getNano();
    }

    public static Timestamp valueOf(String s) {
        LocalDateTime localDateTime;
        s = s.trim();
        try {
            localDateTime = LocalDateTime.parse(s, PARSE_FORMATTER);
        }
        catch (DateTimeException e) {
            try {
                localDateTime = LocalDateTime.parse(s);
            }
            catch (DateTimeException e2) {
                throw new IllegalArgumentException("Cannot create timestamp, parsing error " + s, e);
            }
        }
        return new Timestamp(localDateTime);
    }

    public Timestamp minusDays(long days) {
        this.localDateTime = this.localDateTime.minusDays(days);
        return this;
    }

    public static Timestamp getTimestampFromTime(String s) {
        return new Timestamp(LocalDateTime.of(LocalDate.now(), LocalTime.parse(s, DateTimeFormatter.ISO_LOCAL_TIME)));
    }

    public static Timestamp ofEpochSecond(long epochSecond) {
        return Timestamp.ofEpochSecond(epochSecond, 0);
    }

    public static Timestamp ofEpochSecond(long epochSecond, int nanos) {
        return new Timestamp(LocalDateTime.ofEpochSecond(epochSecond, nanos, ZoneOffset.UTC));
    }

    public static Timestamp ofEpochSecond(long epochSecond, long nanos, ZoneId zone) {
        return new Timestamp(LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nanos), zone));
    }

    public static Timestamp ofEpochMilli(long epochMilli) {
        return new Timestamp(LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC));
    }

    public static Timestamp ofEpochMilli(long epochMilli, ZoneId id) {
        return new Timestamp(LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), id));
    }

    public static Timestamp ofEpochMilli(long epochMilli, int nanos) {
        return new Timestamp(LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC).withNano(nanos));
    }

    public void setNanos(int nanos) {
        this.localDateTime = this.localDateTime.withNano(nanos);
    }

    public int getYear() {
        return this.localDateTime.getYear();
    }

    public int getMonth() {
        return this.localDateTime.getMonthValue();
    }

    public int getDay() {
        return this.localDateTime.getDayOfMonth();
    }

    public int getHours() {
        return this.localDateTime.getHour();
    }

    public int getMinutes() {
        return this.localDateTime.getMinute();
    }

    public int getSeconds() {
        return this.localDateTime.getSecond();
    }

    public int getDayOfWeek() {
        return this.localDateTime.getDayOfWeek().plus(1L).getValue();
    }

    public Object clone() {
        return new Timestamp(this.localDateTime);
    }

    public java.sql.Timestamp toSqlTimestamp() {
        java.sql.Timestamp ts = new java.sql.Timestamp(this.toEpochMilli());
        ts.setNanos(this.getNanos());
        return ts;
    }
}

