/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.schematool;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hive.beeline.schematool.HiveSchemaTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveSchemaTool {
    String scriptFile = System.getProperty("java.io.tmpdir") + File.separator + "someScript.sql";
    @Mock
    private HiveConf hiveConf;
    private MockedStatic<HiveSchemaHelper> hiveSchemaHelperMockedStatic;
    private HiveSchemaTool.HiveSchemaToolCommandBuilder builder;
    private String pasword = "reallySimplePassword";

    @Before
    public void setup() throws IOException {
        this.hiveSchemaHelperMockedStatic = Mockito.mockStatic(HiveSchemaHelper.class);
        this.hiveSchemaHelperMockedStatic.when(() -> HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)ArgumentMatchers.eq((Object)MetastoreConf.ConfVars.CONNECT_URL_KEY)), (Configuration)((Configuration)ArgumentMatchers.same((Object)this.hiveConf)))).thenReturn((Object)"someURL");
        this.hiveSchemaHelperMockedStatic.when(() -> HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)ArgumentMatchers.eq((Object)MetastoreConf.ConfVars.CONNECTION_DRIVER)), (Configuration)((Configuration)ArgumentMatchers.same((Object)this.hiveConf)))).thenReturn((Object)"someDriver");
        File file = new File(this.scriptFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        this.builder = new HiveSchemaTool.HiveSchemaToolCommandBuilder((Configuration)this.hiveConf, null, null, "testUser", this.pasword, this.scriptFile);
    }

    @After
    public void globalAssert() throws IOException {
        HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)ArgumentMatchers.eq((Object)MetastoreConf.ConfVars.CONNECT_URL_KEY)), (Configuration)((Configuration)ArgumentMatchers.same((Object)this.hiveConf)));
        HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)ArgumentMatchers.eq((Object)MetastoreConf.ConfVars.CONNECTION_DRIVER)), (Configuration)((Configuration)ArgumentMatchers.same((Object)this.hiveConf)));
        this.hiveSchemaHelperMockedStatic.close();
        new File(this.scriptFile).delete();
    }

    @Test
    public void shouldReturnStrippedPassword() throws IOException {
        Assert.assertFalse((boolean)this.builder.buildToLog().contains(this.pasword));
    }

    @Test
    public void shouldReturnActualPassword() throws IOException {
        String[] strings = this.builder.buildToRun();
        Assert.assertTrue((boolean)Arrays.asList(strings).contains(this.pasword));
    }
}

