/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.hs2connection;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hive.beeline.hs2connection.BeelineSiteParser;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBeelineSiteParser {
    @Test
    public void testConfigLocationPathInEtc() throws Exception {
        BeelineSiteParser testHS2ConfigManager = new BeelineSiteParser();
        Field locations = testHS2ConfigManager.getClass().getDeclaredField("locations");
        locations.setAccessible(true);
        List locs = (List)locations.get(testHS2ConfigManager);
        Assert.assertTrue((boolean)locs.contains(BeelineSiteParser.ETC_HIVE_CONF_LOCATION + File.separator + "beeline-site.xml"));
    }

    @Test
    public void testConnectionURLWithVarSubsitition() throws Exception {
        ArrayList<String> locations = new ArrayList<String>();
        String beelineSite = HiveTestUtils.getFileFromClasspath((String)"beeline-site.xml");
        locations.add(beelineSite);
        BeelineSiteParser beelineSiteParser = new BeelineSiteParser(locations);
        Properties properties = beelineSiteParser.getConnectionProperties();
        Assert.assertEquals((Object)"jdbc:hive2://zkhost1:2181,zkhost2:2181,zkhost3:2181/;serviceDiscoveryMode=zooKeeper;zooKeeperNamespace=hiveserver2?tez.queue.name=myqueue", (Object)properties.get("test"));
    }
}

