/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.JSONOutputFormat;
import org.apache.hive.beeline.Rows;
import org.apache.hive.beeline.TestBufferedRows;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestJSONOutputFormat {
    private final String[][] mockRowData = new String[][]{{"aaa", "1", "3.14", "true", "", "SGVsbG8sIFdvcmxkIQ"}, {"bbb", "2", "2.718", "false", "Null", "RWFzdGVyCgllZ2cu"}};
    public ResultSet mockResultSet;
    public TestBufferedRows.MockRow mockRow;

    @Test
    public final void testPrint() throws SQLException {
        BeeLine mockBeeline = (BeeLine)Mockito.spy(BeeLine.class);
        ArgumentCaptor captureOutput = ArgumentCaptor.forClass(String.class);
        ((BeeLine)Mockito.doNothing().when((Object)mockBeeline)).output((String)captureOutput.capture());
        BufferedRows bfRows = new BufferedRows(mockBeeline, this.mockResultSet);
        JSONOutputFormat instance = new JSONOutputFormat(mockBeeline);
        instance.print((Rows)bfRows);
        String expResult = "{\"resultset\":[{\"String\":\"aaa\",\"Int\":1,\"Decimal\":3.14,\"Bool\":true,\"Null\":null,\"Binary\":\"SGVsbG8sIFdvcmxkIQ\"},{\"String\":\"bbb\",\"Int\":2,\"Decimal\":2.718,\"Bool\":false,\"Null\":null,\"Binary\":\"RWFzdGVyCgllZ2cu\"}]}";
        Assert.assertEquals((Object)expResult, (Object)captureOutput.getValue());
    }

    @Before
    public void setupMockData() throws SQLException {
        this.mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockResultSetMetaData.getColumnCount()).thenReturn((Object)6);
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(1)).thenReturn((Object)"String");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(2)).thenReturn((Object)"Int");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(3)).thenReturn((Object)"Decimal");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(4)).thenReturn((Object)"Bool");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(5)).thenReturn((Object)"Null");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(6)).thenReturn((Object)"Binary");
        Mockito.when((Object)mockResultSetMetaData.getColumnType(1)).thenReturn((Object)12);
        Mockito.when((Object)mockResultSetMetaData.getColumnType(2)).thenReturn((Object)4);
        Mockito.when((Object)mockResultSetMetaData.getColumnType(3)).thenReturn((Object)3);
        Mockito.when((Object)mockResultSetMetaData.getColumnType(4)).thenReturn((Object)16);
        Mockito.when((Object)mockResultSetMetaData.getColumnType(5)).thenReturn((Object)0);
        Mockito.when((Object)mockResultSetMetaData.getColumnType(6)).thenReturn((Object)-2);
        Mockito.when((Object)this.mockResultSet.getMetaData()).thenReturn((Object)mockResultSetMetaData);
        this.mockRow = new TestBufferedRows.MockRow();
        Mockito.when((Object)this.mockResultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
            private int mockRowDataIndex = 0;

            public Boolean answer(InvocationOnMock invocation) {
                if (this.mockRowDataIndex < TestJSONOutputFormat.this.mockRowData.length) {
                    TestJSONOutputFormat.this.mockRow.setCurrentRowData(TestJSONOutputFormat.this.mockRowData[this.mockRowDataIndex]);
                    ++this.mockRowDataIndex;
                    return true;
                }
                return false;
            }
        });
        Mockito.when((Object)this.mockResultSet.getObject(ArgumentMatchers.anyInt())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                int index = (Integer)args[0];
                return TestJSONOutputFormat.this.mockRow.getColumn(index);
            }
        });
        Mockito.when((Object)this.mockResultSet.getString(ArgumentMatchers.anyInt())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                int index = (Integer)args[0];
                return TestJSONOutputFormat.this.mockRow.getColumn(index);
            }
        });
    }
}

