/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.Commands;
import org.apache.hive.common.util.HiveStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCommands {
    @Test
    public void testLinesEndingWithComments() {
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables;"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; --comments"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; -------comments"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; -------comments;one;two;three;;;;"));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"show-- tables; -------comments"));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"show --tables; -------comments"));
        Assert.assertEquals((Object)"s", (Object)HiveStringUtils.removeComments((String)"s--how --tables; -------comments"));
        Assert.assertEquals((Object)"", (Object)HiveStringUtils.removeComments((String)"-- show tables; -------comments"));
        Assert.assertEquals((Object)"\"show tables\"", (Object)HiveStringUtils.removeComments((String)"\"show tables\" --comments"));
        Assert.assertEquals((Object)"\"show --comments tables\"", (Object)HiveStringUtils.removeComments((String)"\"show --comments tables\" --comments"));
        Assert.assertEquals((Object)"\"'show --comments' tables\"", (Object)HiveStringUtils.removeComments((String)"\"'show --comments' tables\" --comments"));
        Assert.assertEquals((Object)"'show --comments tables'", (Object)HiveStringUtils.removeComments((String)"'show --comments tables' --comments"));
        Assert.assertEquals((Object)"'\"show --comments tables\"'", (Object)HiveStringUtils.removeComments((String)"'\"show --comments tables\"' --comments"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"--comments\nshow tables;"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"--comments\nshow tables; --comments"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"--comments\nshow tables; -------comments"));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"--comments\nshow tables; -------comments;one;two;three;;;;"));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"--comments\nshow-- tables; -------comments"));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"--comments\nshow --tables; -------comments"));
        Assert.assertEquals((Object)"s", (Object)HiveStringUtils.removeComments((String)"--comments\ns--how --tables; -------comments"));
        Assert.assertEquals((Object)"", (Object)HiveStringUtils.removeComments((String)"--comments\n-- show tables; -------comments"));
        Assert.assertEquals((Object)"\"show tables\"", (Object)HiveStringUtils.removeComments((String)"--comments\n\"show tables\" --comments"));
        Assert.assertEquals((Object)"\"show --comments tables\"", (Object)HiveStringUtils.removeComments((String)"--comments\n\"show --comments tables\" --comments"));
        Assert.assertEquals((Object)"\"'show --comments' tables\"", (Object)HiveStringUtils.removeComments((String)"--comments\n\"'show --comments' tables\" --comments"));
        Assert.assertEquals((Object)"'show --comments tables'", (Object)HiveStringUtils.removeComments((String)"--comments\n'show --comments tables' --comments"));
        Assert.assertEquals((Object)"'\"show --comments tables\"'", (Object)HiveStringUtils.removeComments((String)"--comments\n'\"show --comments tables\"' --comments"));
        Assert.assertEquals((Object)"select col1, \n       year,\n       month,\n       date\n  from test_table\n where\n   username = 'foo';", (Object)HiveStringUtils.removeComments((String)"select col1, -- comments\n       --partitioned year column\n       year,\n       --partitioned month column\n       month,\n       --partitioned date column\n       date\n  from test_table\n where\n   --for a particular user\n   username = 'foo';"));
    }

    @Test
    public void testBeelineCommands() throws IOException {
        System.setProperty("beeline.system.exit", "true");
        BeeLine.mainWithInputRedirection((String[])new String[]{"-u", "jdbc:hive2://", "-e", "select 3"}, null);
        BeeLine.mainWithInputRedirection((String[])new String[]{"-u", "jdbc:hive2://", "-e", "create table t1(x int); show tables"}, null);
    }

    @Test
    public void testGetCmdList() throws Exception {
        BeeLine beeline = new BeeLine();
        Commands commands = new Commands(beeline);
        try {
            Assert.assertEquals(Arrays.asList(""), (Object)commands.getCmdList("", false));
            Assert.assertEquals(Arrays.asList(""), (Object)commands.getCmdList(";", false));
            Assert.assertEquals(Arrays.asList(" "), (Object)commands.getCmdList(" ;", false));
            Assert.assertEquals(Arrays.asList("", " "), (Object)commands.getCmdList("; ", false));
            Assert.assertEquals(Arrays.asList(" ", " "), (Object)commands.getCmdList(" ; ", false));
            Assert.assertEquals(Arrays.asList(" ; "), (Object)commands.getCmdList(" \\; ", false));
            Assert.assertEquals(Arrays.asList("select 1"), (Object)commands.getCmdList("select 1;", false));
            Assert.assertEquals(Arrays.asList("select 1"), (Object)commands.getCmdList("select 1", false));
            Assert.assertEquals(Arrays.asList(" \n select \n 1 \n "), (Object)commands.getCmdList(" \n select \n 1 \n ;", false));
            Assert.assertEquals(Arrays.asList(" \n select 1 \n ", " \n "), (Object)commands.getCmdList(" \n select 1 \n ; \n ", false));
            Assert.assertEquals(Arrays.asList("select 1", "select 2"), (Object)commands.getCmdList("select 1;select 2;", false));
            Assert.assertEquals(Arrays.asList("select 1", "select 2"), (Object)commands.getCmdList("select 1;select 2", false));
            Assert.assertEquals(Arrays.asList(" \n select \t 1", "\tselect\n2\r", " select\n3", "   "), (Object)commands.getCmdList(" \n select \t 1;\tselect\n2\r; select\n3;   ", false));
            Assert.assertEquals(Arrays.asList("select 'foo'"), (Object)commands.getCmdList("select 'foo';", false));
            Assert.assertEquals(Arrays.asList("select \"foo\""), (Object)commands.getCmdList("select \"foo\";", false));
            Assert.assertEquals(Arrays.asList("select 'foo'", " select 2"), (Object)commands.getCmdList("select 'foo'; select 2;", false));
            Assert.assertEquals(Arrays.asList("select \"foo\"", " select 2"), (Object)commands.getCmdList("select \"foo\"; select 2", false));
            Assert.assertEquals(Arrays.asList("select ''", " select \"\""), (Object)commands.getCmdList("select ''; select \"\"", false));
            Assert.assertEquals(Arrays.asList("select 'foo\"bar'"), (Object)commands.getCmdList("select 'foo\"bar';", false));
            Assert.assertEquals(Arrays.asList("select \"foo'bar\""), (Object)commands.getCmdList("select \"foo'bar\";", false));
            Assert.assertEquals(Arrays.asList("select 'foo\"bar'", " select 'foo\"bar'"), (Object)commands.getCmdList("select 'foo\"bar'; select 'foo\"bar';", false));
            Assert.assertEquals(Arrays.asList("select \"foo'bar\"", " select \"foo'bar\""), (Object)commands.getCmdList("select \"foo'bar\"; select \"foo'bar\"", false));
            Assert.assertEquals(Arrays.asList("select '\"' ", " select \"'\" "), (Object)commands.getCmdList("select '\"' ; select \"'\" ;", false));
            Assert.assertEquals(Arrays.asList("select 'foo;bar'"), (Object)commands.getCmdList("select 'foo;bar';", false));
            Assert.assertEquals(Arrays.asList("select \"foo;bar\""), (Object)commands.getCmdList("select \"foo;bar\";", false));
            Assert.assertEquals(Arrays.asList("select '\"foobar'", " select 'foobar\"'"), (Object)commands.getCmdList("select '\"foobar'; select 'foobar\"';", false));
            Assert.assertEquals(Arrays.asList("select \"'foobar'; select 'foobar'\""), (Object)commands.getCmdList("select \"'foobar'; select 'foobar'\";", false));
            Assert.assertEquals(Arrays.asList("select 'multi\nline\nstring'", " select 'allowed'"), (Object)commands.getCmdList("select 'multi\nline\nstring'; select 'allowed';", false));
            Assert.assertEquals(Arrays.asList("select \"multi\nline\nstring\"", " select \"allowed\""), (Object)commands.getCmdList("select \"multi\nline\nstring\"; select \"allowed\";", false));
            Assert.assertEquals(Arrays.asList("select ';\nselect 1;\n'", " select 'sql within string'"), (Object)commands.getCmdList("select ';\nselect 1;\n'; select 'sql within string';", false));
            Assert.assertEquals(Arrays.asList("select 'fo\\'o'"), (Object)commands.getCmdList("select 'fo\\'o';", false));
            Assert.assertEquals(Arrays.asList("select \"fo\\\"o\""), (Object)commands.getCmdList("select \"fo\\\"o\";", false));
            Assert.assertEquals(Arrays.asList("select 'fo\\\"o'"), (Object)commands.getCmdList("select 'fo\\\"o';", false));
            Assert.assertEquals(Arrays.asList("select \"fo\\'o\""), (Object)commands.getCmdList("select \"fo\\'o\";", false));
            Assert.assertEquals(Arrays.asList("select 'foo\\\\'", " select \"bar\\\\\""), (Object)commands.getCmdList("select 'foo\\\\'; select \"bar\\\\\";", false));
            Assert.assertEquals(Arrays.asList("select 1", " -- comment\nselect 2", " -- comment\n"), (Object)commands.getCmdList("select 1; -- comment\nselect 2; -- comment\n", false));
            Assert.assertEquals(Arrays.asList("select -- comment\n1", " select -- comment\n2"), (Object)commands.getCmdList("select -- comment\n1; select -- comment\n2;", false));
            Assert.assertEquals(Arrays.asList("select -- comment 1; select -- comment 2;"), (Object)commands.getCmdList("select -- comment 1; select -- comment 2;", false));
            Assert.assertEquals(Arrays.asList("select -- comment\\\n1", " select -- comment\\\n2"), (Object)commands.getCmdList("select -- comment\\\n1; select -- comment\\\n2;", false));
            Assert.assertEquals(Arrays.asList("select 1 -- invalid;\nselect 2"), (Object)commands.getCmdList("select 1 -- invalid;\nselect 2;", false));
            Assert.assertEquals(Arrays.asList("select 1 -- valid\n", "select 2"), (Object)commands.getCmdList("select 1 -- valid\n;select 2;", false));
            Assert.assertEquals(Arrays.asList("select 1 -- v'lid\n", "select 2", "select 3"), (Object)commands.getCmdList("select 1 -- v'lid\n;select 2;select 3;", false));
            Assert.assertEquals(Arrays.asList("select 1 -- v\"lid\n", "select 2", "select 3"), (Object)commands.getCmdList("select 1 -- v\"lid\n;select 2;select 3;", false));
            Assert.assertEquals(Arrays.asList("", "select 1 -- '\n", "select \"'\"", "select 3 -- \"\n", "?"), (Object)commands.getCmdList(";select 1 -- '\n;select \"'\";select 3 -- \"\n;?", false));
            Assert.assertEquals(Arrays.asList("", "select 1 -- ';select \"'\"\n", "select 3 -- \"\n", "?"), (Object)commands.getCmdList(";select 1 -- ';select \"'\"\n;select 3 -- \"\n;?", false));
            Assert.assertEquals(Arrays.asList("select 1", " select /* */ 2", " select /* */ 3"), (Object)commands.getCmdList("select 1; select /* */ 2; select /* */ 3;", false));
            Assert.assertEquals(Arrays.asList("select 1", " select /* ; */ 2", " select /* ; */ 3"), (Object)commands.getCmdList("select 1; select /* ; */ 2; select /* ; */ 3;", false));
            Assert.assertEquals(Arrays.asList("select 1 /* c1; */", " /**/ select 2 /*/ c3; /*/", " select 3", " /* c4 */"), (Object)commands.getCmdList("select 1 /* c1; */; /**/ select 2 /*/ c3; /*/; select 3; /* c4 */", false));
            Assert.assertEquals(Arrays.asList("select 1 --lc /* fake bc\n", "select 2 --lc */\n"), (Object)commands.getCmdList("select 1 --lc /* fake bc\n;select 2 --lc */\n;", false));
            Assert.assertEquals(Arrays.asList("select 1 /*bc -- fake lc\n;select 2 --lc */\n"), (Object)commands.getCmdList("select 1 /*bc -- fake lc\n;select 2 --lc */\n;", false));
            Assert.assertEquals(Arrays.asList("select 1 /* v'lid */", "select 2", "select 3"), (Object)commands.getCmdList("select 1 /* v'lid */;select 2;select 3;", false));
            Assert.assertEquals(Arrays.asList("select 1 /* v\"lid */", "select 2", "select 3"), (Object)commands.getCmdList("select 1 /* v\"lid */;select 2;select 3;", false));
            Assert.assertEquals(Arrays.asList("", "select 1 /* ' */", "select \"'\"", "select 3 /* \" */", "?"), (Object)commands.getCmdList(";select 1 /* ' */;select \"'\";select 3 /* \" */;?", false));
            Assert.assertEquals(Arrays.asList("", "select 1 /*/ ' ;select \"'\" /*/", "select 3 /* \" */", "?"), (Object)commands.getCmdList(";select 1 /*/ ' ;select \"'\" /*/;select 3 /* \" */;?", false));
            Assert.assertEquals(Arrays.asList("select 1", " -- ;\\';\\\";--;  ;/*;*/; '; ';\";\";"), (Object)commands.getCmdList("select 1; -- ;\\';\\\";--;  ;/*;*/; '; ';\";\";", false));
            Assert.assertEquals(Arrays.asList("select 1", " /* ;\\';\\\";--;\n;/*;  ; '; ';\";\";"), (Object)commands.getCmdList("select 1; /* ;\\';\\\";--;\n;/*;  ; '; ';\";\";", false));
            Assert.assertEquals(Arrays.asList("select 1", " '  ;\\';\\\";--;\n;/*;*/;  ;  ;\";\";"), (Object)commands.getCmdList("select 1; '  ;\\';\\\";--;\n;/*;*/;  ;  ;\";\";", false));
            Assert.assertEquals(Arrays.asList("select 1", " \" ;\\';\\\";--;\n;/*;*/; '; ';  ;  ;"), (Object)commands.getCmdList("select 1; \" ;\\';\\\";--;\n;/*;*/; '; ';  ;  ;", false));
        }
        finally {
            beeline.close();
        }
    }
}

