/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Test;

public class TestBeeLineExceptionHandling {
    @Test
    public void testHandleSQLExceptionLog() throws Exception {
        this.checkException(2, "hs2-connection-already-open");
        this.checkException(4, "hs2-unexpected-end-of-file");
        this.checkException(1, "hs2-could-not-open-connection");
        this.checkException(3, "hs2-connection-timed-out");
        this.checkException(0, "hs2-unknown-connection-problem");
        this.checkException(-1, "hs2-unexpected-error");
    }

    private void checkException(int type, String loc) {
        TestBeeline testBeeLine = new TestBeeline(loc);
        TTransportException tTransportException = new TTransportException(type);
        SQLException sqlException = new SQLException((Throwable)tTransportException);
        testBeeLine.handleSQLException(sqlException);
    }

    public class TestBeeline
    extends BeeLine {
        private String expectedLoc;
        private int logCount;

        public TestBeeline(String expectedLoc) {
            this.expectedLoc = expectedLoc;
            this.logCount = 0;
        }

        boolean error(String log) {
            if (this.logCount == 0) {
                Assert.assertEquals((Object)this.loc(this.expectedLoc), (Object)log);
            } else {
                Assert.assertEquals((Object)"Error: org.apache.thrift.transport.TTransportException (state=,code=0)", (Object)log);
            }
            ++this.logCount;
            return false;
        }
    }
}

