/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.DefaultAccumuloRowIdFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultAccumuloRowIdFactory {
    @Test
    public void testCorrectPrimitiveInspectors() throws SerDeException {
        AccumuloSerDe accumuloSerDe = new AccumuloSerDe();
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq");
        properties.setProperty("columns", "row,col");
        properties.setProperty("columns.types", "string,int");
        accumuloSerDe.initialize(conf, properties, null);
        AccumuloRowIdFactory factory = accumuloSerDe.getParams().getRowIdFactory();
        List columnTypes = accumuloSerDe.getParams().getHiveColumnTypes();
        ColumnMapper mapper = accumuloSerDe.getParams().getColumnMapper();
        LazySerDeParameters serDeParams = accumuloSerDe.getParams().getSerDeParameters();
        ArrayList OIs = accumuloSerDe.getColumnObjectInspectors(columnTypes, serDeParams, mapper.getColumnMappings(), factory);
        Assert.assertEquals((long)2L, (long)OIs.size());
        Assert.assertEquals(LazyStringObjectInspector.class, ((ObjectInspector)OIs.get(0)).getClass());
        Assert.assertEquals(LazyIntObjectInspector.class, ((ObjectInspector)OIs.get(1)).getClass());
    }

    @Test
    public void testCorrectComplexInspectors() throws SerDeException {
        AccumuloSerDe accumuloSerDe = new AccumuloSerDe();
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq");
        properties.setProperty("columns", "row,col");
        properties.setProperty("columns.types", "struct<col1:int,col2:int>,map<string,string>");
        accumuloSerDe.initialize(conf, properties, null);
        AccumuloRowIdFactory factory = accumuloSerDe.getParams().getRowIdFactory();
        List columnTypes = accumuloSerDe.getParams().getHiveColumnTypes();
        ColumnMapper mapper = accumuloSerDe.getParams().getColumnMapper();
        LazySerDeParameters serDeParams = accumuloSerDe.getParams().getSerDeParameters();
        ArrayList OIs = accumuloSerDe.getColumnObjectInspectors(columnTypes, serDeParams, mapper.getColumnMappings(), factory);
        Assert.assertEquals((long)2L, (long)OIs.size());
        Assert.assertEquals(LazySimpleStructObjectInspector.class, ((ObjectInspector)OIs.get(0)).getClass());
        Assert.assertEquals(LazyMapObjectInspector.class, ((ObjectInspector)OIs.get(1)).getClass());
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)OIs.get(0);
        Assert.assertEquals((long)2L, (long)structOI.getSeparator());
        LazyMapObjectInspector mapOI = (LazyMapObjectInspector)OIs.get(1);
        Assert.assertEquals((long)2L, (long)mapOI.getItemSeparator());
        Assert.assertEquals((long)3L, (long)mapOI.getKeyValueSeparator());
    }

    @Test
    public void testBinaryStringRowId() throws SerDeException {
        AccumuloSerDe accumuloSerDe = new AccumuloSerDe();
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq");
        properties.setProperty("columns", "row,col");
        properties.setProperty("columns.types", "string,string");
        properties.setProperty("accumulo.default.storage", ColumnEncoding.BINARY.getName());
        accumuloSerDe.initialize(conf, properties, null);
        DefaultAccumuloRowIdFactory rowIdFactory = new DefaultAccumuloRowIdFactory();
        rowIdFactory.init(accumuloSerDe.getParams(), properties);
        LazyStringObjectInspector oi = LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector((boolean)false, (byte)92);
        LazyObjectBase lazyObj = rowIdFactory.createRowId((ObjectInspector)oi);
        Assert.assertNotNull((Object)lazyObj);
        Assert.assertTrue((boolean)LazyString.class.isAssignableFrom(lazyObj.getClass()));
    }
}

