/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.LazyAccumuloRow;
import org.apache.hadoop.hive.accumulo.columns.InvalidColumnMappingException;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowSerializer;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.accumulo.serde.DelimitedAccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.accumulo.serde.TooManyHiveColumnsException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAccumuloSerDe {
    protected AccumuloSerDe serde;

    @Before
    public void setup() {
        this.serde = new AccumuloSerDe();
    }

    @Test(expected=TooManyHiveColumnsException.class)
    public void moreHiveColumnsThanAccumuloColumns() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:f3");
        properties.setProperty("columns", "row,field1,field2,field3,field4");
        properties.setProperty("columns.types", "string,string,string,string,string");
        this.serde.initialize(conf, properties, null);
        this.serde.deserialize((Writable)new Text("fail"));
    }

    @Test(expected=TooManyAccumuloColumnsException.class)
    public void moreAccumuloColumnsThanHiveColumns() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:f1,cf:f2,cf:f3");
        properties.setProperty("columns", "row,field1,field2");
        properties.setProperty("columns.types", "string,string,string");
        this.serde.initialize(conf, properties, null);
        this.serde.deserialize((Writable)new Text("fail"));
    }

    @Test(expected=NullPointerException.class)
    public void emptyConfiguration() throws SerDeException {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        this.serde.initialize(conf, properties, null);
    }

    @Test
    public void simpleColumnMapping() throws SerDeException {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:f1,cf:f2,cf:f3");
        properties.setProperty("columns", "row,field1,field2,field3");
        this.serde.initialize(conf, properties, null);
        Assert.assertNotNull((Object)this.serde.getCachedRow());
    }

    @Test
    public void withRowID() throws SerDeException {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", "cf:f1,:rowID,cf:f2,cf:f3");
        properties.setProperty("columns", "field1,field2,field3,field4");
        this.serde.initialize(conf, properties, null);
        Assert.assertNotNull((Object)this.serde.getCachedRow());
    }

    @Test(expected=InvalidColumnMappingException.class)
    public void invalidColMapping() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", "cf,cf:f2,cf:f3");
        properties.setProperty("columns", "field2,field3,field4");
        this.serde.initialize(conf, properties, null);
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.setRowId("r1");
        Object obj = this.serde.deserialize((Writable)row);
        Assert.assertTrue((boolean)(obj instanceof LazyAccumuloRow));
        LazyAccumuloRow lazyRow = (LazyAccumuloRow)obj;
        lazyRow.getField(0);
    }

    @Test(expected=TooManyAccumuloColumnsException.class)
    public void deserializeWithTooFewHiveColumns() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:f1,cf:f2,cf:f3");
        properties.setProperty("columns", "row,col1,col2");
        properties.setProperty("columns.types", "string,string,string");
        this.serde.initialize(conf, properties, null);
        this.serde.deserialize((Writable)new Text("fail"));
    }

    @Test
    public void testArraySerialization() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:vals");
        properties.setProperty("columns", "row,values");
        properties.setProperty("columns.types", "string,array<string>");
        properties.setProperty("collection.delim", ":");
        char separator = ':';
        this.serde.initialize(conf, properties, null);
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.setRowId("r1");
        row.add("cf", "vals", ("value1" + separator + "value2" + separator + "value3").getBytes());
        Object obj = this.serde.deserialize((Writable)row);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof LazyAccumuloRow));
        LazyAccumuloRow lazyRow = (LazyAccumuloRow)obj;
        Object field0 = lazyRow.getField(0);
        Assert.assertNotNull((Object)field0);
        Assert.assertTrue((boolean)(field0 instanceof LazyString));
        Assert.assertEquals((Object)row.getRowId(), (Object)((Text)((LazyString)field0).getWritableObject()).toString());
        Object field1 = lazyRow.getField(1);
        Assert.assertNotNull((Object)field1);
        Assert.assertTrue((boolean)(field1 instanceof LazyArray));
        LazyArray array = (LazyArray)field1;
        List values = array.getList();
        Assert.assertEquals((long)3L, (long)values.size());
        for (int i = 0; i < 3; ++i) {
            Object o = values.get(i);
            Assert.assertNotNull(o);
            Assert.assertTrue((boolean)(o instanceof LazyString));
            Assert.assertEquals((Object)("value" + (i + 1)), (Object)((Text)((LazyString)o).getWritableObject()).toString());
        }
    }

    @Test
    public void testMapSerialization() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:vals");
        properties.setProperty("columns", "row,values");
        properties.setProperty("columns.types", "string,map<string,string>");
        properties.setProperty("collection.delim", ":");
        properties.setProperty("mapkey.delim", "=");
        char collectionSeparator = ':';
        char kvSeparator = '=';
        this.serde.initialize(conf, properties, null);
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.setRowId("r1");
        row.add("cf", "vals", ("k1" + kvSeparator + "v1" + collectionSeparator + "k2" + kvSeparator + "v2" + collectionSeparator + "k3" + kvSeparator + "v3").getBytes());
        Object obj = this.serde.deserialize((Writable)row);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof LazyAccumuloRow));
        LazyAccumuloRow lazyRow = (LazyAccumuloRow)obj;
        Object field0 = lazyRow.getField(0);
        Assert.assertNotNull((Object)field0);
        Assert.assertTrue((boolean)(field0 instanceof LazyString));
        Assert.assertEquals((Object)row.getRowId(), (Object)((Text)((LazyString)field0).getWritableObject()).toString());
        Object field1 = lazyRow.getField(1);
        Assert.assertNotNull((Object)field1);
        Assert.assertTrue((boolean)(field1 instanceof LazyMap));
        LazyMap map = (LazyMap)field1;
        Map untypedMap = map.getMap();
        Assert.assertEquals((long)3L, (long)map.getMapSize());
        HashSet<String> expectedKeys = new HashSet<String>();
        expectedKeys.add("k1");
        expectedKeys.add("k2");
        expectedKeys.add("k3");
        for (Map.Entry entry : untypedMap.entrySet()) {
            Assert.assertNotNull(entry.getKey());
            Assert.assertTrue((boolean)(entry.getKey() instanceof LazyString));
            LazyString key = (LazyString)entry.getKey();
            Assert.assertNotNull(entry.getValue());
            Assert.assertTrue((boolean)(entry.getValue() instanceof LazyString));
            LazyString value = (LazyString)entry.getValue();
            String strKey = ((Text)key.getWritableObject()).toString();
            String strValue = ((Text)value.getWritableObject()).toString();
            Assert.assertTrue((boolean)expectedKeys.remove(strKey));
            Assert.assertEquals((long)2L, (long)strValue.length());
            Assert.assertTrue((boolean)strValue.startsWith("v"));
            Assert.assertTrue((boolean)strValue.endsWith(Character.toString(strKey.charAt(1))));
        }
        Assert.assertTrue((String)("Did not find expected keys: " + expectedKeys), (boolean)expectedKeys.isEmpty());
    }

    @Test
    public void deserialization() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:f1,cf:f2,cf:f3");
        properties.setProperty("columns", "blah,field2,field3,field4");
        this.serde.initialize(conf, properties, null);
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.setRowId("r1");
        row.add("cf", "f1", "v1".getBytes());
        row.add("cf", "f2", "v2".getBytes());
        Object obj = this.serde.deserialize((Writable)row);
        Assert.assertTrue((boolean)(obj instanceof LazyAccumuloRow));
        LazyAccumuloRow lazyRow = (LazyAccumuloRow)obj;
        Object field0 = lazyRow.getField(0);
        Assert.assertNotNull((Object)field0);
        Assert.assertTrue((boolean)(field0 instanceof LazyString));
        Assert.assertEquals((Object)field0.toString(), (Object)"r1");
        Object field1 = lazyRow.getField(1);
        Assert.assertNotNull((Object)field1);
        Assert.assertTrue((String)("Expected instance of LazyString but was " + field1.getClass()), (boolean)(field1 instanceof LazyString));
        Assert.assertEquals((Object)field1.toString(), (Object)"v1");
        Object field2 = lazyRow.getField(2);
        Assert.assertNotNull((Object)field2);
        Assert.assertTrue((boolean)(field2 instanceof LazyString));
        Assert.assertEquals((Object)field2.toString(), (Object)"v2");
    }

    @Test
    public void testNoVisibilitySetsEmptyVisibility() throws SerDeException {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", "cf:f1,:rowID");
        properties.setProperty("columns", "field1,field2");
        this.serde.initialize(conf, properties, null);
        AccumuloRowSerializer serializer = this.serde.getSerializer();
        Assert.assertEquals((Object)new ColumnVisibility(), (Object)serializer.getVisibility());
    }

    @Test
    public void testColumnVisibilityForSerializer() throws SerDeException {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", "cf:f1,:rowID");
        properties.setProperty("columns", "field1,field2");
        properties.setProperty("accumulo.visibility.label", "foobar");
        this.serde.initialize(conf, properties, null);
        AccumuloRowSerializer serializer = this.serde.getSerializer();
        Assert.assertEquals((Object)new ColumnVisibility("foobar"), (Object)serializer.getVisibility());
    }

    @Test
    public void testCompositeKeyDeserialization() throws Exception {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowID,cf:f1");
        properties.setProperty("columns", "row,field1");
        properties.setProperty("columns.types", "struct<col1:string,col2:string,col3:string>,string");
        properties.setProperty("accumulo.composite.delimiter", "_");
        properties.setProperty("accumulo.composite.rowid.factory", DelimitedAccumuloRowIdFactory.class.getName());
        this.serde.initialize(conf, properties, null);
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.setRowId("p1_p2_p3");
        row.add("cf", "f1", "v1".getBytes());
        Object obj = this.serde.deserialize((Writable)row);
        Assert.assertTrue((boolean)(obj instanceof LazyAccumuloRow));
        LazyAccumuloRow lazyRow = (LazyAccumuloRow)obj;
        Object field0 = lazyRow.getField(0);
        Assert.assertNotNull((Object)field0);
        Assert.assertTrue((boolean)(field0 instanceof LazyStruct));
        LazyStruct struct = (LazyStruct)field0;
        List fields = struct.getFieldsAsList();
        Assert.assertEquals((long)3L, (long)fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Assert.assertEquals(LazyString.class, fields.get(i).getClass());
            Assert.assertEquals((Object)("p" + (i + 1)), (Object)fields.get(i).toString());
        }
        Object field1 = lazyRow.getField(1);
        Assert.assertNotNull((Object)field1);
        Assert.assertTrue((String)("Expected instance of LazyString but was " + field1.getClass()), (boolean)(field1 instanceof LazyString));
        Assert.assertEquals((Object)field1.toString(), (Object)"v1");
    }

    @Test
    public void testStructOfMapSerialization() throws IOException, SerDeException {
        List<String> columns = Arrays.asList("row", "col");
        List<String> structColNames = Arrays.asList("map1", "map2");
        TypeInfo mapTypeInfo = TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.getStructTypeInfo(structColNames, Arrays.asList(mapTypeInfo, mapTypeInfo)), TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowid,cf:cq");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(columns));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        byte[] seps = serDeParams.getSeparators();
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazyStringObjectInspector stringOI = (LazyStringObjectInspector)LazyFactory.createLazyObjectInspector((TypeInfo)stringTypeInfo, (byte[])new byte[]{0}, (int)0, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyMapObjectInspector mapOI = LazyObjectInspectorFactory.getLazySimpleMapObjectInspector((ObjectInspector)stringOI, (ObjectInspector)stringOI, (byte)seps[3], (byte)seps[4], (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazySimpleStructObjectInspector rowStructOI = LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structColNames, Arrays.asList(mapOI, mapOI), (byte)seps[2], (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazySimpleStructObjectInspector structOI = LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(columns, Arrays.asList(rowStructOI, stringOI), (byte)seps[1], (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), new ColumnVisibility(), accumuloSerDeParams.getRowIdFactory());
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map1.put("key10", "value10");
        map1.put("key11", "value11");
        map2.put("key20", "value20");
        map2.put("key21", "value21");
        ByteArrayRef byteRef = new ByteArrayRef();
        String accumuloRow = "key10\u0005value10\u0004key11\u0005value11\u0003key20\u0005value20\u0004key21\u0005value21";
        LazyStruct entireStruct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        byteRef.setData(((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002foo"}, (String)accumuloRow))).getBytes());
        entireStruct.init(byteRef, 0, byteRef.getData().length);
        Mutation m = serializer.serialize((Object)entireStruct, (ObjectInspector)structOI);
        Assert.assertArrayEquals((byte[])accumuloRow.getBytes(), (byte[])m.getRow());
        Assert.assertEquals((long)1L, (long)m.getUpdates().size());
        ColumnUpdate update = (ColumnUpdate)m.getUpdates().get(0);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"foo", (Object)new String(update.getValue()));
        AccumuloHiveRow haRow = new AccumuloHiveRow(new String(m.getRow()));
        haRow.add("cf", "cq", "foo".getBytes());
        LazyAccumuloRow lazyAccumuloRow = new LazyAccumuloRow(structOI);
        lazyAccumuloRow.init(haRow, accumuloSerDeParams.getColumnMappings(), accumuloSerDeParams.getRowIdFactory());
        ArrayList objects = lazyAccumuloRow.getFieldsAsList();
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertEquals((Object)"foo", (Object)objects.get(1).toString());
        LazyStruct rowStruct = (LazyStruct)objects.get(0);
        List rowObjects = rowStruct.getFieldsAsList();
        Assert.assertEquals((long)2L, (long)rowObjects.size());
        LazyMap rowMap = (LazyMap)rowObjects.get(0);
        Map actualMap = rowMap.getMap();
        System.out.println("Actual map 1: " + actualMap);
        HashMap<String, String> actualStringMap = new HashMap<String, String>();
        for (Map.Entry entry : actualMap.entrySet()) {
            actualStringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        Assert.assertEquals(map1, actualStringMap);
        rowMap = (LazyMap)rowObjects.get(1);
        actualMap = rowMap.getMap();
        System.out.println("Actual map 2: " + actualMap);
        actualStringMap = new HashMap();
        for (Map.Entry entry : actualMap.entrySet()) {
            actualStringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        Assert.assertEquals(map2, actualStringMap);
    }
}

