/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import org.apache.hadoop.hive.accumulo.predicate.PrimitiveComparisonFilter;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestPrimitiveComparisonFilter {
    @Test
    public void testBase64ConstantEncode() {
        PrimitiveComparisonFilter filter = new PrimitiveComparisonFilter();
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < 500; ++i) {
            String constant = Integer.toString(i);
            options.put("accumulo.filter.iterator.const.val", Base64.getEncoder().encodeToString(constant.getBytes()));
            Assert.assertEquals((Object)constant, (Object)new String(filter.getConstant(options)));
        }
    }

    @Test
    public void testNumericBase64ConstantEncode() throws IOException {
        PrimitiveComparisonFilter filter = new PrimitiveComparisonFilter();
        HashMap<String, String> options = new HashMap<String, String>();
        IntWritable writable = new IntWritable();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        for (int i = 0; i < 500; ++i) {
            writable.set(i);
            writable.write((DataOutput)out);
            options.put("accumulo.filter.iterator.const.val", Base64.getEncoder().encodeToString(baos.toByteArray()));
            byte[] bytes = filter.getConstant(options);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream in = new DataInputStream(bais);
            writable.readFields((DataInput)in);
            Assert.assertEquals((long)i, (long)writable.get());
            baos.reset();
        }
    }
}

