/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnMapper {
    @Test
    public void testNormalMapping() throws TooManyAccumuloColumnsException {
        List<String> rawMappings = Arrays.asList(":rowID", "cf:cq", "cf:_", "cf:qual");
        List<String> columnNames = Arrays.asList("row", "col1", "col2", "col3");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        ColumnMapper mapper = new ColumnMapper(Joiner.on((char)',').join(rawMappings), ColumnEncoding.STRING.getName(), columnNames, columnTypes);
        List mappings = mapper.getColumnMappings();
        Assert.assertEquals((long)rawMappings.size(), (long)mappings.size());
        Assert.assertEquals((long)mappings.size(), (long)mapper.size());
        Iterator<String> rawIter = rawMappings.iterator();
        Iterator iter = mappings.iterator();
        for (int i = 0; i < mappings.size() && iter.hasNext(); ++i) {
            String rawMapping = rawIter.next();
            ColumnMapping mapping = (ColumnMapping)iter.next();
            ColumnMapping mappingByOffset = mapper.get(i);
            Assert.assertEquals((Object)mapping, (Object)mappingByOffset);
            if (":rowID".equals(rawMapping)) {
                Assert.assertEquals(HiveAccumuloRowIdColumnMapping.class, mapping.getClass());
                continue;
            }
            Assert.assertEquals(HiveAccumuloColumnMapping.class, mapping.getClass());
        }
        Assert.assertEquals((long)0L, (long)mapper.getRowIdOffset());
        Assert.assertTrue((boolean)mapper.hasRowIdMapping());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultipleRowIDsFails() throws TooManyAccumuloColumnsException {
        new ColumnMapper(":rowID,:rowID", null, Arrays.asList("row", "row2"), Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo));
    }

    @Test
    public void testGetMappingFromHiveColumn() throws TooManyAccumuloColumnsException {
        List<String> hiveColumns = Arrays.asList("rowid", "col1", "col2", "col3");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        List<String> rawMappings = Arrays.asList(":rowID", "cf:cq", "cf:_", "cf:qual");
        ColumnMapper mapper = new ColumnMapper(Joiner.on((char)',').join(rawMappings), null, hiveColumns, columnTypes);
        for (int i = 0; i < hiveColumns.size(); ++i) {
            String hiveColumn = hiveColumns.get(i);
            String accumuloMapping = rawMappings.get(i);
            ColumnMapping mapping = mapper.getColumnMappingForHiveColumn(hiveColumns, hiveColumn);
            Assert.assertEquals((Object)accumuloMapping, (Object)mapping.getMappingSpec());
        }
    }

    @Test
    public void testGetTypesString() throws TooManyAccumuloColumnsException {
        List<String> hiveColumns = Arrays.asList("rowid", "col1", "col2", "col3");
        List<String> rawMappings = Arrays.asList(":rowID", "cf:cq", "cf:_", "cf:qual");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        ColumnMapper mapper = new ColumnMapper(Joiner.on((char)',').join(rawMappings), null, hiveColumns, columnTypes);
        String typeString = mapper.getTypesString();
        String[] types = StringUtils.split((String)typeString, (char)':');
        Assert.assertEquals((long)rawMappings.size(), (long)types.length);
        for (String type : types) {
            Assert.assertEquals((Object)"string", (Object)type);
        }
    }

    @Test
    public void testDefaultBinary() throws TooManyAccumuloColumnsException {
        List<String> hiveColumns = Arrays.asList("rowid", "col1", "col2", "col3", "col4");
        List<String> rawMappings = Arrays.asList(":rowID", "cf:cq", "cf:_#s", "cf:qual#s", "cf:qual2");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        ColumnMapper mapper = new ColumnMapper(Joiner.on((char)',').join(rawMappings), ColumnEncoding.BINARY.getName(), hiveColumns, columnTypes);
        List mappings = mapper.getColumnMappings();
        Assert.assertEquals((long)5L, (long)mappings.size());
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)((ColumnMapping)mappings.get(0)).getEncoding());
        Assert.assertEquals((Object)columnTypes.get(0).toString(), (Object)((ColumnMapping)mappings.get(0)).getColumnType());
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)((ColumnMapping)mappings.get(1)).getEncoding());
        Assert.assertEquals((Object)columnTypes.get(1).toString(), (Object)((ColumnMapping)mappings.get(1)).getColumnType());
        Assert.assertEquals((Object)ColumnEncoding.STRING, (Object)((ColumnMapping)mappings.get(2)).getEncoding());
        Assert.assertEquals((Object)columnTypes.get(2).toString(), (Object)((ColumnMapping)mappings.get(2)).getColumnType());
        Assert.assertEquals((Object)ColumnEncoding.STRING, (Object)((ColumnMapping)mappings.get(3)).getEncoding());
        Assert.assertEquals((Object)columnTypes.get(3).toString(), (Object)((ColumnMapping)mappings.get(3)).getColumnType());
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)((ColumnMapping)mappings.get(4)).getEncoding());
        Assert.assertEquals((Object)columnTypes.get(4).toString(), (Object)((ColumnMapping)mappings.get(4)).getColumnType());
    }

    @Test
    public void testMap() throws TooManyAccumuloColumnsException {
        List<String> hiveColumns = Arrays.asList("rowid", "col1", "col2", "col3");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo), TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo), TypeInfoFactory.stringTypeInfo);
        List<String> rawMappings = Arrays.asList(":rowID", "cf1:*", "cf2:2*", "cq3:bar\\*");
        ColumnMapper mapper = new ColumnMapper(Joiner.on((char)',').join(rawMappings), ColumnEncoding.BINARY.getName(), hiveColumns, columnTypes);
        List mappings = mapper.getColumnMappings();
        Assert.assertEquals((long)4L, (long)mappings.size());
        Assert.assertEquals(HiveAccumuloRowIdColumnMapping.class, ((ColumnMapping)mappings.get(0)).getClass());
        Assert.assertEquals(HiveAccumuloMapColumnMapping.class, ((ColumnMapping)mappings.get(1)).getClass());
        Assert.assertEquals(HiveAccumuloMapColumnMapping.class, ((ColumnMapping)mappings.get(2)).getClass());
        Assert.assertEquals(HiveAccumuloColumnMapping.class, ((ColumnMapping)mappings.get(3)).getClass());
        HiveAccumuloRowIdColumnMapping row = (HiveAccumuloRowIdColumnMapping)mappings.get(0);
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)row.getEncoding());
        Assert.assertEquals((Object)hiveColumns.get(0), (Object)row.getColumnName());
        Assert.assertEquals((Object)columnTypes.get(0).toString(), (Object)row.getColumnType());
        HiveAccumuloMapColumnMapping map = (HiveAccumuloMapColumnMapping)mappings.get(1);
        Assert.assertEquals((Object)"cf1", (Object)map.getColumnFamily());
        Assert.assertEquals((Object)"", (Object)map.getColumnQualifierPrefix());
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)map.getEncoding());
        Assert.assertEquals((Object)hiveColumns.get(1), (Object)map.getColumnName());
        Assert.assertEquals((Object)columnTypes.get(1).toString(), (Object)map.getColumnType());
        map = (HiveAccumuloMapColumnMapping)mappings.get(2);
        Assert.assertEquals((Object)"cf2", (Object)map.getColumnFamily());
        Assert.assertEquals((Object)"2", (Object)map.getColumnQualifierPrefix());
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)map.getEncoding());
        Assert.assertEquals((Object)hiveColumns.get(2), (Object)map.getColumnName());
        Assert.assertEquals((Object)columnTypes.get(2).toString(), (Object)map.getColumnType());
        HiveAccumuloColumnMapping column = (HiveAccumuloColumnMapping)mappings.get(3);
        Assert.assertEquals((Object)"cq3", (Object)column.getColumnFamily());
        Assert.assertEquals((Object)"bar*", (Object)column.getColumnQualifier());
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)column.getEncoding());
        Assert.assertEquals((Object)hiveColumns.get(3), (Object)column.getColumnName());
        Assert.assertEquals((Object)columnTypes.get(3).toString(), (Object)column.getColumnType());
    }
}

