/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Tool;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.DelegationTokenCache;
import org.apache.hive.hcatalog.templeton.tool.JobSubmissionConstants;
import org.apache.hive.hcatalog.templeton.tool.LaunchMapper;
import org.apache.hive.hcatalog.templeton.tool.SingleInputFormat;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TempletonControllerJob
extends Configured
implements Tool,
JobSubmissionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(TempletonControllerJob.class);
    private final boolean secureMetastoreAccess;
    private final AppConfig appConf;
    private Job job = null;

    public TempletonControllerJob(boolean secureMetastoreAccess, AppConfig conf) {
        super(new Configuration((Configuration)conf));
        this.secureMetastoreAccess = secureMetastoreAccess;
        this.appConf = conf;
    }

    public String getSubmittedId() {
        if (this.job == null) {
            return null;
        }
        JobID submittedJobId = this.job.getJobID();
        if (submittedJobId == null) {
            return null;
        }
        return submittedJobId.toString();
    }

    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException, TException {
        String amJavaOpts;
        String amMemoryMB;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing to submit job: " + Arrays.toString(args));
        }
        Configuration conf = this.getConf();
        conf.set("templeton.args", TempletonUtils.encodeArray(args));
        String memoryMb = this.appConf.mapperMemoryMb();
        if (memoryMb != null && memoryMb.length() != 0) {
            conf.set("mapreduce.map.memory.mb", memoryMb);
        }
        if ((amMemoryMB = this.appConf.amMemoryMb()) != null && !amMemoryMB.isEmpty()) {
            conf.set("yarn.app.mapreduce.am.resource.mb", amMemoryMB);
        }
        if ((amJavaOpts = this.appConf.controllerAMChildOpts()) != null && !amJavaOpts.isEmpty()) {
            conf.set("yarn.app.mapreduce.am.command-opts", amJavaOpts);
        }
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set("user.name", user);
        this.job = new Job(conf);
        this.job.setJarByClass(LaunchMapper.class);
        this.job.setJobName(TempletonControllerJob.class.getSimpleName());
        this.job.setMapperClass(LaunchMapper.class);
        this.job.setMapOutputKeyClass(Text.class);
        this.job.setMapOutputValueClass(Text.class);
        this.job.setInputFormatClass(SingleInputFormat.class);
        NullOutputFormat of = new NullOutputFormat();
        this.job.setOutputFormatClass(of.getClass());
        this.job.setNumReduceTasks(0);
        JobClient jc = new JobClient(new JobConf(this.job.getConfiguration()));
        if (UserGroupInformation.isSecurityEnabled()) {
            Token mrdt = jc.getDelegationToken(new Text("mr token"));
            this.job.getCredentials().addToken(new Text("mr token"), mrdt);
        }
        LauncherDelegator.JobType jobType = LauncherDelegator.JobType.valueOf(conf.get("templeton.jobtype"));
        String tokenStrForm = null;
        tokenStrForm = jobType == LauncherDelegator.JobType.HIVE ? this.addToken(this.job, user, "hive") : this.addToken(this.job, user, "hcat");
        this.job.submit();
        JobID submittedJobId = this.job.getJobID();
        if (tokenStrForm != null) {
            DelegationTokenCache.getStringFormTokenCache().storeDelegationToken(submittedJobId.toString(), tokenStrForm);
            LOG.debug("Added delegation token for jobId=" + submittedJobId.toString() + " user=" + user);
        }
        return 0;
    }

    private String addToken(Job job, String user, String type) throws IOException, InterruptedException, TException {
        if (!this.secureMetastoreAccess) {
            return null;
        }
        Token hiveToken = new Token();
        String tokenStrForm = type.equals("hive") ? this.buildHS2DelegationToken(user) : this.buildHcatDelegationToken(user);
        hiveToken.decodeFromUrlString(tokenStrForm);
        job.getCredentials().addToken(new Text(type), hiveToken);
        return tokenStrForm;
    }

    private String buildHcatDelegationToken(String user) throws IOException, InterruptedException, TException {
        final HiveConf c = new HiveConf();
        LOG.debug("Creating hive metastore delegation token for user " + user);
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        UserGroupInformation real = ugi.getRealUser();
        return (String)real.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException, TException, InterruptedException {
                final IMetaStoreClient client = HCatUtil.getHiveMetastoreClient((HiveConf)c);
                return (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws IOException, TException, InterruptedException {
                        String u = ugi.getUserName();
                        return client.getDelegationToken(c.getUser(), u);
                    }
                });
            }
        });
    }

    private String buildHS2DelegationToken(String user) throws IOException, InterruptedException, TException {
        HiveConf c = new HiveConf();
        LOG.debug("Creating hiveserver2 delegation token for user " + user);
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        UserGroupInformation real = ugi.getRealUser();
        return (String)real.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException, TException, InterruptedException {
                HiveConnection con;
                try {
                    Class.forName("org.apache.hive.jdbc.HiveDriver");
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
                String hs2Url = TempletonControllerJob.this.appConf.get("templeton.hive.hs2.url");
                try {
                    con = (HiveConnection)DriverManager.getConnection(hs2Url);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
                String token = (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws SQLException {
                        String u = ugi.getUserName();
                        return con.getDelegationToken(u, u);
                    }
                });
                return token;
            }
        });
    }
}

