/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.CallbackFailedException;
import org.apache.hive.hcatalog.templeton.CompleteBean;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.tool.DelegationTokenCache;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompleteDelegator
extends TempletonDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(CompleteDelegator.class);

    public CompleteDelegator(AppConfig appConf) {
        super(appConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompleteBean run(String id, String jobStatus) throws CallbackFailedException, IOException {
        if (id == null) {
            this.acceptWithError("No jobid given");
        }
        JobState state = null;
        boolean cancelMetastoreToken = false;
        try {
            Long notified;
            state = new JobState(id, Main.getAppConfigInstance());
            if (state.getCompleteStatus() == null) {
                this.failed("Job not yet complete. jobId=" + id + " Status from JobTracker=" + jobStatus, null);
            }
            if ((notified = state.getNotifiedTime()) != null) {
                cancelMetastoreToken = true;
                CompleteBean completeBean = this.acceptWithError("Callback already run for jobId=" + id + " at " + new Date(notified));
                return completeBean;
            }
            String callback = state.getCallback();
            if (callback == null) {
                cancelMetastoreToken = true;
                CompleteBean client = new CompleteBean("No callback registered");
                return client;
            }
            try {
                CompleteDelegator.doCallback(state.getId(), callback);
                cancelMetastoreToken = true;
            }
            catch (Exception e) {
                this.failed("Callback failed " + callback + " for " + id, e);
            }
            state.setNotifiedTime(System.currentTimeMillis());
            CompleteBean completeBean = new CompleteBean("Callback sent");
            return completeBean;
        }
        finally {
            IMetaStoreClient client;
            block27: {
                state.close();
                client = null;
                try {
                    String metastoreTokenStrForm;
                    if (!cancelMetastoreToken || (metastoreTokenStrForm = DelegationTokenCache.getStringFormTokenCache().getDelegationToken(id)) == null) break block27;
                    client = HCatUtil.getHiveMetastoreClient((HiveConf)new HiveConf());
                    client.cancelDelegationToken(metastoreTokenStrForm);
                    LOG.debug("Cancelled token for jobId=" + id + " status from JT=" + jobStatus);
                    DelegationTokenCache.getStringFormTokenCache().removeDelegationToken(id);
                }
                catch (Exception ex) {
                    try {
                        LOG.warn("Failed to cancel metastore delegation token for jobId=" + id, (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        HCatUtil.closeHiveClientQuietly(client);
                        throw throwable;
                    }
                    HCatUtil.closeHiveClientQuietly((IMetaStoreClient)client);
                }
            }
            HCatUtil.closeHiveClientQuietly(client);
        }
    }

    public static void doCallback(String jobid, String url) throws IOException {
        if (url.contains("$jobId")) {
            url = url.replace("$jobId", jobid);
        }
        TempletonUtils.fetchUrl(new URL(url));
    }

    private void failed(String msg, Exception e) throws CallbackFailedException {
        if (e != null) {
            LOG.error(msg, (Throwable)e);
        } else {
            LOG.error(msg);
        }
        throw new CallbackFailedException(msg);
    }

    private CompleteBean acceptWithError(String msg) {
        LOG.error(msg);
        return new CompleteBean(msg);
    }
}

