/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.hcatalog.templeton.tool.HDFSCleanup;
import org.apache.hive.hcatalog.templeton.tool.NotFoundException;
import org.apache.hive.hcatalog.templeton.tool.TempletonStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSStorage
implements TempletonStorage {
    FileSystem fs = null;
    public String storage_root = null;
    public static final String JOB_PATH = "/jobs";
    public static final String JOB_TRACKINGPATH = "/created";
    public static final String OVERHEAD_PATH = "/overhead";
    private static final Logger LOG = LoggerFactory.getLogger(HDFSStorage.class);

    @Override
    public void startCleanup(Configuration config) {
        try {
            HDFSCleanup.startInstance(config);
        }
        catch (Exception e) {
            LOG.warn("Cleanup instance didn't start.");
        }
    }

    @Override
    public void saveField(TempletonStorage.Type type, String id, String key, String val) throws NotFoundException {
        if (val == null) {
            return;
        }
        PrintWriter out = null;
        Path keyfile = new Path(this.getPath(type) + "/" + id + "/" + key);
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)this.fs.create(keyfile)));
            out.write(val);
            out.flush();
            this.close(out);
        }
        catch (Exception e) {
            try {
                String errMsg = "Couldn't write to " + keyfile + ": " + e.getMessage();
                LOG.error(errMsg, (Throwable)e);
                throw new NotFoundException(errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(out);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getField(TempletonStorage.Type type, String id, String key) {
        Path p;
        BufferedReader in;
        block7: {
            in = null;
            p = new Path(this.getPath(type) + "/" + id + "/" + key);
            if (this.fs.exists(p)) break block7;
            LOG.debug(p + " does not exist.");
            String string = null;
            this.close(in);
            return string;
        }
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)this.fs.open(p)));
            String line = null;
            String val = "";
            while ((line = in.readLine()) != null) {
                if (!val.equals("")) {
                    val = val + "\n";
                }
                val = val + line;
            }
            String string = val;
            this.close(in);
            return string;
        }
        catch (Exception e) {
            try {
                LOG.error("Couldn't find " + p + ": " + e.getMessage(), (Throwable)e);
                this.close(in);
            }
            catch (Throwable throwable) {
                this.close(in);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public boolean delete(TempletonStorage.Type type, String id) throws NotFoundException {
        Path p = new Path(this.getPath(type) + "/" + id);
        try {
            this.fs.delete(p, true);
        }
        catch (IOException e) {
            throw new NotFoundException("Node " + p + " was not found: " + e.getMessage());
        }
        return false;
    }

    @Override
    public List<String> getAllForType(TempletonStorage.Type type) {
        ArrayList<String> allNodes = new ArrayList<String>();
        try {
            for (FileStatus status : this.fs.listStatus(new Path(this.getPath(type)))) {
                allNodes.add(status.getPath().getName());
            }
            return null;
        }
        catch (Exception e) {
            LOG.trace("Couldn't find children for type " + type.toString());
            return allNodes;
        }
    }

    @Override
    public void openStorage(Configuration config) throws IOException {
        this.storage_root = config.get("templeton.storage.root");
        if (this.fs == null) {
            this.fs = new Path(this.storage_root).getFileSystem(config);
        }
    }

    @Override
    public void closeStorage() throws IOException {
    }

    public String getPath(TempletonStorage.Type type) {
        return HDFSStorage.getPath(type, this.storage_root);
    }

    public static String getPath(TempletonStorage.Type type, String root) {
        String typepath = root + OVERHEAD_PATH;
        switch (type) {
            case JOB: {
                typepath = root + JOB_PATH;
                break;
            }
            case JOBTRACKING: {
                typepath = root + JOB_TRACKINGPATH;
            }
        }
        return typepath;
    }

    private void close(Closeable is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException ex) {
            LOG.trace("Failed to close InputStream: " + ex.getMessage());
        }
    }
}

