/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.NoopReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.CreateTableReplicationTask;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.messaging.MessageFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestReplicationTask {
    private static MessageFactory msgFactory = MessageFactory.getInstance();

    @Test
    public void testCreate() throws HCatException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        NotificationEvent event = new NotificationEvent(0L, (int)System.currentTimeMillis(), "CREATE_TABLE", msgFactory.buildCreateTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        ReplicationTask.resetFactory(null);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)HCatClient.create((Configuration)new HiveConf()), (HCatNotificationEvent)new HCatNotificationEvent(event));
        Assert.assertTrue((String)"Provided factory instantiation should yield CreateTableReplicationTask", (boolean)(rtask instanceof CreateTableReplicationTask));
        ReplicationTask.resetFactory(NoopFactory.class);
        rtask = ReplicationTask.create((HCatClient)HCatClient.create((Configuration)new HiveConf()), (HCatNotificationEvent)new HCatNotificationEvent(event));
        Assert.assertTrue((String)"Provided factory instantiation should yield NoopReplicationTask", (boolean)(rtask instanceof NoopReplicationTask));
        ReplicationTask.resetFactory(null);
    }

    public static class NoopFactory
    implements ReplicationTask.Factory {
        public ReplicationTask create(HCatClient client, HCatNotificationEvent event) {
            String eventType = event.getEventType();
            if (eventType.equals("CREATE_DATABASE")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("DROP_DATABASE")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("CREATE_TABLE")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("DROP_TABLE")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("ADD_PARTITION")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("DROP_PARTITION")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("ALTER_TABLE")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("ALTER_PARTITION")) {
                return new NoopReplicationTask(event);
            }
            if (eventType.equals("INSERT")) {
                return new NoopReplicationTask(event);
            }
            throw new IllegalStateException("Unrecognized Event type, no replication task available");
        }
    }
}

