/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.DerbyPolicy;
import org.apache.hive.hcatalog.NoExitSecurityManager;
import org.apache.hive.hcatalog.api.HCatAddPartitionDesc;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatCreateDBDesc;
import org.apache.hive.hcatalog.api.HCatCreateTableDesc;
import org.apache.hive.hcatalog.api.HCatDatabase;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatPartitionSpec;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.api.ObjectNotFoundException;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.StagingDirectoryProvider;
import org.apache.hive.hcatalog.api.repl.exim.EximReplicationTaskFactory;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzer;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.apache.hive.hcatalog.listener.DbNotificationListener;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHCatClient {
    private static final Logger LOG = LoggerFactory.getLogger(TestHCatClient.class);
    private static int msPort;
    private static HiveConf hcatConf;
    private static boolean isReplicationTargetHCatRunning;
    private static int replicationTargetHCatPort;
    private static HiveConf replicationTargetHCatConf;
    private static SecurityManager securityManager;
    private static boolean useExternalMS;

    @AfterClass
    public static void tearDown() throws Exception {
        if (!useExternalMS) {
            LOG.info("Shutting down metastore.");
            System.setSecurityManager(securityManager);
        }
    }

    @BeforeClass
    public static void startMetaStoreServer() throws Exception {
        hcatConf = new HiveConf(TestHCatClient.class);
        String metastoreUri = System.getProperty("test." + HiveConf.ConfVars.METASTORE_URIS.varname);
        if (metastoreUri != null) {
            hcatConf.setVar(HiveConf.ConfVars.METASTORE_URIS, metastoreUri);
            useExternalMS = true;
            return;
        }
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH, (boolean)false);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS, DbNotificationListener.class, TransactionalMetaStoreEventListener.class);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_MESSAGE_FACTORY, JSONMessageEncoder.class, MessageEncoder.class);
        msPort = MetaStoreTestUtils.startMetaStoreWithRetry((Configuration)conf);
        securityManager = System.getSecurityManager();
        System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
        Policy.setPolicy((Policy)new DerbyPolicy());
        hcatConf.setVar(HiveConf.ConfVars.METASTORE_URIS, "thrift://localhost:" + msPort);
        hcatConf.setIntVar(HiveConf.ConfVars.METASTORE_THRIFT_CONNECTION_RETRIES, 3);
        hcatConf.set(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, HCatSemanticAnalyzer.class.getName());
        hcatConf.set(HiveConf.ConfVars.PRE_EXEC_HOOKS.varname, "");
        hcatConf.set(HiveConf.ConfVars.POST_EXEC_HOOKS.varname, "");
        hcatConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "false");
        System.setProperty(HiveConf.ConfVars.PRE_EXEC_HOOKS.varname, " ");
        System.setProperty(HiveConf.ConfVars.POST_EXEC_HOOKS.varname, " ");
    }

    public static HiveConf getConf() {
        return hcatConf;
    }

    public static String fixPath(String path) {
        String expectedDir = path.replaceAll("\\\\", "/");
        if (!expectedDir.startsWith("/")) {
            expectedDir = "/" + expectedDir;
        }
        return expectedDir;
    }

    public static String makePartLocation(HCatTable table, Map<String, String> partitionSpec) throws MetaException {
        return new Path(table.getSd().getLocation(), Warehouse.makePartPath(partitionSpec)).toUri().toString();
    }

    @Test
    public void testBasicDDLCommands() throws Exception {
        String db = "testdb";
        String tableOne = "testTable1";
        String tableTwo = "testTable2";
        String tableThree = "testTable3";
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        client.dropDatabase(db, true, HCatClient.DropDBMode.CASCADE);
        HCatCreateDBDesc dbDesc = HCatCreateDBDesc.create((String)db).ifNotExists(false).build();
        client.createDatabase(dbDesc);
        List dbNames = client.listDatabaseNamesByPattern("*");
        Assert.assertTrue((boolean)dbNames.contains("default"));
        Assert.assertTrue((boolean)dbNames.contains(db));
        HCatDatabase testDb = client.getDatabase(db);
        Assert.assertTrue((testDb.getComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((testDb.getProperties().size() == 0 ? 1 : 0) != 0);
        String warehouseDir = System.getProperty("test.warehouse.dir", "/user/hive/warehouse");
        if (useExternalMS) {
            Assert.assertTrue((boolean)testDb.getLocation().matches(".*/" + db + ".db"));
        } else {
            String expectedDir = warehouseDir.replaceFirst("pfile:///", "pfile:/") + "/" + msPort;
            Assert.assertEquals((Object)(expectedDir + "/" + db + ".db"), (Object)testDb.getLocation());
        }
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("id", HCatFieldSchema.Type.INT, "id comment"));
        cols.add(new HCatFieldSchema("value", HCatFieldSchema.Type.STRING, "value comment"));
        HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create((String)db, (String)tableOne, cols).fileFormat("rcfile").build();
        client.createTable(tableDesc);
        HCatTable table1 = client.getTable(db, tableOne);
        Assert.assertTrue((boolean)table1.getInputFileFormat().equalsIgnoreCase(RCFileInputFormat.class.getName()));
        Assert.assertTrue((boolean)table1.getOutputFileFormat().equalsIgnoreCase(RCFileOutputFormat.class.getName()));
        Assert.assertTrue((boolean)table1.getSerdeLib().equalsIgnoreCase(LazyBinaryColumnarSerDe.class.getName()));
        Assert.assertTrue((boolean)table1.getCols().equals(cols));
        try {
            client.createTable(tableDesc);
            Assert.fail((String)"Expected exception");
        }
        catch (HCatException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("AlreadyExistsException while creating table."));
        }
        client.dropTable(db, tableOne, true);
        HCatCreateTableDesc tableDesc2 = HCatCreateTableDesc.create((String)db, (String)tableTwo, cols).fieldsTerminatedBy('\u0001').escapeChar('\u0002').linesTerminatedBy('\u0003').mapKeysTerminatedBy('\u0004').collectionItemsTerminatedBy('\u0005').nullDefinedAs('\u0006').build();
        client.createTable(tableDesc2);
        HCatTable table2 = client.getTable(db, tableTwo);
        Assert.assertTrue((String)("Expected TextInputFormat, but got: " + table2.getInputFileFormat()), (boolean)table2.getInputFileFormat().equalsIgnoreCase(TextInputFormat.class.getName()));
        Assert.assertTrue((boolean)table2.getOutputFileFormat().equalsIgnoreCase(HiveIgnoreKeyTextOutputFormat.class.getName()));
        Assert.assertTrue((String)"SerdeParams not found", (table2.getSerdeParams() != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"checking field.delim", (Object)Character.toString('\u0001'), table2.getSerdeParams().get("field.delim"));
        Assert.assertEquals((String)"checking escape.delim", (Object)Character.toString('\u0002'), table2.getSerdeParams().get("escape.delim"));
        Assert.assertEquals((String)"checking line.delim", (Object)Character.toString('\u0003'), table2.getSerdeParams().get("line.delim"));
        Assert.assertEquals((String)"checking mapkey.delim", (Object)Character.toString('\u0004'), table2.getSerdeParams().get("mapkey.delim"));
        Assert.assertEquals((String)"checking collection.delim", (Object)Character.toString('\u0005'), table2.getSerdeParams().get("collection.delim"));
        Assert.assertEquals((String)"checking serialization.null.format", (Object)Character.toString('\u0006'), table2.getSerdeParams().get("serialization.null.format"));
        Assert.assertTrue((boolean)table2.getLocation().toLowerCase().matches(".*" + ("/" + db + ".db/" + tableTwo).toLowerCase()));
        HCatCreateTableDesc tableDesc3 = HCatCreateTableDesc.create((String)db, (String)tableThree, cols).fileFormat("orcfile").build();
        client.createTable(tableDesc3);
        HCatTable table3 = client.getTable(db, tableThree);
        Assert.assertTrue((boolean)table3.getInputFileFormat().equalsIgnoreCase(OrcInputFormat.class.getName()));
        Assert.assertTrue((boolean)table3.getOutputFileFormat().equalsIgnoreCase(OrcOutputFormat.class.getName()));
        Assert.assertTrue((boolean)table3.getSerdeLib().equalsIgnoreCase(OrcSerde.class.getName()));
        Assert.assertTrue((boolean)table1.getCols().equals(cols));
        client.close();
    }

    @Test
    public void testEmptyTableInstantiation() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String dbName = "default";
        String tblName = "testEmptyCreate";
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("id", HCatFieldSchema.Type.INT, "id comment"));
        cols.add(new HCatFieldSchema("value", HCatFieldSchema.Type.STRING, "value comment"));
        client.dropTable(dbName, tblName, true);
        client.createTable(HCatCreateTableDesc.create((HCatTable)new HCatTable(dbName, tblName).cols(cols), (boolean)false).build());
        HCatTable tCreated = client.getTable(dbName, tblName);
        org.apache.hadoop.hive.metastore.api.Table emptyTable = Table.getEmptyTable((String)dbName, (String)tblName);
        Map createdProps = tCreated.getTblProps();
        Map emptyProps = emptyTable.getParameters();
        this.mapEqualsContainedIn(emptyProps, createdProps);
        Map createdSdParams = tCreated.getSerdeParams();
        Map emptySdParams = emptyTable.getSd().getSerdeInfo().getParameters();
        this.mapEqualsContainedIn(emptySdParams, createdSdParams);
    }

    private void mapEqualsContainedIn(Map<String, String> inner, Map<String, String> outer) {
        Assert.assertNotNull(inner);
        Assert.assertNotNull(outer);
        for (Map.Entry<String, String> e : inner.entrySet()) {
            if (e.getKey().equals("bucketing_version")) continue;
            Assert.assertTrue((boolean)outer.containsKey(e.getKey()));
            Assert.assertEquals((Object)outer.get(e.getKey()), (Object)e.getValue());
        }
    }

    @Test
    public void testPartitionsHCatClientImpl() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String dbName = "ptnDB";
        String tableName = "pageView";
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        HCatCreateDBDesc dbDesc = HCatCreateDBDesc.create((String)dbName).ifNotExists(true).build();
        client.createDatabase(dbDesc);
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("userid", HCatFieldSchema.Type.INT, "id columns"));
        cols.add(new HCatFieldSchema("viewtime", HCatFieldSchema.Type.BIGINT, "view time columns"));
        cols.add(new HCatFieldSchema("pageurl", HCatFieldSchema.Type.STRING, ""));
        cols.add(new HCatFieldSchema("ip", HCatFieldSchema.Type.STRING, "IP Address of the User"));
        ArrayList<HCatFieldSchema> ptnCols = new ArrayList<HCatFieldSchema>();
        ptnCols.add(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, "date column"));
        ptnCols.add(new HCatFieldSchema("country", HCatFieldSchema.Type.STRING, "country column"));
        HCatTable table = new HCatTable(dbName, tableName).cols(cols).partCols(ptnCols).fileFormat("sequenceFile");
        HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create((HCatTable)table, (boolean)false).build();
        client.createTable(tableDesc);
        table = client.getTable(dbName, tableName);
        HashMap<String, String> firstPtn = new HashMap<String, String>();
        firstPtn.put("dt", "04/30/2012");
        firstPtn.put("country", "usa");
        HCatAddPartitionDesc addPtn = HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, firstPtn, null)).build();
        client.addPartition(addPtn);
        HashMap<String, String> secondPtn = new HashMap<String, String>();
        secondPtn.put("dt", "04/12/2012");
        secondPtn.put("country", "brazil");
        HCatAddPartitionDesc addPtn2 = HCatAddPartitionDesc.create((String)dbName, (String)tableName, null, secondPtn).build();
        client.addPartition(addPtn2);
        HashMap<String, String> thirdPtn = new HashMap<String, String>();
        thirdPtn.put("dt", "04/13/2012");
        thirdPtn.put("country", "argentina");
        HCatAddPartitionDesc addPtn3 = HCatAddPartitionDesc.create((String)dbName, (String)tableName, null, thirdPtn).build();
        client.addPartition(addPtn3);
        List ptnList = client.listPartitionsByFilter(dbName, tableName, null);
        Assert.assertTrue((ptnList.size() == 3 ? 1 : 0) != 0);
        HCatPartition ptn = client.getPartition(dbName, tableName, firstPtn);
        Assert.assertTrue((ptn != null ? 1 : 0) != 0);
        client.dropPartitions(dbName, tableName, firstPtn, true);
        ptnList = client.listPartitionsByFilter(dbName, tableName, null);
        Assert.assertTrue((ptnList.size() == 2 ? 1 : 0) != 0);
        List ptnListTwo = client.listPartitionsByFilter(dbName, tableName, "country = \"argentina\"");
        Assert.assertTrue((ptnListTwo.size() == 1 ? 1 : 0) != 0);
        client.markPartitionForEvent(dbName, tableName, thirdPtn, PartitionEventType.LOAD_DONE);
        boolean isMarked = client.isPartitionMarkedForEvent(dbName, tableName, thirdPtn, PartitionEventType.LOAD_DONE);
        Assert.assertTrue((boolean)isMarked);
        client.close();
    }

    @Test
    public void testDatabaseLocation() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String dbName = "locationDB";
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        HCatCreateDBDesc dbDesc = HCatCreateDBDesc.create((String)dbName).ifNotExists(true).location("/tmp/" + dbName).build();
        client.createDatabase(dbDesc);
        HCatDatabase newDB = client.getDatabase(dbName);
        Assert.assertTrue((boolean)newDB.getLocation().matches(".*/tmp/" + dbName));
        client.close();
    }

    @Test
    public void testCreateTableLike() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String tableName = "tableone";
        String cloneTable = "tabletwo";
        client.dropTable(null, tableName, true);
        client.dropTable(null, cloneTable, true);
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("id", HCatFieldSchema.Type.INT, "id columns"));
        cols.add(new HCatFieldSchema("value", HCatFieldSchema.Type.STRING, "id columns"));
        HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create(null, (String)tableName, cols).fileFormat("rcfile").build();
        client.createTable(tableDesc);
        client.createTableLike(null, tableName, cloneTable, true, false, null);
        List tables = client.listTableNamesByPattern(null, "table*");
        Assert.assertTrue((tables.size() == 2 ? 1 : 0) != 0);
        client.close();
    }

    @Test
    public void testRenameTable() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String tableName = "temptable";
        String newName = "mytable";
        client.dropTable(null, tableName, true);
        client.dropTable(null, newName, true);
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("id", HCatFieldSchema.Type.INT, "id columns"));
        cols.add(new HCatFieldSchema("value", HCatFieldSchema.Type.STRING, "id columns"));
        HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create(null, (String)tableName, cols).fileFormat("rcfile").build();
        client.createTable(tableDesc);
        client.renameTable(null, tableName, newName);
        try {
            client.getTable(null, tableName);
        }
        catch (HCatException exp) {
            Assert.assertTrue((String)("Unexpected exception message: " + exp.getMessage()), (boolean)exp.getMessage().contains("NoSuchObjectException while fetching table"));
        }
        HCatTable newTable = client.getTable(null, newName);
        Assert.assertTrue((newTable != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)newTable.getTableName().equals(newName));
        client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransportFailure() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        boolean isExceptionCaught = false;
        String tableName = "Temptable" + new BigInteger(260, new Random()).toString(2);
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("id", HCatFieldSchema.Type.INT, "id columns"));
        cols.add(new HCatFieldSchema("value", HCatFieldSchema.Type.STRING, "id columns"));
        try {
            HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create(null, (String)tableName, cols).fileFormat("rcfile").build();
            client.createTable(tableDesc);
        }
        catch (Exception exp) {
            isExceptionCaught = true;
            Assert.assertEquals((String)"Unexpected exception type.", HCatException.class, exp.getClass());
            client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String newName = "goodTable";
            client.dropTable(null, newName, true);
            HCatCreateTableDesc tableDesc2 = HCatCreateTableDesc.create(null, (String)newName, cols).fileFormat("rcfile").build();
            client.createTable(tableDesc2);
            HCatTable newTable = client.getTable(null, newName);
            Assert.assertTrue((newTable != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)newTable.getTableName().equalsIgnoreCase(newName));
        }
        finally {
            client.close();
            Assert.assertTrue((String)"The expected exception was never thrown.", (boolean)isExceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherFailure() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String tableName = "Temptable";
        boolean isExceptionCaught = false;
        client.dropTable(null, tableName, true);
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("id", HCatFieldSchema.Type.INT, "id columns"));
        cols.add(new HCatFieldSchema("value", HCatFieldSchema.Type.STRING, "id columns"));
        try {
            HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create(null, (String)tableName, cols).fileFormat("rcfile").build();
            client.createTable(tableDesc);
            client.getTable("foo", tableName);
        }
        catch (Exception exp) {
            isExceptionCaught = true;
            Assert.assertTrue((boolean)(exp instanceof HCatException));
            String newName = "goodTable";
            client.dropTable(null, newName, true);
            HCatCreateTableDesc tableDesc2 = HCatCreateTableDesc.create(null, (String)newName, cols).fileFormat("rcfile").build();
            client.createTable(tableDesc2);
            HCatTable newTable = client.getTable(null, newName);
            Assert.assertTrue((newTable != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)newTable.getTableName().equalsIgnoreCase(newName));
        }
        finally {
            client.close();
            Assert.assertTrue((String)"The expected exception was never thrown.", (boolean)isExceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropTableException() throws Exception {
        HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
        String tableName = "tableToBeDropped";
        boolean isExceptionCaught = false;
        client.dropTable(null, tableName, true);
        try {
            client.dropTable(null, tableName, false);
        }
        catch (Exception exp) {
            isExceptionCaught = true;
            Assert.assertTrue((boolean)(exp instanceof HCatException));
            LOG.info("Drop Table Exception: " + exp.getCause());
        }
        finally {
            client.close();
            Assert.assertTrue((String)"The expected exception was never thrown.", (boolean)isExceptionCaught);
        }
    }

    @Test
    public void testUpdateTableSchema() throws Exception {
        try {
            HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String dbName = "testUpdateTableSchema_DBName";
            String tableName = "testUpdateTableSchema_TableName";
            client.dropDatabase("testUpdateTableSchema_DBName", true, HCatClient.DropDBMode.CASCADE);
            client.createDatabase(HCatCreateDBDesc.create((String)"testUpdateTableSchema_DBName").build());
            List<HCatFieldSchema> oldSchema = Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, ""));
            client.createTable(HCatCreateTableDesc.create((String)"testUpdateTableSchema_DBName", (String)"testUpdateTableSchema_TableName", oldSchema).build());
            List<HCatFieldSchema> newSchema = Arrays.asList(new HCatFieldSchema("completely", HCatFieldSchema.Type.DOUBLE, ""), new HCatFieldSchema("new", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("fields", HCatFieldSchema.Type.STRING, ""));
            client.updateTableSchema("testUpdateTableSchema_DBName", "testUpdateTableSchema_TableName", newSchema);
            Assert.assertArrayEquals((Object[])newSchema.toArray(), (Object[])client.getTable("testUpdateTableSchema_DBName", "testUpdateTableSchema_TableName").getCols().toArray());
            client.dropDatabase("testUpdateTableSchema_DBName", false, HCatClient.DropDBMode.CASCADE);
        }
        catch (Exception exception) {
            LOG.error("Unexpected exception.", (Throwable)exception);
            Assert.assertTrue((String)("Unexpected exception: " + exception.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testObjectNotFoundException() throws Exception {
        try {
            HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String dbName = "testObjectNotFoundException_DBName";
            String tableName = "testObjectNotFoundException_TableName";
            client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
            try {
                client.getDatabase(dbName);
                Assert.assertTrue((String)"Expected ObjectNotFoundException.", (boolean)false);
            }
            catch (Exception exception) {
                LOG.info("Got exception: ", (Throwable)exception);
                Assert.assertTrue((String)("Expected ObjectNotFoundException. Got:" + exception.getClass()), (boolean)(exception instanceof ObjectNotFoundException));
            }
            client.createDatabase(HCatCreateDBDesc.create((String)dbName).build());
            try {
                client.getTable(dbName, tableName);
                Assert.assertTrue((String)"Expected ObjectNotFoundException.", (boolean)false);
            }
            catch (Exception exception) {
                LOG.info("Got exception: ", (Throwable)exception);
                Assert.assertTrue((String)("Expected ObjectNotFoundException. Got:" + exception.getClass()), (boolean)(exception instanceof ObjectNotFoundException));
            }
            String partitionColumn = "part";
            List<HCatFieldSchema> columns = Arrays.asList(new HCatFieldSchema("col", HCatFieldSchema.Type.STRING, ""));
            ArrayList<HCatFieldSchema> partitionColumns = new ArrayList<HCatFieldSchema>(Arrays.asList(new HCatFieldSchema(partitionColumn, HCatFieldSchema.Type.STRING, "")));
            HCatTable table = new HCatTable(dbName, tableName).cols(columns).partCols(partitionColumns);
            client.createTable(HCatCreateTableDesc.create((HCatTable)table, (boolean)false).build());
            HCatTable createdTable = client.getTable(dbName, tableName);
            HashMap<String, String> partitionSpec = new HashMap<String, String>();
            partitionSpec.put(partitionColumn, "foobar");
            try {
                client.getPartition(dbName, tableName, partitionSpec);
                Assert.assertTrue((String)"Expected ObjectNotFoundException.", (boolean)false);
            }
            catch (Exception exception) {
                LOG.info("Got exception: ", (Throwable)exception);
                Assert.assertTrue((String)("Expected ObjectNotFoundException. Got:" + exception.getClass()), (boolean)(exception instanceof ObjectNotFoundException));
            }
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(createdTable, partitionSpec, TestHCatClient.makePartLocation(createdTable, partitionSpec))).build());
            Assert.assertEquals((String)"Expected empty set of partitions.", (long)0L, (long)client.listPartitionsByFilter(dbName, tableName, partitionColumn + " < 'foobar'").size());
            try {
                partitionSpec.put("NonExistentKey", "foobar");
                client.getPartition(dbName, tableName, partitionSpec);
                Assert.assertTrue((String)"Expected HCatException.", (boolean)false);
            }
            catch (Exception exception) {
                LOG.info("Got exception: ", (Throwable)exception);
                Assert.assertTrue((String)("Expected HCatException. Got:" + exception.getClass()), (boolean)(exception instanceof HCatException));
                Assert.assertFalse((String)"Did not expect ObjectNotFoundException.", (boolean)(exception instanceof ObjectNotFoundException));
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception!", t);
            Assert.assertTrue((String)("Unexpected exception! " + t.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testGetMessageBusTopicName() throws Exception {
        try {
            HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String dbName = "testGetMessageBusTopicName_DBName";
            String tableName = "testGetMessageBusTopicName_TableName";
            client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
            client.createDatabase(HCatCreateDBDesc.create((String)dbName).build());
            String messageBusTopicName = "MY.topic.name";
            HashMap<String, String> tableProperties = new HashMap<String, String>(1);
            tableProperties.put("hcat.msgbus.topic.name", messageBusTopicName);
            client.createTable(HCatCreateTableDesc.create((String)dbName, (String)tableName, Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.STRING, ""))).tblProps(tableProperties).build());
            Assert.assertEquals((String)"MessageBus topic-name doesn't match!", (Object)messageBusTopicName, (Object)client.getMessageBusTopicName(dbName, tableName));
            client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
            client.close();
        }
        catch (Exception exception) {
            LOG.error("Unexpected exception.", (Throwable)exception);
            Assert.assertTrue((String)("Unexpected exception:" + exception.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testPartitionSchema() throws Exception {
        try {
            HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String dbName = "myDb";
            String tableName = "myTable";
            client.dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            client.createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            List<HCatFieldSchema> columnSchema = Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, ""));
            List<HCatFieldSchema> partitionSchema = Arrays.asList(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("grid", HCatFieldSchema.Type.STRING, ""));
            client.createTable(HCatCreateTableDesc.create((String)"myDb", (String)"myTable", columnSchema).partCols(partitionSchema).build());
            HCatTable table = client.getTable("myDb", "myTable");
            List partitionColumns = table.getPartCols();
            Assert.assertArrayEquals((String)"Didn't get expected partition-schema back from the HCatTable.", (Object[])partitionSchema.toArray(), (Object[])partitionColumns.toArray());
            client.dropDatabase("myDb", false, HCatClient.DropDBMode.CASCADE);
        }
        catch (Exception unexpected) {
            LOG.error("Unexpected exception!", (Throwable)unexpected);
            Assert.assertTrue((String)("Unexpected exception! " + unexpected.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testGetPartitionsWithPartialSpec() throws Exception {
        try {
            HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String dbName = "myDb";
            String tableName = "myTable";
            client.dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            client.createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            List<HCatFieldSchema> columnSchema = Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, ""));
            List<HCatFieldSchema> partitionSchema = Arrays.asList(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("grid", HCatFieldSchema.Type.STRING, ""));
            HCatTable table = new HCatTable("myDb", "myTable").cols(columnSchema).partCols(partitionSchema);
            client.createTable(HCatCreateTableDesc.create((HCatTable)table, (boolean)false).build());
            table = client.getTable("myDb", "myTable");
            Assert.assertNotNull((String)"The created just now can't be null.", (Object)table);
            HashMap<String, String> partitionSpec = new HashMap<String, String>();
            partitionSpec.put("grid", "AB");
            partitionSpec.put("dt", "2011_12_31");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            partitionSpec.put("grid", "AB");
            partitionSpec.put("dt", "2012_01_01");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            partitionSpec.put("dt", "2012_01_01");
            partitionSpec.put("grid", "OB");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            partitionSpec.put("dt", "2012_01_01");
            partitionSpec.put("grid", "XB");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            HashMap<String, String> partialPartitionSpec = new HashMap<String, String>();
            partialPartitionSpec.put("dt", "2012_01_01");
            List partitions = client.getPartitions("myDb", "myTable", partialPartitionSpec);
            Assert.assertEquals((String)"Unexpected number of partitions.", (long)3L, (long)partitions.size());
            Assert.assertArrayEquals((String)"Mismatched partition.", (Object[])new String[]{"2012_01_01", "AB"}, (Object[])((HCatPartition)partitions.get(0)).getValues().toArray());
            Assert.assertArrayEquals((String)"Mismatched partition.", (Object[])new String[]{"2012_01_01", "OB"}, (Object[])((HCatPartition)partitions.get(1)).getValues().toArray());
            Assert.assertArrayEquals((String)"Mismatched partition.", (Object[])new String[]{"2012_01_01", "XB"}, (Object[])((HCatPartition)partitions.get(2)).getValues().toArray());
            client.dropDatabase("myDb", false, HCatClient.DropDBMode.CASCADE);
        }
        catch (Exception unexpected) {
            LOG.error("Unexpected exception!", (Throwable)unexpected);
            Assert.assertTrue((String)("Unexpected exception! " + unexpected.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testDropPartitionsWithPartialSpec() throws Exception {
        try {
            HCatClient client = HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
            String dbName = "myDb";
            String tableName = "myTable";
            client.dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            client.createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            List<HCatFieldSchema> columnSchema = Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, ""));
            List<HCatFieldSchema> partitionSchema = Arrays.asList(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("grid", HCatFieldSchema.Type.STRING, ""));
            HCatTable table = new HCatTable("myDb", "myTable").cols(columnSchema).partCols(partitionSchema);
            client.createTable(HCatCreateTableDesc.create((HCatTable)table, (boolean)false).build());
            table = client.getTable("myDb", "myTable");
            Assert.assertNotNull((String)"Table couldn't be queried for. ", (Object)table);
            HashMap<String, String> partitionSpec = new HashMap<String, String>();
            partitionSpec.put("grid", "AB");
            partitionSpec.put("dt", "2011_12_31");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            partitionSpec.put("grid", "AB");
            partitionSpec.put("dt", "2012_01_01");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            partitionSpec.put("dt", "2012_01_01");
            partitionSpec.put("grid", "OB");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            partitionSpec.put("dt", "2012_01_01");
            partitionSpec.put("grid", "XB");
            client.addPartition(HCatAddPartitionDesc.create((HCatPartition)new HCatPartition(table, partitionSpec, TestHCatClient.makePartLocation(table, partitionSpec))).build());
            HashMap<String, String> partialPartitionSpec = new HashMap<String, String>();
            partialPartitionSpec.put("dt", "2012_01_01");
            client.dropPartitions("myDb", "myTable", partialPartitionSpec, true);
            List partitions = client.getPartitions("myDb", "myTable");
            Assert.assertEquals((String)"Unexpected number of partitions.", (long)1L, (long)partitions.size());
            Assert.assertArrayEquals((String)"Mismatched partition.", (Object[])new String[]{"2011_12_31", "AB"}, (Object[])((HCatPartition)partitions.get(0)).getValues().toArray());
            List partColumns = ((HCatPartition)partitions.get(0)).getPartColumns();
            Assert.assertEquals((long)2L, (long)partColumns.size());
            Assert.assertEquals((Object)"dt", (Object)((HCatFieldSchema)partColumns.get(0)).getName());
            Assert.assertEquals((Object)"grid", (Object)((HCatFieldSchema)partColumns.get(1)).getName());
            client.dropDatabase("myDb", false, HCatClient.DropDBMode.CASCADE);
        }
        catch (Exception unexpected) {
            LOG.error("Unexpected exception!", (Throwable)unexpected);
            Assert.assertTrue((String)("Unexpected exception! " + unexpected.getMessage()), (boolean)false);
        }
    }

    private void startReplicationTargetMetaStoreIfRequired() throws Exception {
        if (!isReplicationTargetHCatRunning) {
            HiveConf conf = new HiveConf();
            conf.set("javax.jdo.option.ConnectionURL", hcatConf.get("javax.jdo.option.ConnectionURL").replace("metastore", "target_metastore"));
            replicationTargetHCatPort = MetaStoreTestUtils.startMetaStoreWithRetry((Configuration)conf);
            replicationTargetHCatConf = new HiveConf(hcatConf);
            replicationTargetHCatConf.setVar(HiveConf.ConfVars.METASTORE_URIS, "thrift://localhost:" + replicationTargetHCatPort);
            isReplicationTargetHCatRunning = true;
        }
    }

    @Test
    public void testReplicationTaskIter() throws Exception {
        Configuration cfg = new Configuration((Configuration)hcatConf);
        cfg.set(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX.varname, "10");
        cfg.set(HiveConf.ConfVars.HIVE_REPL_TASK_FACTORY.varname, EximReplicationTaskFactory.class.getName());
        HCatClient sourceMetastore = HCatClient.create((Configuration)cfg);
        String dbName = "testReplicationTaskIter";
        long baseId = sourceMetastore.getCurrentNotificationEventId();
        sourceMetastore.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        sourceMetastore.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        String tblName1 = "T1";
        List cols1 = HCatSchemaUtils.getHCatSchema((String)"a:int,b:string").getFields();
        HCatTable table1 = new HCatTable(dbName, tblName1).cols(cols1);
        sourceMetastore.createTable(HCatCreateTableDesc.create((HCatTable)table1).build());
        String tblName2 = "T2";
        List cols2 = HCatSchemaUtils.getHCatSchema((String)"a:int").getFields();
        List pcols2 = HCatSchemaUtils.getHCatSchema((String)"b:string").getFields();
        HCatTable table2 = new HCatTable(dbName, tblName2).cols(cols2).partCols(pcols2);
        sourceMetastore.createTable(HCatCreateTableDesc.create((HCatTable)table2).build());
        HCatTable table2Created = sourceMetastore.getTable(dbName, tblName2);
        HashMap<String, String> ptnDesc1 = new HashMap<String, String>();
        ptnDesc1.put("b", "test1");
        HCatPartition ptn1 = new HCatPartition(table2Created, ptnDesc1, TestHCatClient.makePartLocation(table2Created, ptnDesc1));
        sourceMetastore.addPartition(HCatAddPartitionDesc.create((HCatPartition)ptn1).build());
        for (int i = 0; i < 20; ++i) {
            HashMap<String, String> ptnDesc = new HashMap<String, String>();
            ptnDesc.put("b", "testmul" + i);
            HCatPartition ptn = new HCatPartition(table2Created, ptnDesc, TestHCatClient.makePartLocation(table2Created, ptnDesc));
            sourceMetastore.addPartition(HCatAddPartitionDesc.create((HCatPartition)ptn).build());
            sourceMetastore.dropPartitions(dbName, tblName2, ptnDesc, true);
        }
        sourceMetastore.dropTable(dbName, tblName1, true);
        sourceMetastore.dropTable(dbName, tblName2, true);
        long currId = sourceMetastore.getCurrentNotificationEventId();
        Assert.assertTrue((String)("currId[" + currId + "] must be more than 25 greater than baseId[" + baseId + "]"), (currId > baseId + 25L ? 1 : 0) != 0);
        List notifs = sourceMetastore.getNextNotification(0L, 0, new IMetaStoreClient.NotificationFilter(){

            public boolean accept(NotificationEvent event) {
                return true;
            }
        });
        for (HCatNotificationEvent n : notifs) {
            LOG.info("notif from dblistener:" + n.getEventId() + ":" + n.getEventTime() + ",t:" + n.getEventType() + ",o:" + n.getDbName() + "." + n.getTableName());
        }
        Iterator taskIter = sourceMetastore.getReplicationTasks(0L, -1, dbName, null);
        while (taskIter.hasNext()) {
            ReplicationTask task = (ReplicationTask)taskIter.next();
            HCatNotificationEvent n = task.getEvent();
            LOG.info("notif from tasks:" + n.getEventId() + ":" + n.getEventTime() + ",t:" + n.getEventType() + ",o:" + n.getDbName() + "." + n.getTableName() + ",s:" + n.getEventScope());
            LOG.info("task :" + task.getClass().getName());
            if (task.needsStagingDirs()) {
                StagingDirectoryProvider provider = new StagingDirectoryProvider(){

                    public String getStagingDirectory(String key) {
                        LOG.info("getStagingDirectory(" + key + ") called!");
                        return "/tmp/" + key.replaceAll(" ", "_");
                    }
                };
                task.withSrcStagingDirProvider(provider).withDstStagingDirProvider(provider);
            }
            if (task.isActionable()) {
                LOG.info("task was actionable!");
                Function<Command, String> commandDebugPrinter = new Function<Command, String>(){

                    public String apply(@Nullable Command cmd) {
                        StringBuilder sb = new StringBuilder();
                        String serializedCmd = null;
                        try {
                            serializedCmd = ReplicationUtils.serializeCommand((Command)cmd);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                        sb.append("SERIALIZED:" + serializedCmd + "\n");
                        Command command = null;
                        try {
                            command = ReplicationUtils.deserializeCommand((String)serializedCmd);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                        sb.append("CMD:[" + command.getClass().getName() + "]\n");
                        sb.append("EVENTID:[" + command.getEventId() + "]\n");
                        for (String s : command.get()) {
                            sb.append("CMD:" + s);
                            sb.append("\n");
                        }
                        sb.append("Retriable:" + command.isRetriable() + "\n");
                        sb.append("Undoable:" + command.isUndoable() + "\n");
                        if (command.isUndoable()) {
                            for (String s : command.getUndo()) {
                                sb.append("UNDO:" + s);
                                sb.append("\n");
                            }
                        }
                        List locns = command.cleanupLocationsPerRetry();
                        sb.append("cleanupLocationsPerRetry entries :" + locns.size());
                        for (String s : locns) {
                            sb.append("RETRY_CLEANUP:" + s);
                            sb.append("\n");
                        }
                        locns = command.cleanupLocationsAfterEvent();
                        sb.append("cleanupLocationsAfterEvent entries :" + locns.size());
                        for (String s : locns) {
                            sb.append("AFTER_EVENT_CLEANUP:" + s);
                            sb.append("\n");
                        }
                        return sb.toString();
                    }
                };
                LOG.info("On src:");
                for (String s : Iterables.transform((Iterable)task.getSrcWhCommands(), (Function)commandDebugPrinter)) {
                    LOG.info(s);
                }
                LOG.info("On dest:");
                for (String s : Iterables.transform((Iterable)task.getDstWhCommands(), (Function)commandDebugPrinter)) {
                    LOG.info(s);
                }
                continue;
            }
            LOG.info("task was not actionable.");
        }
    }

    private HCatClient sourceMetaStore() throws HCatException {
        return HCatClient.create((Configuration)new Configuration((Configuration)hcatConf));
    }

    private HCatClient targetMetaStore() throws HCatException {
        return HCatClient.create((Configuration)new Configuration((Configuration)replicationTargetHCatConf));
    }

    @Test
    public void testTableSchemaPropagation() throws Exception {
        try {
            this.startReplicationTargetMetaStoreIfRequired();
            String dbName = "myDb";
            String tableName = "myTable";
            this.sourceMetaStore().dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            this.sourceMetaStore().createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            List<HCatFieldSchema> columnSchema = Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, ""));
            List<HCatFieldSchema> partitionSchema = Arrays.asList(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("grid", HCatFieldSchema.Type.STRING, ""));
            HCatTable sourceTable = new HCatTable("myDb", "myTable").cols(columnSchema).partCols(partitionSchema);
            this.sourceMetaStore().createTable(HCatCreateTableDesc.create((HCatTable)sourceTable).build());
            sourceTable = this.sourceMetaStore().getTable("myDb", "myTable");
            Assert.assertNotNull((String)"Table couldn't be queried for. ", (Object)sourceTable);
            String tableStringRep = this.sourceMetaStore().serializeTable(sourceTable);
            this.targetMetaStore().dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            this.targetMetaStore().createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            HCatTable targetTable = this.targetMetaStore().deserializeTable(tableStringRep);
            Assert.assertEquals((String)"Table after deserialization should have been identical to sourceTable.", (Object)HCatTable.NO_DIFF, (Object)sourceTable.diff(targetTable));
            this.targetMetaStore().createTable(HCatCreateTableDesc.create((HCatTable)targetTable).build());
            targetTable = this.targetMetaStore().getTable("myDb", "myTable");
            Assert.assertEquals((String)"Table after deserialization should have been identical to sourceTable.", (Object)HCatTable.NO_DIFF, (Object)sourceTable.diff(targetTable));
            ArrayList<HCatFieldSchema> newColumnSchema = new ArrayList<HCatFieldSchema>(columnSchema);
            newColumnSchema.add(new HCatFieldSchema("goo_new", HCatFieldSchema.Type.DOUBLE, ""));
            HashMap<String, String> tableParams = new HashMap<String, String>(1);
            tableParams.put("orc.compress", "ZLIB");
            sourceTable.cols(newColumnSchema).fileFormat("orcfile").tblProps(tableParams).serdeParam("field.delim", Character.toString('\u0001'));
            this.sourceMetaStore().updateTableSchema("myDb", "myTable", sourceTable);
            sourceTable = this.sourceMetaStore().getTable("myDb", "myTable");
            EnumSet diff = targetTable.diff(sourceTable);
            Assert.assertTrue((String)"Couldn't find change in column-schema.", (boolean)diff.contains(HCatTable.TableAttribute.COLUMNS));
            Assert.assertTrue((String)"Couldn't find change in InputFormat.", (boolean)diff.contains(HCatTable.TableAttribute.INPUT_FORMAT));
            Assert.assertTrue((String)"Couldn't find change in OutputFormat.", (boolean)diff.contains(HCatTable.TableAttribute.OUTPUT_FORMAT));
            Assert.assertTrue((String)"Couldn't find change in SerDe.", (boolean)diff.contains(HCatTable.TableAttribute.SERDE));
            Assert.assertTrue((String)"Couldn't find change in SerDe parameters.", (boolean)diff.contains(HCatTable.TableAttribute.SERDE_PROPERTIES));
            Assert.assertTrue((String)"Couldn't find change in Table parameters.", (boolean)diff.contains(HCatTable.TableAttribute.TABLE_PROPERTIES));
            this.targetMetaStore().updateTableSchema("myDb", "myTable", targetTable.resolve(sourceTable, diff));
            targetTable = this.targetMetaStore().getTable("myDb", "myTable");
            Assert.assertEquals((String)"After propagating schema changes, source and target tables should have been equivalent.", (Object)HCatTable.NO_DIFF, (Object)targetTable.diff(sourceTable));
        }
        catch (Exception unexpected) {
            LOG.error("Unexpected exception!", (Throwable)unexpected);
            Assert.assertTrue((String)("Unexpected exception! " + unexpected.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testPartitionRegistrationWithCustomSchema() throws Exception {
        try {
            this.startReplicationTargetMetaStoreIfRequired();
            String dbName = "myDb";
            String tableName = "myTable";
            this.sourceMetaStore().dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            this.sourceMetaStore().createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            ArrayList<HCatFieldSchema> columnSchema = new ArrayList<HCatFieldSchema>(Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, "")));
            List<HCatFieldSchema> partitionSchema = Arrays.asList(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("grid", HCatFieldSchema.Type.STRING, ""));
            HCatTable sourceTable = new HCatTable("myDb", "myTable").cols(columnSchema).partCols(partitionSchema).comment("Source table.");
            this.sourceMetaStore().createTable(HCatCreateTableDesc.create((HCatTable)sourceTable).build());
            sourceTable = this.sourceMetaStore().getTable("myDb", "myTable");
            Assert.assertNotNull((String)"Table couldn't be queried for. ", (Object)sourceTable);
            HashMap<String, String> partitionSpec_1 = new HashMap<String, String>();
            partitionSpec_1.put("grid", "AB");
            partitionSpec_1.put("dt", "2011_12_31");
            HCatPartition sourcePartition_1 = new HCatPartition(sourceTable, partitionSpec_1, TestHCatClient.makePartLocation(sourceTable, partitionSpec_1));
            this.sourceMetaStore().addPartition(HCatAddPartitionDesc.create((HCatPartition)sourcePartition_1).build());
            Assert.assertEquals((String)"Unexpected number of partitions. ", (long)1L, (long)this.sourceMetaStore().getPartitions("myDb", "myTable").size());
            HCatPartition addedPartition_1 = this.sourceMetaStore().getPartition("myDb", "myTable", partitionSpec_1);
            Assert.assertEquals((String)"Column schema doesn't match.", (Object)sourceTable.getCols(), (Object)addedPartition_1.getColumns());
            Assert.assertEquals((String)"InputFormat doesn't match.", (Object)sourceTable.getInputFileFormat(), (Object)addedPartition_1.getInputFormat());
            Assert.assertEquals((String)"OutputFormat doesn't match.", (Object)sourceTable.getOutputFileFormat(), (Object)addedPartition_1.getOutputFormat());
            Assert.assertEquals((String)"SerDe doesn't match.", (Object)sourceTable.getSerdeLib(), (Object)addedPartition_1.getSerDe());
            Assert.assertEquals((String)"SerDe params don't match.", (Object)sourceTable.getSerdeParams(), (Object)addedPartition_1.getSerdeParams());
            this.targetMetaStore().dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            this.targetMetaStore().createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            HCatTable targetTable = this.targetMetaStore().deserializeTable(this.sourceMetaStore().serializeTable(sourceTable));
            this.targetMetaStore().createTable(HCatCreateTableDesc.create((HCatTable)targetTable).build());
            targetTable = this.targetMetaStore().getTable("myDb", "myTable");
            Assert.assertEquals((String)"Created table doesn't match the source.", (Object)HCatTable.NO_DIFF, (Object)targetTable.diff(sourceTable));
            ArrayList<HCatFieldSchema> newColumnSchema = new ArrayList<HCatFieldSchema>(columnSchema);
            newColumnSchema.add(new HCatFieldSchema("goo_new", HCatFieldSchema.Type.DOUBLE, ""));
            HashMap<String, String> tableParams = new HashMap<String, String>(1);
            tableParams.put("orc.compress", "ZLIB");
            sourceTable.cols(newColumnSchema).fileFormat("orcfile").tblProps(tableParams).serdeParam("field.delim", Character.toString('\u0001'));
            this.sourceMetaStore().updateTableSchema("myDb", "myTable", sourceTable);
            sourceTable = this.sourceMetaStore().getTable("myDb", "myTable");
            HashMap<String, String> partitionSpec_2 = new HashMap<String, String>();
            partitionSpec_2.put("grid", "AB");
            partitionSpec_2.put("dt", "2012_01_01");
            HCatPartition sourcePartition_2 = new HCatPartition(sourceTable, partitionSpec_2, TestHCatClient.makePartLocation(sourceTable, partitionSpec_2));
            this.sourceMetaStore().addPartition(HCatAddPartitionDesc.create((HCatPartition)sourcePartition_2).build());
            List sourcePartitions = this.sourceMetaStore().getPartitions("myDb", "myTable");
            Assert.assertEquals((String)"Unexpected number of source partitions.", (long)2L, (long)sourcePartitions.size());
            ArrayList<HCatAddPartitionDesc> addPartitionDescs = new ArrayList<HCatAddPartitionDesc>(sourcePartitions.size());
            for (HCatPartition partition : sourcePartitions) {
                addPartitionDescs.add(HCatAddPartitionDesc.create((HCatPartition)partition).build());
            }
            this.targetMetaStore().addPartitions(addPartitionDescs);
            List targetPartitions = this.targetMetaStore().getPartitions("myDb", "myTable");
            Assert.assertEquals((String)"Expected the same number of partitions. ", (long)sourcePartitions.size(), (long)targetPartitions.size());
            for (int i = 0; i < targetPartitions.size(); ++i) {
                HCatPartition sourcePartition = (HCatPartition)sourcePartitions.get(i);
                HCatPartition targetPartition = (HCatPartition)targetPartitions.get(i);
                Assert.assertEquals((String)"Column schema doesn't match.", (Object)sourcePartition.getColumns(), (Object)targetPartition.getColumns());
                Assert.assertEquals((String)"InputFormat doesn't match.", (Object)sourcePartition.getInputFormat(), (Object)targetPartition.getInputFormat());
                Assert.assertEquals((String)"OutputFormat doesn't match.", (Object)sourcePartition.getOutputFormat(), (Object)targetPartition.getOutputFormat());
                Assert.assertEquals((String)"SerDe doesn't match.", (Object)sourcePartition.getSerDe(), (Object)targetPartition.getSerDe());
                Assert.assertEquals((String)"SerDe params don't match.", (Object)sourcePartition.getSerdeParams(), (Object)targetPartition.getSerdeParams());
            }
        }
        catch (Exception unexpected) {
            LOG.error("Unexpected exception! ", (Throwable)unexpected);
            Assert.assertTrue((String)("Unexpected exception! " + unexpected.getMessage()), (boolean)false);
        }
    }

    @Test
    public void testPartitionSpecRegistrationWithCustomSchema() throws Exception {
        try {
            this.startReplicationTargetMetaStoreIfRequired();
            String dbName = "myDb";
            String tableName = "myTable";
            this.sourceMetaStore().dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            this.sourceMetaStore().createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            ArrayList<HCatFieldSchema> columnSchema = new ArrayList<HCatFieldSchema>(Arrays.asList(new HCatFieldSchema("foo", HCatFieldSchema.Type.INT, ""), new HCatFieldSchema("bar", HCatFieldSchema.Type.STRING, "")));
            List<HCatFieldSchema> partitionSchema = Arrays.asList(new HCatFieldSchema("dt", HCatFieldSchema.Type.STRING, ""), new HCatFieldSchema("grid", HCatFieldSchema.Type.STRING, ""));
            HCatTable sourceTable = new HCatTable("myDb", "myTable").cols(columnSchema).partCols(partitionSchema).comment("Source table.");
            this.sourceMetaStore().createTable(HCatCreateTableDesc.create((HCatTable)sourceTable).build());
            sourceTable = this.sourceMetaStore().getTable("myDb", "myTable");
            Assert.assertNotNull((String)"Table couldn't be queried for. ", (Object)sourceTable);
            HashMap<String, String> partitionSpec_1 = new HashMap<String, String>();
            partitionSpec_1.put("grid", "AB");
            partitionSpec_1.put("dt", "2011_12_31");
            HCatPartition sourcePartition_1 = new HCatPartition(sourceTable, partitionSpec_1, TestHCatClient.makePartLocation(sourceTable, partitionSpec_1));
            this.sourceMetaStore().addPartition(HCatAddPartitionDesc.create((HCatPartition)sourcePartition_1).build());
            Assert.assertEquals((String)"Unexpected number of partitions. ", (long)1L, (long)this.sourceMetaStore().getPartitions("myDb", "myTable").size());
            HCatPartition addedPartition_1 = this.sourceMetaStore().getPartition("myDb", "myTable", partitionSpec_1);
            Assert.assertEquals((String)"Column schema doesn't match.", (Object)sourceTable.getCols(), (Object)addedPartition_1.getColumns());
            Assert.assertEquals((String)"InputFormat doesn't match.", (Object)sourceTable.getInputFileFormat(), (Object)addedPartition_1.getInputFormat());
            Assert.assertEquals((String)"OutputFormat doesn't match.", (Object)sourceTable.getOutputFileFormat(), (Object)addedPartition_1.getOutputFormat());
            Assert.assertEquals((String)"SerDe doesn't match.", (Object)sourceTable.getSerdeLib(), (Object)addedPartition_1.getSerDe());
            Assert.assertEquals((String)"SerDe params don't match.", (Object)sourceTable.getSerdeParams(), (Object)addedPartition_1.getSerdeParams());
            this.targetMetaStore().dropDatabase("myDb", true, HCatClient.DropDBMode.CASCADE);
            this.targetMetaStore().createDatabase(HCatCreateDBDesc.create((String)"myDb").build());
            HCatTable targetTable = this.targetMetaStore().deserializeTable(this.sourceMetaStore().serializeTable(sourceTable));
            this.targetMetaStore().createTable(HCatCreateTableDesc.create((HCatTable)targetTable).build());
            targetTable = this.targetMetaStore().getTable("myDb", "myTable");
            Assert.assertEquals((String)"Created table doesn't match the source.", (Object)HCatTable.NO_DIFF, (Object)targetTable.diff(sourceTable));
            ArrayList<HCatFieldSchema> newColumnSchema = new ArrayList<HCatFieldSchema>(columnSchema);
            newColumnSchema.add(new HCatFieldSchema("goo_new", HCatFieldSchema.Type.DOUBLE, ""));
            HashMap<String, String> tableParams = new HashMap<String, String>(1);
            tableParams.put("orc.compress", "ZLIB");
            sourceTable.cols(newColumnSchema).fileFormat("orcfile").tblProps(tableParams).serdeParam("field.delim", Character.toString('\u0001'));
            this.sourceMetaStore().updateTableSchema("myDb", "myTable", sourceTable);
            sourceTable = this.sourceMetaStore().getTable("myDb", "myTable");
            HashMap<String, String> partitionSpec_2 = new HashMap<String, String>();
            partitionSpec_2.put("grid", "AB");
            partitionSpec_2.put("dt", "2012_01_01");
            HCatPartition sourcePartition_2 = new HCatPartition(sourceTable, partitionSpec_2, TestHCatClient.makePartLocation(sourceTable, partitionSpec_2));
            this.sourceMetaStore().addPartition(HCatAddPartitionDesc.create((HCatPartition)sourcePartition_2).build());
            HCatPartitionSpec sourcePartitionSpec = this.sourceMetaStore().getPartitionSpecs("myDb", "myTable", -1);
            Assert.assertEquals((String)"Unexpected number of source partitions.", (long)2L, (long)sourcePartitionSpec.size());
            List partitionSpecString = this.sourceMetaStore().serializePartitionSpec(sourcePartitionSpec);
            HCatPartitionSpec targetPartitionSpec = this.targetMetaStore().deserializePartitionSpec(partitionSpecString);
            Assert.assertEquals((String)"Could not add the expected number of partitions.", (long)sourcePartitionSpec.size(), (long)this.targetMetaStore().addPartitionSpec(targetPartitionSpec));
            targetPartitionSpec = this.targetMetaStore().getPartitionSpecs("myDb", "myTable", -1);
            Assert.assertEquals((String)"Could not retrieve the expected number of partitions.", (long)sourcePartitionSpec.size(), (long)targetPartitionSpec.size());
            HCatPartitionSpec.HCatPartitionIterator sourceIterator = sourcePartitionSpec.getPartitionIterator();
            HCatPartitionSpec.HCatPartitionIterator targetIterator = targetPartitionSpec.getPartitionIterator();
            while (targetIterator.hasNext()) {
                Assert.assertTrue((String)"Fewer target partitions than source.", (boolean)sourceIterator.hasNext());
                HCatPartition sourcePartition = sourceIterator.next();
                HCatPartition targetPartition = targetIterator.next();
                Assert.assertEquals((String)"Column schema doesn't match.", (Object)sourcePartition.getColumns(), (Object)targetPartition.getColumns());
                Assert.assertEquals((String)"InputFormat doesn't match.", (Object)sourcePartition.getInputFormat(), (Object)targetPartition.getInputFormat());
                Assert.assertEquals((String)"OutputFormat doesn't match.", (Object)sourcePartition.getOutputFormat(), (Object)targetPartition.getOutputFormat());
                Assert.assertEquals((String)"SerDe doesn't match.", (Object)sourcePartition.getSerDe(), (Object)targetPartition.getSerDe());
                Assert.assertEquals((String)"SerDe params don't match.", (Object)sourcePartition.getSerdeParams(), (Object)targetPartition.getSerdeParams());
            }
        }
        catch (Exception unexpected) {
            LOG.error("Unexpected exception! ", (Throwable)unexpected);
            Assert.assertTrue((String)("Unexpected exception! " + unexpected.getMessage()), (boolean)false);
        }
    }

    static {
        isReplicationTargetHCatRunning = false;
        useExternalMS = false;
    }
}

