/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.common.HCatException;

public class HCatReplicationTaskIterator
implements Iterator<ReplicationTask> {
    private HCatClient hcatClient;
    private IMetaStoreClient.NotificationFilter filter;
    private int maxEvents;
    private int batchSize;
    private Iterator<HCatNotificationEvent> batchIter = null;
    private List<HCatNotificationEvent> batch = null;
    private long pos;
    private long maxPos;
    private int eventCount;

    public HCatReplicationTaskIterator(HCatClient hcatClient, long eventFrom, int maxEvents, String dbName, String tableName) throws HCatException {
        this.init(hcatClient, eventFrom, maxEvents, new HCatReplicationTaskIteratorNotificationFilter(dbName, tableName));
    }

    public HCatReplicationTaskIterator(HCatClient hcatClient, long eventFrom, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws HCatException {
        this.init(hcatClient, eventFrom, maxEvents, filter);
    }

    private void init(HCatClient hcatClient, long eventFrom, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws HCatException {
        this.hcatClient = hcatClient;
        this.filter = filter;
        this.pos = eventFrom;
        this.maxEvents = maxEvents < 1 ? Integer.MAX_VALUE : maxEvents;
        this.batchSize = Integer.parseInt(hcatClient.getConfVal(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX.varname, "50"));
        this.eventCount = 0;
        this.maxPos = hcatClient.getCurrentNotificationEventId();
    }

    private void fetchNextBatch() throws HCatException {
        this.batch = this.hcatClient.getNextNotification(this.pos, this.batchSize, this.filter);
        this.batchIter = this.batch.iterator();
        if (this.batch.isEmpty()) {
            this.pos += (long)this.batchSize;
            if (this.pos < this.maxPos) {
                this.fetchNextBatch();
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.eventCount >= this.maxEvents) {
            return false;
        }
        if (this.batchIter != null && this.batchIter.hasNext()) {
            return true;
        }
        try {
            this.fetchNextBatch();
        }
        catch (HCatException e) {
            throw new RuntimeException(e);
        }
        return !this.batch.isEmpty();
    }

    @Override
    public ReplicationTask next() {
        ++this.eventCount;
        HCatNotificationEvent ev = this.batchIter.next();
        this.pos = ev.getEventId();
        return ReplicationTask.create(this.hcatClient, ev);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported on HCatReplicationTaskIterator");
    }

    private class HCatReplicationTaskIteratorNotificationFilter
    implements IMetaStoreClient.NotificationFilter {
        private String dbName;
        private String tableName;

        public HCatReplicationTaskIteratorNotificationFilter(String dbName, String tableName) {
            this.dbName = dbName;
            this.tableName = tableName;
        }

        public boolean accept(NotificationEvent event) {
            if (event == null) {
                return false;
            }
            if (this.dbName == null) {
                return true;
            }
            return this.dbName.equalsIgnoreCase(event.getDbName()) && (this.tableName == null || this.tableName.equalsIgnoreCase(event.getTableName()));
        }
    }
}

