/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.CommandTestUtils;
import org.apache.hive.hcatalog.api.repl.NoopReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.StagingDirectoryProvider;
import org.apache.hive.hcatalog.api.repl.commands.DropDatabaseCommand;
import org.apache.hive.hcatalog.api.repl.commands.DropPartitionCommand;
import org.apache.hive.hcatalog.api.repl.commands.DropTableCommand;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.api.repl.commands.NoopCommand;
import org.apache.hive.hcatalog.api.repl.exim.AddPartitionReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.AlterPartitionReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.AlterTableReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.CreateDatabaseReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.CreateTableReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.DropDatabaseReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.DropPartitionReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.DropTableReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.EximReplicationTaskFactory;
import org.apache.hive.hcatalog.api.repl.exim.InsertReplicationTask;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.apache.hive.hcatalog.messaging.MessageFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEximReplicationTasks {
    private static MessageFactory msgFactory = MessageFactory.getInstance();
    private static StagingDirectoryProvider stagingDirectoryProvider = new StagingDirectoryProvider.TrivialImpl("/tmp", "/");
    private static HCatClient client;
    static Function<String, String> debugMapping;

    @BeforeClass
    public static void setUpBeforeClass() throws HCatException {
        client = HCatClient.create((Configuration)new HiveConf());
        ReplicationTask.resetFactory(EximReplicationTaskFactory.class);
    }

    @Test
    public void testDebugMapper() {
        Assert.assertEquals((Object)"BlahhalB", (Object)debugMapping.apply((Object)"Blah"));
        Assert.assertEquals(null, (Object)debugMapping.apply(null));
        Assert.assertEquals((Object)"", (Object)debugMapping.apply((Object)""));
    }

    @Test
    public void testCreateDb() {
        Database db = new Database();
        db.setName("testdb");
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "CREATE_DATABASE", msgFactory.buildCreateDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyCreateDbReplicationTask(rtask);
    }

    private static void verifyCreateDbReplicationTask(ReplicationTask rtask) {
        Assert.assertEquals(CreateDatabaseReplicationTask.class, rtask.getClass());
        Assert.assertTrue((String)"CreateDatabaseReplicationTask should be a noop", (boolean)(rtask instanceof NoopReplicationTask));
        Assert.assertEquals((Object)false, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        for (Command c : rtask.getSrcWhCommands()) {
            Assert.assertEquals(NoopCommand.class, c.getClass());
        }
        for (Command c : rtask.getDstWhCommands()) {
            Assert.assertEquals(NoopCommand.class, c.getClass());
        }
    }

    @Test
    public void testDropDb() throws IOException {
        Database db = new Database();
        db.setName("testdb");
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "DROP_DATABASE", msgFactory.buildCreateDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyDropDbReplicationTask(rtask);
    }

    private static void verifyDropDbReplicationTask(ReplicationTask rtask) throws IOException {
        Assert.assertEquals(DropDatabaseReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)false, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        rtask.withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        for (Command c : rtask.getSrcWhCommands()) {
            Assert.assertEquals(NoopCommand.class, c.getClass());
        }
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(DropDatabaseCommand.class, ((Command)dstCommands.get(0)).getClass());
        DropDatabaseCommand dropDatabaseCommand = new DropDatabaseCommand((String)debugMapping.apply((Object)rtask.getEvent().getDbName()), rtask.getEvent().getEventId());
        Assert.assertEquals((Object)ReplicationUtils.serializeCommand((Command)dropDatabaseCommand), (Object)ReplicationUtils.serializeCommand((Command)((Command)dstCommands.get(0))));
    }

    @Test
    public void testCreateTable() throws IOException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "CREATE_TABLE", msgFactory.buildCreateTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyCreateTableReplicationTask(rtask);
    }

    private static void verifyCreateTableReplicationTask(ReplicationTask rtask) throws IOException {
        Assert.assertEquals(CreateTableReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)true, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)false, (Object)rtask.isActionable());
        rtask.withSrcStagingDirProvider(stagingDirectoryProvider).withDstStagingDirProvider(stagingDirectoryProvider).withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        ArrayList srcCommands = Lists.newArrayList((Iterable)rtask.getSrcWhCommands());
        Assert.assertEquals((long)1L, (long)srcCommands.size());
        Assert.assertEquals(ExportCommand.class, ((Command)srcCommands.get(0)).getClass());
        ExportCommand exportCommand = TestEximReplicationTasks.getExpectedExportCommand(rtask, null, false);
        Assert.assertEquals((Object)ReplicationUtils.serializeCommand((Command)exportCommand), (Object)ReplicationUtils.serializeCommand((Command)((Command)srcCommands.get(0))));
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(ImportCommand.class, ((Command)dstCommands.get(0)).getClass());
        ImportCommand importCommand = TestEximReplicationTasks.getExpectedImportCommand(rtask, null, false);
        Assert.assertEquals((Object)ReplicationUtils.serializeCommand((Command)importCommand), (Object)ReplicationUtils.serializeCommand((Command)((Command)dstCommands.get(0))));
    }

    @Test
    public void testDropTable() throws IOException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "DROP_TABLE", msgFactory.buildDropTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyDropTableReplicationTask(rtask);
    }

    private static void verifyDropTableReplicationTask(ReplicationTask rtask) throws IOException {
        Assert.assertEquals(DropTableReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)false, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        rtask.withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        for (Command c : rtask.getSrcWhCommands()) {
            Assert.assertEquals(NoopCommand.class, c.getClass());
        }
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(DropTableCommand.class, ((Command)dstCommands.get(0)).getClass());
        DropTableCommand dropTableCommand = new DropTableCommand((String)debugMapping.apply((Object)rtask.getEvent().getDbName()), (String)debugMapping.apply((Object)rtask.getEvent().getTableName()), true, rtask.getEvent().getEventId());
        Assert.assertEquals((Object)ReplicationUtils.serializeCommand((Command)dropTableCommand), (Object)ReplicationUtils.serializeCommand((Command)((Command)dstCommands.get(0))));
    }

    @Test
    public void testAlterTable() throws IOException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "ALTER_TABLE", msgFactory.buildAlterTableMessage(t, t, Long.valueOf(t.getWriteId())).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyAlterTableReplicationTask(rtask);
    }

    private static void verifyAlterTableReplicationTask(ReplicationTask rtask) throws IOException {
        Assert.assertEquals(AlterTableReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)true, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)false, (Object)rtask.isActionable());
        rtask.withSrcStagingDirProvider(stagingDirectoryProvider).withDstStagingDirProvider(stagingDirectoryProvider).withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        ArrayList srcCommands = Lists.newArrayList((Iterable)rtask.getSrcWhCommands());
        Assert.assertEquals((long)1L, (long)srcCommands.size());
        Assert.assertEquals(ExportCommand.class, ((Command)srcCommands.get(0)).getClass());
        ExportCommand exportCommand = TestEximReplicationTasks.getExpectedExportCommand(rtask, null, true);
        Assert.assertEquals((Object)ReplicationUtils.serializeCommand((Command)exportCommand), (Object)ReplicationUtils.serializeCommand((Command)((Command)srcCommands.get(0))));
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(ImportCommand.class, ((Command)dstCommands.get(0)).getClass());
        ImportCommand importCommand = TestEximReplicationTasks.getExpectedImportCommand(rtask, null, true);
        Assert.assertEquals((Object)ReplicationUtils.serializeCommand((Command)importCommand), (Object)ReplicationUtils.serializeCommand((Command)((Command)dstCommands.get(0))));
    }

    @Test
    public void testAddPartition() throws IOException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        List pkeys = HCatSchemaUtils.getFieldSchemas((List)HCatSchemaUtils.getHCatSchema((String)"a:int,b:string").getFields());
        t.setPartitionKeys(pkeys);
        ArrayList<Partition> addedPtns = new ArrayList<Partition>();
        addedPtns.add(TestEximReplicationTasks.createPtn(t, Arrays.asList("120", "abc")));
        addedPtns.add(TestEximReplicationTasks.createPtn(t, Arrays.asList("201", "xyz")));
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "ADD_PARTITION", msgFactory.buildAddPartitionMessage(t, addedPtns.iterator()).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyAddPartitionReplicationTask(rtask, t, addedPtns);
    }

    private static void verifyAddPartitionReplicationTask(ReplicationTask rtask, Table table, List<Partition> addedPtns) throws IOException {
        Assert.assertEquals(AddPartitionReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)true, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)false, (Object)rtask.isActionable());
        rtask.withSrcStagingDirProvider(stagingDirectoryProvider).withDstStagingDirProvider(stagingDirectoryProvider).withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        ArrayList srcCommands = Lists.newArrayList((Iterable)rtask.getSrcWhCommands());
        Assert.assertEquals((long)2L, (long)srcCommands.size());
        Assert.assertEquals(ExportCommand.class, ((Command)srcCommands.get(0)).getClass());
        Assert.assertEquals(ExportCommand.class, ((Command)srcCommands.get(1)).getClass());
        ExportCommand exportCommand1 = TestEximReplicationTasks.getExpectedExportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, addedPtns.get(0)), false);
        ExportCommand exportCommand2 = TestEximReplicationTasks.getExpectedExportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, addedPtns.get(1)), false);
        CommandTestUtils.compareCommands((Command)exportCommand1, (Command)srcCommands.get(0), true);
        CommandTestUtils.compareCommands((Command)exportCommand2, (Command)srcCommands.get(1), true);
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)2L, (long)dstCommands.size());
        Assert.assertEquals(ImportCommand.class, ((Command)dstCommands.get(0)).getClass());
        Assert.assertEquals(ImportCommand.class, ((Command)dstCommands.get(1)).getClass());
        ImportCommand importCommand1 = TestEximReplicationTasks.getExpectedImportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, addedPtns.get(0)), false);
        ImportCommand importCommand2 = TestEximReplicationTasks.getExpectedImportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, addedPtns.get(1)), false);
        CommandTestUtils.compareCommands((Command)importCommand1, (Command)dstCommands.get(0), true);
        CommandTestUtils.compareCommands((Command)importCommand2, (Command)dstCommands.get(1), true);
    }

    private static Map<String, String> getPtnDesc(Table t, Partition p) {
        Assert.assertEquals((long)t.getPartitionKeysSize(), (long)p.getValuesSize());
        HashMap<String, String> retval = new HashMap<String, String>();
        Iterator pval = p.getValuesIterator();
        for (FieldSchema fs : t.getPartitionKeys()) {
            retval.put(fs.getName(), (String)pval.next());
        }
        return retval;
    }

    private static Partition createPtn(Table t, List<String> pvals) {
        Partition ptn = new Partition();
        ptn.setDbName(t.getDbName());
        ptn.setTableName(t.getTableName());
        ptn.setValues(pvals);
        return ptn;
    }

    @Test
    public void testDropPartition() throws HCatException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        List pkeys = HCatSchemaUtils.getFieldSchemas((List)HCatSchemaUtils.getHCatSchema((String)"a:int,b:string").getFields());
        t.setPartitionKeys(pkeys);
        Partition p = TestEximReplicationTasks.createPtn(t, Arrays.asList("102", "lmn"));
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "DROP_PARTITION", msgFactory.buildDropPartitionMessage(t, Collections.singletonList(p).iterator()).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyDropPartitionReplicationTask(rtask, t, p);
    }

    private static void verifyDropPartitionReplicationTask(ReplicationTask rtask, Table table, Partition ptn) {
        Assert.assertEquals(DropPartitionReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)false, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        rtask.withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        for (Command c : rtask.getSrcWhCommands()) {
            Assert.assertEquals(NoopCommand.class, c.getClass());
        }
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(DropPartitionCommand.class, ((Command)dstCommands.get(0)).getClass());
        DropPartitionCommand dropPartitionCommand = new DropPartitionCommand((String)debugMapping.apply((Object)rtask.getEvent().getDbName()), (String)debugMapping.apply((Object)rtask.getEvent().getTableName()), TestEximReplicationTasks.getPtnDesc(table, ptn), true, rtask.getEvent().getEventId());
        CommandTestUtils.compareCommands((Command)dropPartitionCommand, (Command)dstCommands.get(0), true);
    }

    @Test
    public void testAlterPartition() throws HCatException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        List pkeys = HCatSchemaUtils.getFieldSchemas((List)HCatSchemaUtils.getHCatSchema((String)"a:int,b:string").getFields());
        t.setPartitionKeys(pkeys);
        Partition p = TestEximReplicationTasks.createPtn(t, Arrays.asList("102", "lmn"));
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "ALTER_PARTITION", msgFactory.buildAlterPartitionMessage(t, p, p, Long.valueOf(p.getWriteId())).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyAlterPartitionReplicationTask(rtask, t, p);
    }

    private static void verifyAlterPartitionReplicationTask(ReplicationTask rtask, Table table, Partition ptn) {
        Assert.assertEquals(AlterPartitionReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)true, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)false, (Object)rtask.isActionable());
        rtask.withSrcStagingDirProvider(stagingDirectoryProvider).withDstStagingDirProvider(stagingDirectoryProvider).withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        ArrayList srcCommands = Lists.newArrayList((Iterable)rtask.getSrcWhCommands());
        Assert.assertEquals((long)1L, (long)srcCommands.size());
        Assert.assertEquals(ExportCommand.class, ((Command)srcCommands.get(0)).getClass());
        ExportCommand exportCommand = TestEximReplicationTasks.getExpectedExportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, ptn), true);
        CommandTestUtils.compareCommands((Command)exportCommand, (Command)srcCommands.get(0), true);
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(ImportCommand.class, ((Command)dstCommands.get(0)).getClass());
        ImportCommand importCommand = TestEximReplicationTasks.getExpectedImportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, ptn), true);
        CommandTestUtils.compareCommands((Command)importCommand, (Command)dstCommands.get(0), true);
    }

    @Test
    public void testInsert() throws HCatException {
        Table t = new Table();
        t.setDbName("testdb");
        t.setTableName("testtable");
        List pkeys = HCatSchemaUtils.getFieldSchemas((List)HCatSchemaUtils.getHCatSchema((String)"a:int,b:string").getFields());
        t.setPartitionKeys(pkeys);
        Partition p = TestEximReplicationTasks.createPtn(t, Arrays.asList("102", "lmn"));
        List<String> files = Arrays.asList("/tmp/test123");
        NotificationEvent event = new NotificationEvent(TestEximReplicationTasks.getEventId(), TestEximReplicationTasks.getTime(), "INSERT", msgFactory.buildInsertMessage(t.getDbName(), t.getTableName(), TestEximReplicationTasks.getPtnDesc(t, p), files).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        HCatNotificationEvent hev = new HCatNotificationEvent(event);
        ReplicationTask rtask = ReplicationTask.create((HCatClient)client, (HCatNotificationEvent)hev);
        Assert.assertEquals((Object)hev.toString(), (Object)rtask.getEvent().toString());
        TestEximReplicationTasks.verifyInsertReplicationTask(rtask, t, p);
    }

    private static void verifyInsertReplicationTask(ReplicationTask rtask, Table table, Partition ptn) {
        Assert.assertEquals(InsertReplicationTask.class, rtask.getClass());
        Assert.assertEquals((Object)true, (Object)rtask.needsStagingDirs());
        Assert.assertEquals((Object)false, (Object)rtask.isActionable());
        rtask.withSrcStagingDirProvider(stagingDirectoryProvider).withDstStagingDirProvider(stagingDirectoryProvider).withDbNameMapping(debugMapping).withTableNameMapping(debugMapping);
        Assert.assertEquals((Object)true, (Object)rtask.isActionable());
        ArrayList srcCommands = Lists.newArrayList((Iterable)rtask.getSrcWhCommands());
        Assert.assertEquals((long)1L, (long)srcCommands.size());
        Assert.assertEquals(ExportCommand.class, ((Command)srcCommands.get(0)).getClass());
        ExportCommand exportCommand = TestEximReplicationTasks.getExpectedExportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, ptn), false);
        CommandTestUtils.compareCommands((Command)exportCommand, (Command)srcCommands.get(0), true);
        ArrayList dstCommands = Lists.newArrayList((Iterable)rtask.getDstWhCommands());
        Assert.assertEquals((long)1L, (long)dstCommands.size());
        Assert.assertEquals(ImportCommand.class, ((Command)dstCommands.get(0)).getClass());
        ImportCommand importCommand = TestEximReplicationTasks.getExpectedImportCommand(rtask, TestEximReplicationTasks.getPtnDesc(table, ptn), false);
        CommandTestUtils.compareCommands((Command)importCommand, (Command)dstCommands.get(0), true);
    }

    private static long getEventId() {
        return 42L;
    }

    private static int getTime() {
        return 1729;
    }

    private static ImportCommand getExpectedImportCommand(ReplicationTask rtask, Map<String, String> ptnDesc, boolean isMetadataOnly) {
        String dbName = rtask.getEvent().getDbName();
        String tableName = rtask.getEvent().getTableName();
        return new ImportCommand(ReplicationUtils.mapIfMapAvailable((String)dbName, debugMapping), ReplicationUtils.mapIfMapAvailable((String)tableName, debugMapping), ptnDesc, stagingDirectoryProvider.getStagingDirectory(ReplicationUtils.getUniqueKey((long)rtask.getEvent().getEventId(), (String)dbName, (String)tableName, ptnDesc)), isMetadataOnly, rtask.getEvent().getEventId());
    }

    private static ExportCommand getExpectedExportCommand(ReplicationTask rtask, Map<String, String> ptnDesc, boolean isMetadataOnly) {
        String dbName = rtask.getEvent().getDbName();
        String tableName = rtask.getEvent().getTableName();
        return new ExportCommand(dbName, tableName, ptnDesc, stagingDirectoryProvider.getStagingDirectory(ReplicationUtils.getUniqueKey((long)rtask.getEvent().getEventId(), (String)dbName, (String)tableName, ptnDesc)), isMetadataOnly, rtask.getEvent().getEventId());
    }

    static {
        debugMapping = new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String s) {
                if (s == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder(s);
                return sb.toString() + sb.reverse().toString();
            }
        };
    }
}

