/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.HcatTestUtils;
import org.apache.hive.hcatalog.api.HCatAddPartitionDesc;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatCreateDBDesc;
import org.apache.hive.hcatalog.api.HCatCreateTableDesc;
import org.apache.hive.hcatalog.api.HCatDatabase;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.api.ObjectNotFoundException;
import org.apache.hive.hcatalog.api.TestHCatClient;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.CommandTestUtils;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.DropDatabaseCommand;
import org.apache.hive.hcatalog.api.repl.commands.DropPartitionCommand;
import org.apache.hive.hcatalog.api.repl.commands.DropTableCommand;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCommands {
    private static Logger LOG = LoggerFactory.getLogger((String)CommandTestUtils.class.getName());
    private static HiveConf hconf;
    private static IDriver driver;
    private static HCatClient client;
    private static String TEST_PATH;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestHCatClient.startMetaStoreServer();
        hconf = TestHCatClient.getConf();
        hconf.set(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, "");
        hconf.set(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET.varname, "false");
        hconf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        TEST_PATH = System.getProperty("test.warehouse.dir", "/tmp") + "/" + TestCommands.class.getCanonicalName() + "-" + System.currentTimeMillis();
        Path testPath = new Path(TEST_PATH);
        FileSystem fs = FileSystem.get((URI)testPath.toUri(), (Configuration)hconf);
        fs.mkdirs(testPath);
        driver = DriverFactory.newDriver((HiveConf)hconf);
        SessionState.start((SessionState)new CliSessionState(hconf));
        client = HCatClient.create((Configuration)hconf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestHCatClient.tearDown();
    }

    @Test
    public void testDropDatabaseCommand() throws HCatException, CommandProcessorException {
        String dbName = "cmd_testdb";
        int evid = 999;
        DropDatabaseCommand testCmd = new DropDatabaseCommand(dbName, (long)evid);
        Assert.assertEquals((long)evid, (long)testCmd.getEventId());
        Assert.assertEquals((long)1L, (long)testCmd.get().size());
        Assert.assertEquals((Object)true, (Object)testCmd.isRetriable());
        Assert.assertEquals((Object)false, (Object)testCmd.isUndoable());
        CommandTestUtils.testCommandSerialization((Command)testCmd);
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        client.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        HCatDatabase db = client.getDatabase(dbName);
        Assert.assertNotNull((Object)db);
        LOG.info("About to run :" + (String)testCmd.get().get(0));
        driver.run((String)testCmd.get().get(0));
        Exception onfe = null;
        try {
            HCatDatabase hCatDatabase = client.getDatabase(dbName);
        }
        catch (Exception e) {
            onfe = e;
        }
        Assert.assertNotNull((Object)onfe);
        Assert.assertTrue((boolean)(onfe instanceof ObjectNotFoundException));
    }

    @Test
    public void testDropTableCommand() throws HCatException, CommandProcessorException {
        String dbName = "cmd_testdb";
        String tableName = "cmd_testtable";
        int evid = 789;
        List cols = HCatSchemaUtils.getHCatSchema((String)"a:int,b:string").getFields();
        DropTableCommand testReplicatedDropCmd = new DropTableCommand(dbName, tableName, true, (long)evid);
        Assert.assertEquals((long)evid, (long)testReplicatedDropCmd.getEventId());
        Assert.assertEquals((long)1L, (long)testReplicatedDropCmd.get().size());
        Assert.assertEquals((Object)true, (Object)testReplicatedDropCmd.isRetriable());
        Assert.assertEquals((Object)false, (Object)testReplicatedDropCmd.isUndoable());
        CommandTestUtils.testCommandSerialization((Command)testReplicatedDropCmd);
        DropTableCommand testNormalDropCmd = new DropTableCommand(dbName, tableName, false, (long)evid);
        Assert.assertEquals((long)evid, (long)testNormalDropCmd.getEventId());
        Assert.assertEquals((long)1L, (long)testNormalDropCmd.get().size());
        Assert.assertEquals((Object)true, (Object)testNormalDropCmd.isRetriable());
        Assert.assertEquals((Object)false, (Object)testNormalDropCmd.isUndoable());
        CommandTestUtils.testCommandSerialization((Command)testNormalDropCmd);
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        client.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        HashMap<String, String> tprops = new HashMap<String, String>();
        tprops.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid + 5));
        HCatTable tableToCreate = new HCatTable(dbName, tableName).tblProps(tprops).cols(cols);
        client.createTable(HCatCreateTableDesc.create((HCatTable)tableToCreate).build());
        HCatTable t1 = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)t1);
        LOG.info("About to run :" + (String)testReplicatedDropCmd.get().get(0));
        driver.run((String)testReplicatedDropCmd.get().get(0));
        HCatTable t2 = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)t2);
        LOG.info("About to run :" + (String)testNormalDropCmd.get().get(0));
        driver.run((String)testNormalDropCmd.get().get(0));
        Exception onfe = null;
        try {
            HCatTable hCatTable = client.getTable(dbName, tableName);
        }
        catch (Exception e) {
            onfe = e;
        }
        Assert.assertNotNull((Object)onfe);
        Assert.assertTrue((boolean)(onfe instanceof ObjectNotFoundException));
        HashMap<String, String> tprops2 = new HashMap<String, String>();
        tprops2.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid - 5));
        HCatTable tableToCreate2 = new HCatTable(dbName, tableName).tblProps(tprops2).cols(cols);
        client.createTable(HCatCreateTableDesc.create((HCatTable)tableToCreate2).build());
        HCatTable t3 = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)t3);
        LOG.info("About to run :" + (String)testReplicatedDropCmd.get().get(0));
        driver.run((String)testReplicatedDropCmd.get().get(0));
        Exception onfe2 = null;
        try {
            HCatTable hCatTable = client.getTable(dbName, tableName);
        }
        catch (Exception e) {
            onfe2 = e;
        }
        Assert.assertNotNull((Object)onfe2);
        Assert.assertTrue((boolean)(onfe2 instanceof ObjectNotFoundException));
    }

    @Test
    public void testDropPartitionCommand() throws HCatException, MetaException, CommandProcessorException {
        String dbName = "cmd_testdb";
        String tableName = "cmd_testtable";
        int evid = 789;
        List pcols = HCatSchemaUtils.getHCatSchema((String)"b:string").getFields();
        List cols = HCatSchemaUtils.getHCatSchema((String)"a:int").getFields();
        HashMap<String, String> ptnDesc = new HashMap<String, String>();
        ptnDesc.put("b", "test");
        DropPartitionCommand testReplicatedDropPtnCmd = new DropPartitionCommand(dbName, tableName, ptnDesc, true, (long)evid);
        Assert.assertEquals((long)evid, (long)testReplicatedDropPtnCmd.getEventId());
        Assert.assertEquals((long)1L, (long)testReplicatedDropPtnCmd.get().size());
        Assert.assertEquals((Object)true, (Object)testReplicatedDropPtnCmd.isRetriable());
        Assert.assertEquals((Object)false, (Object)testReplicatedDropPtnCmd.isUndoable());
        CommandTestUtils.testCommandSerialization((Command)testReplicatedDropPtnCmd);
        DropPartitionCommand testNormalDropPtnCmd = new DropPartitionCommand(dbName, tableName, ptnDesc, false, (long)evid);
        Assert.assertEquals((long)evid, (long)testNormalDropPtnCmd.getEventId());
        Assert.assertEquals((long)1L, (long)testNormalDropPtnCmd.get().size());
        Assert.assertEquals((Object)true, (Object)testNormalDropPtnCmd.isRetriable());
        Assert.assertEquals((Object)false, (Object)testNormalDropPtnCmd.isUndoable());
        CommandTestUtils.testCommandSerialization((Command)testNormalDropPtnCmd);
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        client.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid + 5));
        HCatTable table = new HCatTable(dbName, tableName).tblProps(props).cols(cols).partCols(pcols);
        client.createTable(HCatCreateTableDesc.create((HCatTable)table).build());
        HCatTable tableCreated = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)tableCreated);
        HCatPartition ptnToAdd = new HCatPartition(tableCreated, ptnDesc, TestHCatClient.makePartLocation(tableCreated, ptnDesc)).parameters(props);
        client.addPartition(HCatAddPartitionDesc.create((HCatPartition)ptnToAdd).build());
        HCatPartition p1 = client.getPartition(dbName, tableName, ptnDesc);
        Assert.assertNotNull((Object)p1);
        LOG.info("About to run :" + (String)testReplicatedDropPtnCmd.get().get(0));
        driver.run((String)testReplicatedDropPtnCmd.get().get(0));
        HCatPartition p2 = client.getPartition(dbName, tableName, ptnDesc);
        Assert.assertNotNull((Object)p2);
        LOG.info("About to run :" + (String)testNormalDropPtnCmd.get().get(0));
        driver.run((String)testNormalDropPtnCmd.get().get(0));
        Exception onfe = null;
        try {
            HCatPartition hCatPartition = client.getPartition(dbName, tableName, ptnDesc);
        }
        catch (Exception e) {
            onfe = e;
        }
        Assert.assertNotNull((Object)onfe);
        Assert.assertTrue((boolean)(onfe instanceof ObjectNotFoundException));
        HashMap<String, String> props2 = new HashMap<String, String>();
        props2.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid - 5));
        HCatPartition ptnToAdd2 = new HCatPartition(tableCreated, ptnDesc, TestHCatClient.makePartLocation(tableCreated, ptnDesc)).parameters(props2);
        client.addPartition(HCatAddPartitionDesc.create((HCatPartition)ptnToAdd2).build());
        HCatPartition p3 = client.getPartition(dbName, tableName, ptnDesc);
        Assert.assertNotNull((Object)p3);
        LOG.info("About to run :" + (String)testReplicatedDropPtnCmd.get().get(0));
        driver.run((String)testReplicatedDropPtnCmd.get().get(0));
        Exception onfe2 = null;
        try {
            HCatPartition hCatPartition = client.getPartition(dbName, tableName, ptnDesc);
        }
        catch (Exception e) {
            onfe2 = e;
        }
        Assert.assertNotNull((Object)onfe2);
        Assert.assertTrue((boolean)(onfe2 instanceof ObjectNotFoundException));
    }

    @Test
    public void testDropTableCommand2() throws HCatException, MetaException, CommandProcessorException {
        String dbName = "cmd_testdb";
        String tableName = "cmd_testtable";
        int evid = 157;
        List pcols = HCatSchemaUtils.getHCatSchema((String)"b:string").getFields();
        List cols = HCatSchemaUtils.getHCatSchema((String)"a:int").getFields();
        DropTableCommand testReplicatedDropCmd = new DropTableCommand(dbName, tableName, true, (long)evid);
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        client.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        HashMap<String, String> tprops = new HashMap<String, String>();
        tprops.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid + 2));
        HCatTable table = new HCatTable(dbName, tableName).tblProps(tprops).cols(cols).partCols(pcols);
        client.createTable(HCatCreateTableDesc.create((HCatTable)table).build());
        HCatTable tableCreated = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)tableCreated);
        HashMap<String, String> ptnDesc1 = new HashMap<String, String>();
        ptnDesc1.put("b", "test-older");
        HashMap<String, String> props1 = new HashMap<String, String>();
        props1.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid - 5));
        HCatPartition ptnToAdd1 = new HCatPartition(tableCreated, ptnDesc1, TestHCatClient.makePartLocation(tableCreated, ptnDesc1)).parameters(props1);
        client.addPartition(HCatAddPartitionDesc.create((HCatPartition)ptnToAdd1).build());
        HashMap<String, String> ptnDesc2 = new HashMap<String, String>();
        ptnDesc2.put("b", "test-newer");
        HashMap<String, String> props2 = new HashMap<String, String>();
        props2.put(ReplicationUtils.REPL_STATE_ID, String.valueOf(evid + 5));
        HCatPartition ptnToAdd2 = new HCatPartition(tableCreated, ptnDesc2, TestHCatClient.makePartLocation(tableCreated, ptnDesc2)).parameters(props2);
        client.addPartition(HCatAddPartitionDesc.create((HCatPartition)ptnToAdd2).build());
        HCatPartition p1 = client.getPartition(dbName, tableName, ptnDesc1);
        Assert.assertNotNull((Object)p1);
        HCatPartition p2 = client.getPartition(dbName, tableName, ptnDesc2);
        Assert.assertNotNull((Object)p2);
        LOG.info("About to run :" + (String)testReplicatedDropCmd.get().get(0));
        driver.run((String)testReplicatedDropCmd.get().get(0));
        HCatTable t_stillExists = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)t_stillExists);
        HCatPartition p2_stillExists = client.getPartition(dbName, tableName, ptnDesc2);
        Exception onfe = null;
        try {
            HCatPartition hCatPartition = client.getPartition(dbName, tableName, ptnDesc1);
        }
        catch (Exception e) {
            onfe = e;
        }
        Assert.assertNotNull((Object)onfe);
        Assert.assertTrue((boolean)(onfe instanceof ObjectNotFoundException));
    }

    @Test
    public void testBasicReplEximCommands() throws IOException, CommandProcessorException {
        int evid = 111;
        String exportLocation = TEST_PATH + File.separator + "testBasicReplExim";
        Path tempPath = new Path(TEST_PATH, "testBasicReplEximTmp");
        String tempLocation = tempPath.toUri().getPath();
        String dbName = "exim";
        String tableName = "basicSrc";
        String importedTableName = "basicDst";
        List cols = HCatSchemaUtils.getHCatSchema((String)"b:string").getFields();
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        client.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        HCatTable table = new HCatTable(dbName, tableName).cols(cols).fileFormat("textfile");
        client.createTable(HCatCreateTableDesc.create((HCatTable)table).build());
        HCatTable t = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)t);
        String[] data = new String[]{"eleven", "twelve"};
        HcatTestUtils.createTestDataFile((String)tempLocation, (String[])data);
        driver.run("LOAD DATA LOCAL INPATH '" + tempLocation + "' OVERWRITE INTO TABLE " + dbName + "." + tableName);
        driver.run("SELECT * from " + dbName + "." + tableName);
        ArrayList values = new ArrayList();
        driver.getResults(values);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)data[0], values.get(0));
        Assert.assertEquals((Object)data[1], values.get(1));
        ExportCommand exportCmd = new ExportCommand(dbName, tableName, null, exportLocation, false, (long)evid);
        LOG.info("About to run :" + (String)exportCmd.get().get(0));
        driver.run((String)exportCmd.get().get(0));
        List exportPaths = exportCmd.cleanupLocationsAfterEvent();
        Assert.assertEquals((long)1L, (long)exportPaths.size());
        String metadata = TestCommands.getMetadataContents((String)exportPaths.get(0));
        LOG.info("Export returned the following _metadata contents:");
        LOG.info(metadata);
        Assert.assertTrue((String)(metadata + "did not match \"repl.scope\"=\"all\""), (boolean)metadata.matches(".*\"repl.scope\":\"all\".*"));
        Assert.assertTrue((String)(metadata + "has \"repl.last.id\""), (boolean)metadata.matches(".*\"repl.last.id\":.*"));
        ImportCommand importCmd = new ImportCommand(dbName, importedTableName, null, exportLocation, false, (long)evid);
        LOG.info("About to run :" + (String)importCmd.get().get(0));
        driver.run((String)importCmd.get().get(0));
        driver.run("SELECT * from " + dbName + "." + importedTableName);
        ArrayList values2 = new ArrayList();
        driver.getResults(values2);
        Assert.assertEquals((long)2L, (long)values2.size());
        Assert.assertEquals((Object)data[0], values2.get(0));
        Assert.assertEquals((Object)data[1], values2.get(1));
        HCatTable importedTable = client.getTable(dbName, importedTableName);
        Assert.assertNotNull((Object)importedTable);
        Assert.assertTrue((boolean)importedTable.getTblProps().containsKey("repl.last.id"));
    }

    @Test
    public void testMetadataReplEximCommands() throws IOException, CommandProcessorException {
        int evid = 222;
        String exportLocation = TEST_PATH + File.separator + "testMetadataReplExim";
        Path tempPath = new Path(TEST_PATH, "testMetadataReplEximTmp");
        String tempLocation = tempPath.toUri().getPath();
        String dbName = "exim";
        String tableName = "basicSrc";
        String importedTableName = "basicDst";
        List cols = HCatSchemaUtils.getHCatSchema((String)"b:string").getFields();
        client.dropDatabase(dbName, true, HCatClient.DropDBMode.CASCADE);
        client.createDatabase(HCatCreateDBDesc.create((String)dbName).ifNotExists(false).build());
        HCatTable table = new HCatTable(dbName, tableName).cols(cols).fileFormat("textfile");
        client.createTable(HCatCreateTableDesc.create((HCatTable)table).build());
        HCatTable t = client.getTable(dbName, tableName);
        Assert.assertNotNull((Object)t);
        String[] data = new String[]{"eleven", "twelve"};
        HcatTestUtils.createTestDataFile((String)tempLocation, (String[])data);
        driver.run("LOAD DATA LOCAL INPATH '" + tempLocation + "' OVERWRITE INTO TABLE " + dbName + "." + tableName);
        driver.run("SELECT * from " + dbName + "." + tableName);
        ArrayList values = new ArrayList();
        driver.getResults(values);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)data[0], values.get(0));
        Assert.assertEquals((Object)data[1], values.get(1));
        ExportCommand exportMdCmd = new ExportCommand(dbName, tableName, null, exportLocation, true, (long)evid);
        LOG.info("About to run :" + (String)exportMdCmd.get().get(0));
        driver.run((String)exportMdCmd.get().get(0));
        List exportPaths = exportMdCmd.cleanupLocationsAfterEvent();
        Assert.assertEquals((long)1L, (long)exportPaths.size());
        String metadata = TestCommands.getMetadataContents((String)exportPaths.get(0));
        LOG.info("Export returned the following _metadata contents:");
        LOG.info(metadata);
        Assert.assertTrue((String)(metadata + "did not match \"repl.scope\"=\"metadata\""), (boolean)metadata.matches(".*\"repl.scope\":\"metadata\".*"));
        Assert.assertTrue((String)(metadata + "has \"repl.last.id\""), (boolean)metadata.matches(".*\"repl.last.id\":.*"));
        ImportCommand importMdCmd = new ImportCommand(dbName, importedTableName, null, exportLocation, true, (long)evid);
        LOG.info("About to run :" + (String)importMdCmd.get().get(0));
        driver.run((String)importMdCmd.get().get(0));
        driver.run("SELECT * from " + dbName + "." + importedTableName);
        ArrayList values2 = new ArrayList();
        driver.getResults(values2);
        Assert.assertEquals((long)0L, (long)values2.size());
        HCatTable importedTable = client.getTable(dbName, importedTableName);
        Assert.assertNotNull((Object)importedTable);
        Assert.assertTrue((boolean)importedTable.getTblProps().containsKey("repl.last.id"));
    }

    @Test
    public void testNoopReplEximCommands() throws Exception {
        int evid = 333;
        String exportLocation = TEST_PATH + File.separator + "testNoopReplExim";
        String dbName = "doesNotExist" + System.currentTimeMillis();
        String tableName = "nope" + System.currentTimeMillis();
        ExportCommand noopExportCmd = new ExportCommand(dbName, tableName, null, exportLocation, false, (long)evid);
        LOG.info("About to run :" + (String)noopExportCmd.get().get(0));
        driver.run((String)noopExportCmd.get().get(0));
        List exportPaths = noopExportCmd.cleanupLocationsAfterEvent();
        Assert.assertEquals((long)1L, (long)exportPaths.size());
        String metadata = TestCommands.getMetadataContents((String)exportPaths.get(0));
        LOG.info("Export returned the following _metadata contents:");
        LOG.info(metadata);
        Assert.assertTrue((String)(metadata + "did not match \"repl.noop\"=\"true\""), (boolean)metadata.matches(".*\"repl.noop\":\"true\".*"));
        ImportCommand noopImportCmd = new ImportCommand(dbName, tableName, null, exportLocation, false, (long)evid);
        LOG.info("About to run :" + (String)noopImportCmd.get().get(0));
        driver.run((String)noopImportCmd.get().get(0));
        Exception onfe = null;
        try {
            HCatDatabase hCatDatabase = client.getDatabase(dbName);
        }
        catch (Exception e) {
            onfe = e;
        }
        Assert.assertNotNull((Object)onfe);
        Assert.assertTrue((boolean)(onfe instanceof ObjectNotFoundException));
    }

    private static String getMetadataContents(String exportPath) throws IOException {
        String line;
        Path mdFilePath = new Path(exportPath, "_metadata");
        FileSystem fs = FileSystem.get((URI)mdFilePath.toUri(), (Configuration)hconf);
        Assert.assertTrue((String)(mdFilePath.toUri().toString() + "does not exist"), (boolean)fs.exists(mdFilePath));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(mdFilePath)));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        reader.close();
        return sb.toString();
    }
}

