/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.EventUtils;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.ErroredReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationV1CompatRule
implements TestRule {
    protected static final Logger LOG = LoggerFactory.getLogger(ReplicationV1CompatRule.class);
    private static ThreadLocal<Long> testEventId = null;
    private IMetaStoreClient metaStoreClient = null;
    private HiveConf hconf = null;
    private List<String> testsToSkip = null;

    public ReplicationV1CompatRule(IMetaStoreClient metaStoreClient, HiveConf hconf) {
        this(metaStoreClient, hconf, new ArrayList<String>());
    }

    public ReplicationV1CompatRule(IMetaStoreClient metaStoreClient, HiveConf hconf, List<String> testsToSkip) {
        this.metaStoreClient = metaStoreClient;
        this.hconf = hconf;
        testEventId = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return ReplicationV1CompatRule.this.getCurrentNotificationId();
            }
        };
        this.testsToSkip = testsToSkip;
        LOG.info("Replv1 backward compatibility tester initialized at " + testEventId.get());
    }

    private Long getCurrentNotificationId() {
        CurrentNotificationEventId cid = null;
        try {
            cid = this.metaStoreClient.getCurrentNotificationEventId();
            Long l = cid.getEventId();
            return l == null ? 0L : l;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    public void doBackwardCompatibilityCheck(boolean eventsMustExist) {
        Long testEventIdPrev = testEventId.get();
        Long testEventIdNow = this.getCurrentNotificationId();
        testEventId.set(testEventIdNow);
        if (eventsMustExist) {
            Assert.assertTrue((String)("New events must exist between old[" + testEventIdPrev + "] and [" + testEventIdNow + "]"), (testEventIdNow > testEventIdPrev ? 1 : 0) != 0);
        } else if (testEventIdNow <= testEventIdPrev) {
            return;
        }
        this.doBackwardCompatibilityCheck(testEventIdPrev, testEventIdNow);
    }

    public void doBackwardCompatibilityCheck(long testEventIdBefore, long testEventIdAfter) {
        RuntimeException re;
        long timeBefore = System.currentTimeMillis();
        LinkedHashMap<NotificationEvent, RuntimeException> unhandledTasks = new LinkedHashMap<NotificationEvent, RuntimeException>();
        LinkedHashMap<NotificationEvent, RuntimeException> incompatibleTasks = new LinkedHashMap<NotificationEvent, RuntimeException>();
        int eventCount = 0;
        LOG.info("Checking replv1 backward compatibility for events between : " + testEventIdBefore + " -> " + testEventIdAfter);
        IMetaStoreClient.NotificationFilter evFilter = new IMetaStoreClient.NotificationFilter(){

            public boolean accept(NotificationEvent notificationEvent) {
                return true;
            }
        };
        EventUtils.MSClientNotificationFetcher evFetcher = new EventUtils.MSClientNotificationFetcher(this.metaStoreClient);
        try {
            EventUtils.NotificationEventIterator evIter = new EventUtils.NotificationEventIterator((EventUtils.NotificationFetcher)evFetcher, testEventIdBefore, Ints.checkedCast((long)(testEventIdAfter - testEventIdBefore)) + 1, evFilter);
            ReplicationTask.resetFactory(null);
            Assert.assertTrue((String)"We should have found some events", (boolean)evIter.hasNext());
            while (evIter.hasNext()) {
                ++eventCount;
                NotificationEvent ev = evIter.next();
                try {
                    ReplicationTask rtask = ReplicationTask.create((HCatClient)HCatClient.create((Configuration)this.hconf), (HCatNotificationEvent)new HCatNotificationEvent(ev));
                    if (!(rtask instanceof ErroredReplicationTask)) continue;
                    unhandledTasks.put(ev, ((ErroredReplicationTask)rtask).getCause());
                }
                catch (RuntimeException re2) {
                    incompatibleTasks.put(ev, re2);
                }
            }
        }
        catch (IOException e) {
            Assert.assertNull((String)"Got an exception when we shouldn't have - replv1 backward incompatibility issue:", (Object)e);
        }
        if (unhandledTasks.size() > 0) {
            LOG.warn("Events found that would not be coverable by replv1 replication: " + unhandledTasks.size());
            for (NotificationEvent ev : unhandledTasks.keySet()) {
                re = (RuntimeException)unhandledTasks.get(ev);
                LOG.warn("ErroredReplicationTask encountered - new event type does not correspond to a replv1 task:" + ev.toString(), (Throwable)re);
            }
        }
        if (incompatibleTasks.size() > 0) {
            LOG.warn("Events found that caused errors in replv1 replication: " + incompatibleTasks.size());
            for (NotificationEvent ev : incompatibleTasks.keySet()) {
                re = (RuntimeException)incompatibleTasks.get(ev);
                LOG.warn("RuntimeException encountered - new event type caused a replv1 break." + ev.toString(), (Throwable)re);
            }
        }
        Assert.assertEquals((long)0L, (long)incompatibleTasks.size());
        long timeAfter = System.currentTimeMillis();
        LOG.info("Backward compatibility check timing:" + timeBefore + " -> " + timeAfter + ", ev: " + testEventIdBefore + " => " + testEventIdAfter + ", #events processed=" + eventCount);
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Long prevNotificationId = ReplicationV1CompatRule.this.getCurrentNotificationId();
                statement.evaluate();
                Long currNotificationId = ReplicationV1CompatRule.this.getCurrentNotificationId();
                if (!ReplicationV1CompatRule.this.testsToSkip.contains(description.getMethodName())) {
                    ReplicationV1CompatRule.this.doBackwardCompatibilityCheck(prevNotificationId, currNotificationId);
                } else {
                    LOG.info("Skipping backward compatibility check, as requested, for test :" + description);
                }
            }
        };
    }

    public static @interface SkipReplV1CompatCheck {
    }
}

