/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.AddPartitionReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.AlterPartitionReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.AlterTableReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.CreateDatabaseReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.CreateTableReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.DropDatabaseReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.DropPartitionReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.DropTableReplicationTask;
import org.apache.hive.hcatalog.api.repl.exim.InsertReplicationTask;

public class EximReplicationTaskFactory
implements ReplicationTask.Factory {
    @Override
    public ReplicationTask create(HCatClient client, HCatNotificationEvent event) {
        if (event.getEventType().equals("CREATE_DATABASE")) {
            return new CreateDatabaseReplicationTask(event);
        }
        if (event.getEventType().equals("DROP_DATABASE")) {
            return new DropDatabaseReplicationTask(event);
        }
        if (event.getEventType().equals("CREATE_TABLE")) {
            return new CreateTableReplicationTask(event);
        }
        if (event.getEventType().equals("DROP_TABLE")) {
            return new DropTableReplicationTask(event);
        }
        if (event.getEventType().equals("ADD_PARTITION")) {
            return new AddPartitionReplicationTask(event);
        }
        if (event.getEventType().equals("DROP_PARTITION")) {
            return new DropPartitionReplicationTask(event);
        }
        if (event.getEventType().equals("ALTER_TABLE")) {
            return new AlterTableReplicationTask(event);
        }
        if (event.getEventType().equals("ALTER_PARTITION")) {
            return new AlterPartitionReplicationTask(event);
        }
        if (event.getEventType().equals("INSERT")) {
            return new InsertReplicationTask(event);
        }
        throw new IllegalStateException("Unrecognized Event type, no replication task available");
    }
}

